/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.gui.about;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import net.sf.portecle.FPortecle;
import net.sf.portecle.PortecleJDialog;
import net.sf.portecle.gui.SwingHelper;
import net.sf.portecle.gui.about.DSystemProperties;

class DSystemInformation
extends PortecleJDialog {
    private static final int VALUE_WIDTH = 25;

    public DSystemInformation(JDialog jDialog) {
        super((Window)jDialog, FPortecle.RB.getString("DSystemInformation.Title"), true);
        this.initComponents();
    }

    private void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        Properties properties = System.getProperties();
        Runtime runtime = Runtime.getRuntime();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridwidth = 3;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.anchor = 17;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()));
        JLabel jLabel = new JLabel(FPortecle.RB.getString("DSystemInformation.jlOperatingSystem.text"), 4);
        GridBagConstraints gridBagConstraints3 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints3.gridy = 0;
        jPanel.add((Component)jLabel, gridBagConstraints3);
        JTextField jTextField = new JTextField(MessageFormat.format(FPortecle.RB.getString("DSystemInformation.jtfOperatingSystem.text"), properties.getProperty("os.name", ""), properties.getProperty("os.version", ""), properties.getProperty("os.arch", "")), 25);
        jTextField.setEditable(false);
        jTextField.setCaretPosition(0);
        jLabel.setLabelFor(jTextField);
        GridBagConstraints gridBagConstraints4 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints4.gridy = 0;
        jPanel.add((Component)jTextField, gridBagConstraints4);
        JLabel jLabel2 = new JLabel(FPortecle.RB.getString("DSystemInformation.jlLocale.text"), 4);
        GridBagConstraints gridBagConstraints5 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints5.gridy = 1;
        jPanel.add((Component)jLabel2, gridBagConstraints5);
        JTextField jTextField2 = new JTextField(Locale.getDefault().getDisplayName(), 25);
        jTextField2.setEditable(false);
        jTextField2.setCaretPosition(0);
        jLabel2.setLabelFor(jTextField2);
        GridBagConstraints gridBagConstraints6 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints6.gridy = 1;
        jPanel.add((Component)jTextField2, gridBagConstraints6);
        JLabel jLabel3 = new JLabel(FPortecle.RB.getString("DSystemInformation.jlJavaVersion.text"), 4);
        GridBagConstraints gridBagConstraints7 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints7.gridy = 2;
        jPanel.add((Component)jLabel3, gridBagConstraints7);
        JTextField jTextField3 = new JTextField(properties.getProperty("java.version", ""), 25);
        jTextField3.setEditable(false);
        jTextField3.setCaretPosition(0);
        jLabel3.setLabelFor(jTextField3);
        GridBagConstraints gridBagConstraints8 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints8.gridy = 2;
        jPanel.add((Component)jTextField3, gridBagConstraints8);
        JLabel jLabel4 = new JLabel(FPortecle.RB.getString("DSystemInformation.jlJavaVendor.text"), 4);
        GridBagConstraints gridBagConstraints9 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints9.gridy = 3;
        jPanel.add((Component)jLabel4, gridBagConstraints9);
        JTextField jTextField4 = new JTextField(MessageFormat.format(FPortecle.RB.getString("DSystemInformation.jtfJavaVendor.text"), properties.getProperty("java.vendor", ""), properties.getProperty("java.vendor.url", "")), 25);
        jTextField4.setEditable(false);
        jTextField4.setCaretPosition(0);
        jLabel4.setLabelFor(jTextField4);
        GridBagConstraints gridBagConstraints10 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints10.gridy = 3;
        jPanel.add((Component)jTextField4, gridBagConstraints10);
        JLabel jLabel5 = new JLabel(FPortecle.RB.getString("DSystemInformation.jlJavaHome.text"), 4);
        GridBagConstraints gridBagConstraints11 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints11.gridy = 4;
        jPanel.add((Component)jLabel5, gridBagConstraints11);
        JTextField jTextField5 = new JTextField(properties.getProperty("java.home", ""), 25);
        jTextField5.setEditable(false);
        jTextField5.setCaretPosition(0);
        jLabel5.setLabelFor(jTextField5);
        GridBagConstraints gridBagConstraints12 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints12.gridy = 4;
        jPanel.add((Component)jTextField5, gridBagConstraints12);
        JLabel jLabel6 = new JLabel(FPortecle.RB.getString("DSystemInformation.jlJvmMaximumMemory.text"), 4);
        GridBagConstraints gridBagConstraints13 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints13.gridy = 5;
        jPanel.add((Component)jLabel6, gridBagConstraints13);
        JTextField jTextField6 = new JTextField(MessageFormat.format(FPortecle.RB.getString("DSystemInformation.jtfJvmMaximumMemory.text"), Math.round((double)runtime.maxMemory() / 1024.0)), 25);
        jTextField6.setEditable(false);
        jTextField6.setCaretPosition(0);
        jLabel6.setLabelFor(jTextField6);
        GridBagConstraints gridBagConstraints14 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints14.gridy = 5;
        jPanel.add((Component)jTextField6, gridBagConstraints14);
        JLabel jLabel7 = new JLabel(FPortecle.RB.getString("DSystemInformation.jlJvmTotalMemory.text"), 4);
        GridBagConstraints gridBagConstraints15 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints15.gridy = 6;
        jPanel.add((Component)jLabel7, gridBagConstraints15);
        JTextField jTextField7 = new JTextField(MessageFormat.format(FPortecle.RB.getString("DSystemInformation.jtfJvmTotalMemory.text"), Math.round((double)runtime.totalMemory() / 1024.0)), 25);
        jTextField7.setEditable(false);
        jTextField7.setCaretPosition(0);
        jLabel7.setLabelFor(jTextField7);
        GridBagConstraints gridBagConstraints16 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints16.gridy = 6;
        jPanel.add((Component)jTextField7, gridBagConstraints16);
        JLabel jLabel8 = new JLabel(FPortecle.RB.getString("DSystemInformation.jlJvmFreeMemory.text"), 4);
        GridBagConstraints gridBagConstraints17 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints17.gridy = 7;
        jPanel.add((Component)jLabel8, gridBagConstraints17);
        JTextField jTextField8 = new JTextField(MessageFormat.format(FPortecle.RB.getString("DSystemInformation.jtfJvmFreeMemory.text"), Math.round((double)runtime.freeMemory() / 1024.0)), 25);
        jTextField8.setEditable(false);
        jTextField8.setCaretPosition(0);
        jLabel8.setLabelFor(jTextField8);
        GridBagConstraints gridBagConstraints18 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints18.gridy = 7;
        jPanel.add((Component)jTextField8, gridBagConstraints18);
        JButton jButton = new JButton(FPortecle.RB.getString("DSystemInformation.jbSystemProperties.text"));
        jButton.setMnemonic(FPortecle.RB.getString("DSystemInformation.jbSystemProperties.mnemonic").charAt(0));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DSystemInformation.this.systemPropertiesPressed();
            }
        });
        JButton jButton2 = this.getOkButton(true);
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.setBorder(new EmptyBorder(5, 0, 5, 0));
        jPanel2.add(jButton2);
        jPanel2.add(jButton);
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        this.getRootPane().setDefaultButton(jButton2);
        this.initDialog();
    }

    private void systemPropertiesPressed() {
        DSystemProperties dSystemProperties = new DSystemProperties(this);
        dSystemProperties.setLocationRelativeTo(this);
        SwingHelper.showAndWait(dSystemProperties);
    }
}

