/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class UTF7Charset
extends Charset {
    static final String NAME = "UTF-7";
    static final String[] ALIASES = new String[]{"UTF7", "UNICODE-1-1-UTF-7", "csUnicode11UTF7", "UNICODE-2-0-UTF-7"};
    static final boolean[] D_SET = new boolean[]{false, false, false, false, false, false, false, false, false, true, true, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true, true, true, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    static final boolean[] O_SET = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false};
    static final int[] B_SET = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};
    static final int[] B_SET_INVERSE = new int[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    final boolean optionalDirect;

    static boolean isDSet(byte b) {
        return b >= 0 && D_SET[b];
    }

    static boolean isDSet(char c) {
        return c < '\u0080' && D_SET[c];
    }

    static boolean isOSet(byte b) {
        return b >= 0 && O_SET[b];
    }

    static boolean isOSet(char c) {
        return c < '\u0080' && O_SET[c];
    }

    static boolean isDorOSet(byte b) {
        return b >= 0 && (D_SET[b] || O_SET[b]);
    }

    static boolean isDorOSet(char c) {
        return c < '\u0080' && (D_SET[c] || O_SET[c]);
    }

    static boolean isBSet(byte b) {
        return b >= 0 && B_SET[b] != -1;
    }

    static boolean isBSet(char c) {
        return c < '\u0080' && B_SET[c] != -1;
    }

    static byte fromBase64(byte b) {
        return (byte)(b < 0 ? -1 : B_SET[b]);
    }

    static byte toBase64(byte b) {
        return (byte)(b < 0 || b >= 64 ? -1 : B_SET_INVERSE[b]);
    }

    public UTF7Charset() {
        this(NAME, ALIASES, false);
    }

    public UTF7Charset(String canonicalName, String[] aliases, boolean optionalDirect) {
        super(canonicalName, aliases);
        this.optionalDirect = optionalDirect;
    }

    boolean isDirect(char c) {
        return c < '\u0080' && (D_SET[c] || this.optionalDirect && O_SET[c]);
    }

    public boolean contains(Charset charset) {
        return this.getClass().isInstance(charset) || Charset.forName("UTF-16").contains(charset);
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    protected class Decoder
    extends CharsetDecoder {
        boolean shifted;
        boolean emptyShift;
        char decodedChar;
        int requiredBits;

        protected Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        protected void implReset() {
            this.shifted = false;
        }

        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            int remaining = in.remaining();
            while (remaining-- > 0) {
                if (out.remaining() < 1) {
                    return CoderResult.OVERFLOW;
                }
                byte b = in.get();
                if (!this.shifted) {
                    if (UTF7Charset.isDorOSet(b)) {
                        out.put((char)b);
                        continue;
                    }
                    if (b == 43) {
                        this.shifted = true;
                        this.emptyShift = true;
                        this.requiredBits = 16;
                        continue;
                    }
                    in.position(in.position() - 1);
                    return CoderResult.malformedForLength(1);
                }
                byte val = UTF7Charset.fromBase64(b);
                if (val != -1) {
                    this.emptyShift = false;
                    int bits = this.requiredBits >= 6 ? 6 : this.requiredBits;
                    this.decodedChar = (char)(this.decodedChar << bits | val >> 6 - bits);
                    this.requiredBits -= bits;
                    if (this.requiredBits != 0) continue;
                    out.put(this.decodedChar);
                    this.requiredBits = 10 + bits;
                    this.decodedChar = (char)val;
                    continue;
                }
                this.shifted = false;
                if ((char)(this.decodedChar << this.requiredBits) != '\u0000') {
                    in.position(in.position() - 1);
                    return CoderResult.malformedForLength(1);
                }
                if (b == 45) {
                    if (!this.emptyShift) continue;
                    out.put('+');
                    continue;
                }
                if (UTF7Charset.isDorOSet(b)) {
                    out.put((char)b);
                    continue;
                }
                in.position(in.position() - 1);
                return CoderResult.malformedForLength(1);
            }
            return CoderResult.UNDERFLOW;
        }
    }

    protected class Encoder
    extends CharsetEncoder {
        boolean shifted;
        char encodedChar;
        int requiredBits;

        protected Encoder(Charset charset) {
            super(charset, 1.0f, 5.0f);
        }

        protected void implReset() {
            this.shifted = false;
        }

        protected CoderResult implFlush(ByteBuffer out) {
            if (this.shifted) {
                if (out.remaining() < 2) {
                    return CoderResult.OVERFLOW;
                }
                this.flushBase64Char(out);
                out.put((byte)45);
            }
            return CoderResult.UNDERFLOW;
        }

        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            int remaining = in.remaining();
            while (remaining-- > 0) {
                if (out.remaining() < 3) {
                    return CoderResult.OVERFLOW;
                }
                char c = in.get();
                if (!this.shifted) {
                    if (UTF7Charset.this.isDirect(c)) {
                        out.put((byte)c);
                        continue;
                    }
                    if (c == '+') {
                        out.put((byte)43).put((byte)45);
                        continue;
                    }
                    out.put((byte)43);
                    this.shifted = true;
                    this.requiredBits = 6;
                    this.writeBase64Char(out, c);
                    continue;
                }
                if (UTF7Charset.this.isDirect(c)) {
                    this.shifted = false;
                    this.flushBase64Char(out);
                    if (UTF7Charset.isBSet(c) || c == '-') {
                        out.put((byte)45);
                    }
                    out.put((byte)c);
                    continue;
                }
                this.writeBase64Char(out, c);
            }
            return CoderResult.UNDERFLOW;
        }

        void writeBase64Char(ByteBuffer out, char c) {
            int bits = this.requiredBits;
            byte b = (byte)(this.encodedChar << bits & 0x3F | c >>> 16 - bits);
            out.put(UTF7Charset.toBase64(b));
            b = (byte)(c >>> 10 - bits & 0x3F);
            out.put(UTF7Charset.toBase64(b));
            if (bits != 6) {
                b = (byte)(c >>> 4 - bits & 0x3F);
                out.put(UTF7Charset.toBase64(b));
                this.requiredBits += 2;
            } else {
                this.requiredBits = 2;
            }
            this.encodedChar = c;
        }

        void flushBase64Char(ByteBuffer out) {
            if (this.requiredBits != 6) {
                byte b = (byte)(this.encodedChar << this.requiredBits & 0x3F);
                out.put(UTF7Charset.toBase64(b));
            }
        }
    }
}

