/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.ant;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Task;
import org.sonarsource.scanner.ant.SonarQubeTaskUtils;
import org.sonarsource.scanner.api.EmbeddedScanner;
import org.sonarsource.scanner.api.LogOutput;
import org.sonarsource.scanner.api.Utils;

public class SonarQubeTask
extends Task {
    private static final String PROJECT_BASEDIR_PROPERTY = "sonar.projectBaseDir";
    private static final String VERBOSE_PROPERTY = "sonar.verbose";

    public void execute() {
        this.log(Main.getAntVersion());
        this.log("SonarQube Ant Task version: " + SonarQubeTaskUtils.getTaskVersion());
        this.log("Loaded from: " + SonarQubeTaskUtils.getJarPath());
        HashMap<String, String> allProps = new HashMap<String, String>();
        allProps.put(PROJECT_BASEDIR_PROPERTY, this.getProject().getBaseDir().getAbsolutePath());
        if (SonarQubeTaskUtils.getAntLoggerLever(this.getProject()) >= 3) {
            allProps.put(VERBOSE_PROPERTY, "true");
        }
        SonarQubeTask.putAll(Utils.loadEnvironmentProperties(this.getEnv()), allProps);
        allProps.putAll(this.getProject().getProperties());
        if ("true".equalsIgnoreCase((String)allProps.get("sonar.scanner.skip"))) {
            this.log("SonarQube Scanner analysis skipped");
            return;
        }
        this.launchAnalysis(allProps);
    }

    Map<String, String> getEnv() {
        return System.getenv();
    }

    static void putAll(Properties src, Map<String, String> dest) {
        for (String name : src.stringPropertyNames()) {
            dest.put(name, src.getProperty(name));
        }
    }

    void launchAnalysis(Map<String, String> properties) {
        EmbeddedScanner runner = EmbeddedScanner.create("Ant", SonarQubeTaskUtils.getTaskVersion(), new LogOutputImplementation()).addGlobalProperties(properties);
        runner.start();
        runner.execute(properties);
    }

    class LogOutputImplementation
    implements LogOutput {
        LogOutputImplementation() {
        }

        @Override
        public void log(String formattedMessage, LogOutput.Level level) {
            this.logWithTaskLogger(formattedMessage, this.toAntLevel(level));
        }

        void logWithTaskLogger(String formattedMessage, int msgLevel) {
            SonarQubeTask.this.log(formattedMessage, msgLevel);
        }

        private int toAntLevel(LogOutput.Level level) {
            switch (level) {
                case TRACE: {
                    return 4;
                }
                case DEBUG: {
                    return 3;
                }
                case INFO: {
                    return 2;
                }
                case WARN: {
                    return 1;
                }
                case ERROR: {
                    return 0;
                }
            }
            throw new IllegalArgumentException(level.name());
        }
    }
}

