/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange;

import davmail.BundleMessage;
import davmail.Settings;
import davmail.exception.DavMailAuthenticationException;
import davmail.exception.DavMailException;
import davmail.exception.WebdavNotAvailableException;
import davmail.exchange.ExchangeSession;
import davmail.exchange.NetworkDownException;
import davmail.exchange.auth.ExchangeAuthenticator;
import davmail.exchange.auth.ExchangeFormAuthenticator;
import davmail.exchange.auth.HC4ExchangeFormAuthenticator;
import davmail.exchange.dav.DavExchangeSession;
import davmail.exchange.dav.HC4DavExchangeSession;
import davmail.exchange.ews.EwsExchangeSession;
import davmail.http.DavGatewayHttpClientFacade;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;

public final class ExchangeSessionFactory {
    private static final Object LOCK = new Object();
    private static final Map<PoolKey, ExchangeSession> POOL_MAP = new HashMap<PoolKey, ExchangeSession>();
    private static boolean configChecked;
    private static boolean errorSent;

    private ExchangeSessionFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExchangeSession getInstance(String userName, String password) throws IOException {
        String baseUrl = Settings.getProperty("davmail.url");
        if (Settings.getBooleanProperty("davmail.server")) {
            return ExchangeSessionFactory.getInstance(baseUrl, userName, password);
        }
        Object object = LOCK;
        synchronized (object) {
            return ExchangeSessionFactory.getInstance(baseUrl, userName, password);
        }
    }

    private static String convertUserName(String userName) {
        String result = userName;
        String defaultDomain = Settings.getProperty("davmail.defaultDomain");
        if (defaultDomain != null && userName.indexOf(92) < 0 && userName.indexOf(64) < 0) {
            result = defaultDomain + '\\' + userName;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExchangeSession getInstance(String baseUrl, String userName, String password) throws IOException {
        ExchangeSession session = null;
        try {
            String mode = Settings.getProperty("davmail.mode");
            if ("O365".equals(mode)) {
                baseUrl = "https://outlook.office365.com/EWS/Exchange.asmx";
            }
            PoolKey poolKey = new PoolKey(baseUrl, userName, password);
            Object object = LOCK;
            synchronized (object) {
                session = POOL_MAP.get(poolKey);
            }
            if (session != null) {
                ExchangeSession.LOGGER.debug((Object)("Got session " + session + " from cache"));
            }
            if (session != null && session.isExpired()) {
                object = LOCK;
                synchronized (object) {
                    session.close();
                    ExchangeSession.LOGGER.debug((Object)("Session " + session + " for user " + session.userName + " expired"));
                    session = null;
                    POOL_MAP.remove(poolKey);
                }
            }
            if (session == null) {
                ExchangeAuthenticator exchangeFormAuthenticator;
                String authenticatorClass;
                if (mode == null) {
                    mode = "false".equals(Settings.getProperty("davmail.enableEws")) ? "WebDav" : "EWS";
                }
                if ((authenticatorClass = Settings.getProperty("davmail.authenticator")) == null) {
                    switch (mode) {
                        case "O365Modern": {
                            authenticatorClass = "davmail.exchange.auth.O365Authenticator";
                            break;
                        }
                        case "O365Interactive": {
                            authenticatorClass = "davmail.exchange.auth.O365InteractiveAuthenticator";
                            if (!GraphicsEnvironment.isHeadless()) break;
                            throw new DavMailException("EXCEPTION_DAVMAIL_CONFIGURATION", "O365Interactive not supported in headless mode");
                        }
                        case "O365Manual": {
                            authenticatorClass = "davmail.exchange.auth.O365ManualAuthenticator";
                        }
                    }
                }
                if (authenticatorClass != null) {
                    ExchangeAuthenticator authenticator = (ExchangeAuthenticator)Class.forName(authenticatorClass).newInstance();
                    authenticator.setUsername(poolKey.userName);
                    authenticator.setPassword(poolKey.password);
                    authenticator.authenticate();
                    HttpClient httpClient = DavGatewayHttpClientFacade.getInstance(authenticator.getExchangeUri().toString());
                    DavGatewayHttpClientFacade.createMultiThreadedHttpConnectionManager(httpClient);
                    session = new EwsExchangeSession(httpClient, authenticator.getToken(), poolKey.userName);
                } else if ("EWS".equals(mode) || "O365".equals(mode) || poolKey.url.toLowerCase().endsWith("/ews/exchange.asmx")) {
                    if (poolKey.url.toLowerCase().endsWith("/ews/exchange.asmx")) {
                        ExchangeSession.LOGGER.debug((Object)"Direct EWS authentication");
                        HttpClient httpClient = DavGatewayHttpClientFacade.getInstance(poolKey.url);
                        DavGatewayHttpClientFacade.createMultiThreadedHttpConnectionManager(httpClient);
                        DavGatewayHttpClientFacade.setCredentials(httpClient, poolKey.userName, poolKey.password);
                        session = new EwsExchangeSession(httpClient, poolKey.userName);
                    } else {
                        ExchangeSession.LOGGER.debug((Object)"OWA authentication in EWS mode");
                        exchangeFormAuthenticator = new ExchangeFormAuthenticator();
                        ((ExchangeFormAuthenticator)exchangeFormAuthenticator).setUrl(poolKey.url);
                        ((ExchangeFormAuthenticator)exchangeFormAuthenticator).setUsername(poolKey.userName);
                        ((ExchangeFormAuthenticator)exchangeFormAuthenticator).setPassword(poolKey.password);
                        ((ExchangeFormAuthenticator)exchangeFormAuthenticator).authenticate();
                        session = new EwsExchangeSession(((ExchangeFormAuthenticator)exchangeFormAuthenticator).getHttpClient(), ((ExchangeFormAuthenticator)exchangeFormAuthenticator).getExchangeUri(), ((ExchangeFormAuthenticator)exchangeFormAuthenticator).getUsername());
                    }
                } else if ("HC4WebDav".equals(mode)) {
                    exchangeFormAuthenticator = new HC4ExchangeFormAuthenticator();
                    ((HC4ExchangeFormAuthenticator)exchangeFormAuthenticator).setUrl(poolKey.url);
                    ((HC4ExchangeFormAuthenticator)exchangeFormAuthenticator).setUsername(poolKey.userName);
                    ((HC4ExchangeFormAuthenticator)exchangeFormAuthenticator).setPassword(poolKey.password);
                    ((HC4ExchangeFormAuthenticator)exchangeFormAuthenticator).authenticate();
                    session = new HC4DavExchangeSession(((HC4ExchangeFormAuthenticator)exchangeFormAuthenticator).getHttpClientAdapter(), ((HC4ExchangeFormAuthenticator)exchangeFormAuthenticator).getExchangeUri(), ((HC4ExchangeFormAuthenticator)exchangeFormAuthenticator).getUsername());
                } else {
                    exchangeFormAuthenticator = new ExchangeFormAuthenticator();
                    ((ExchangeFormAuthenticator)exchangeFormAuthenticator).setUrl(poolKey.url);
                    ((ExchangeFormAuthenticator)exchangeFormAuthenticator).setUsername(poolKey.userName);
                    ((ExchangeFormAuthenticator)exchangeFormAuthenticator).setPassword(poolKey.password);
                    ((ExchangeFormAuthenticator)exchangeFormAuthenticator).authenticate();
                    try {
                        session = new DavExchangeSession(((ExchangeFormAuthenticator)exchangeFormAuthenticator).getHttpClient(), ((ExchangeFormAuthenticator)exchangeFormAuthenticator).getExchangeUri(), ((ExchangeFormAuthenticator)exchangeFormAuthenticator).getUsername());
                    }
                    catch (WebdavNotAvailableException e) {
                        if ("Auto".equals(mode)) {
                            ExchangeSession.LOGGER.debug((Object)(e.getMessage() + ", retry with EWS"));
                            session = new EwsExchangeSession(((ExchangeFormAuthenticator)exchangeFormAuthenticator).getHttpClient(), ((ExchangeFormAuthenticator)exchangeFormAuthenticator).getExchangeUri(), ((ExchangeFormAuthenticator)exchangeFormAuthenticator).getUsername());
                        }
                        throw e;
                    }
                }
                ExchangeSessionFactory.checkWhiteList(session.getEmail());
                ExchangeSession.LOGGER.debug((Object)("Created new session " + session + " for user " + poolKey.userName));
            }
            object = LOCK;
            synchronized (object) {
                POOL_MAP.put(poolKey, session);
            }
            configChecked = true;
            errorSent = false;
        }
        catch (DavMailException | IllegalStateException | NullPointerException exc) {
            throw exc;
        }
        catch (Exception exc) {
            ExchangeSessionFactory.handleNetworkDown(exc);
        }
        return session;
    }

    private static void checkWhiteList(String email) throws DavMailAuthenticationException {
        String whiteListString = Settings.getProperty("davmail.userWhiteList");
        if (whiteListString != null && !whiteListString.isEmpty()) {
            for (String whiteListvalue : whiteListString.split(",")) {
                if (whiteListvalue.startsWith("@") && email.endsWith(whiteListvalue)) {
                    return;
                }
                if (!email.equalsIgnoreCase(whiteListvalue)) continue;
                return;
            }
            ExchangeSession.LOGGER.warn((Object)(email + " not allowed by whitelist"));
            throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExchangeSession getInstance(ExchangeSession currentSession, String userName, String password) throws IOException {
        ExchangeSession session;
        block6: {
            session = currentSession;
            try {
                if (!session.isExpired()) break block6;
                ExchangeSession.LOGGER.debug((Object)("Session " + session + " expired, trying to open a new one"));
                session = null;
                String baseUrl = Settings.getProperty("davmail.url");
                PoolKey poolKey = new PoolKey(baseUrl, userName, password);
                Object object = LOCK;
                synchronized (object) {
                    POOL_MAP.remove(poolKey);
                }
                session = ExchangeSessionFactory.getInstance(userName, password);
            }
            catch (DavMailAuthenticationException exc) {
                ExchangeSession.LOGGER.debug((Object)"Unable to reopen session", (Throwable)exc);
                throw exc;
            }
            catch (Exception exc) {
                ExchangeSession.LOGGER.debug((Object)"Unable to reopen session", (Throwable)exc);
                ExchangeSessionFactory.handleNetworkDown(exc);
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkConfig() throws IOException {
        String url = Settings.getProperty("davmail.url");
        if (url == null || !url.startsWith("http://") && !url.startsWith("https://")) {
            throw new DavMailException("LOG_INVALID_URL", url);
        }
        HttpClient httpClient = DavGatewayHttpClientFacade.getInstance(url);
        GetMethod testMethod = new GetMethod(url);
        try {
            int status = DavGatewayHttpClientFacade.executeTestMethod(httpClient, testMethod);
            ExchangeSession.LOGGER.debug((Object)("Test configuration status: " + status));
            if (status != 200 && status != 401 && !DavGatewayHttpClientFacade.isRedirect(status)) {
                throw new DavMailException("EXCEPTION_CONNECTION_FAILED", url, status);
            }
            configChecked = true;
            errorSent = false;
        }
        catch (Exception exc) {
            ExchangeSessionFactory.handleNetworkDown(exc);
        }
        finally {
            testMethod.releaseConnection();
        }
    }

    private static void handleNetworkDown(Exception exc) throws DavMailException {
        if (!ExchangeSessionFactory.checkNetwork() || configChecked) {
            ExchangeSession.LOGGER.warn((Object)BundleMessage.formatLog("EXCEPTION_NETWORK_DOWN", new Object[0]));
            if (!(exc instanceof UnknownHostException) && !(exc instanceof NetworkDownException)) {
                ExchangeSession.LOGGER.debug((Object)exc, (Throwable)exc);
            }
            throw new NetworkDownException("EXCEPTION_NETWORK_DOWN");
        }
        BundleMessage message = new BundleMessage("EXCEPTION_CONNECT", exc.getClass().getName(), exc.getMessage());
        if (errorSent) {
            ExchangeSession.LOGGER.warn((Object)message);
            throw new NetworkDownException("EXCEPTION_DAVMAIL_CONFIGURATION", (Object)message);
        }
        errorSent = true;
        ExchangeSession.LOGGER.error((Object)message);
        throw new DavMailException("EXCEPTION_DAVMAIL_CONFIGURATION", message);
    }

    public static String getUserPassword(String userName) {
        String fullUserName = ExchangeSessionFactory.convertUserName(userName);
        for (PoolKey poolKey : POOL_MAP.keySet()) {
            if (!poolKey.userName.equals(fullUserName)) continue;
            return poolKey.password;
        }
        return null;
    }

    static boolean checkNetwork() {
        boolean up = false;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            if (enumeration != null) {
                while (!up && enumeration.hasMoreElements()) {
                    NetworkInterface networkInterface = enumeration.nextElement();
                    up = networkInterface.isUp() && !networkInterface.isLoopback() && networkInterface.getInetAddresses().hasMoreElements();
                }
            }
        }
        catch (NoSuchMethodError error) {
            ExchangeSession.LOGGER.debug((Object)"Unable to test network interfaces (not available under Java 1.5)");
            up = true;
        }
        catch (SocketException exc) {
            ExchangeSession.LOGGER.error((Object)("DavMail configuration exception: \n Error listing network interfaces " + exc.getMessage()), (Throwable)exc);
        }
        return up;
    }

    public static void reset() {
        configChecked = false;
        errorSent = false;
        POOL_MAP.clear();
    }

    static class PoolKey {
        final String url;
        final String userName;
        final String password;

        PoolKey(String url, String userName, String password) {
            this.url = url;
            this.userName = ExchangeSessionFactory.convertUserName(userName);
            this.password = password;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof PoolKey && ((PoolKey)object).url.equals(this.url) && ((PoolKey)object).userName.equals(this.userName) && ((PoolKey)object).password.equals(this.password);
        }

        public int hashCode() {
            return this.url.hashCode() + this.userName.hashCode() + this.password.hashCode();
        }
    }
}

