/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.auth;

import davmail.BundleMessage;
import davmail.exception.DavMailAuthenticationException;
import davmail.exception.DavMailException;
import davmail.exception.WebdavNotAvailableException;
import davmail.exchange.auth.ExchangeAuthenticator;
import davmail.exchange.auth.O365Token;
import davmail.http.DavGatewayHttpClientFacade;
import davmail.http.DavGatewayOTPPrompt;
import davmail.util.StringUtil;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.log4j.Logger;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;

public class ExchangeFormAuthenticator
implements ExchangeAuthenticator {
    protected static final Logger LOGGER = Logger.getLogger(ExchangeFormAuthenticator.class);
    protected static final Set<String> USER_NAME_FIELDS = new HashSet<String>();
    protected static final Set<String> PASSWORD_FIELDS;
    protected static final Set<String> TOKEN_FIELDS;
    private String username;
    private String password;
    private String url;
    private HttpClient httpClient;
    private String preAuthusername;
    private final List<String> usernameInputs = new ArrayList<String>();
    private String passwordInput = null;
    private boolean otpPreAuthFound = false;
    private int otpPreAuthRetries = 0;
    private static final int MAX_OTP_RETRIES = 3;
    private java.net.URI exchangeUri;

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public void authenticate() throws DavMailException {
        try {
            this.httpClient = DavGatewayHttpClientFacade.getInstance(this.url);
            DavGatewayHttpClientFacade.createMultiThreadedHttpConnectionManager(this.httpClient);
            boolean isHttpAuthentication = this.isHttpAuthentication(this.httpClient, this.url);
            if (isHttpAuthentication) {
                DavGatewayHttpClientFacade.addNTLM(this.httpClient);
            }
            this.httpClient.getState().clearCookies();
            if (this.preAuthusername == null) {
                int doubleQuoteIndex = this.username.indexOf(34);
                if (doubleQuoteIndex > 0) {
                    this.preAuthusername = this.username.substring(0, doubleQuoteIndex);
                    this.username = this.username.substring(doubleQuoteIndex + 1);
                } else {
                    this.preAuthusername = this.username;
                }
            }
            DavGatewayHttpClientFacade.setCredentials(this.httpClient, this.username, this.password);
            HttpMethod method = DavGatewayHttpClientFacade.executeFollowRedirects(this.httpClient, this.url);
            if (!this.isAuthenticated(method)) {
                if (isHttpAuthentication) {
                    int status = method.getStatusCode();
                    if (status == 401) {
                        method.releaseConnection();
                        throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED");
                    }
                    if (status != 200) {
                        method.releaseConnection();
                        throw DavGatewayHttpClientFacade.buildHttpResponseException(method);
                    }
                    if ("/owa/auth/logon.aspx".equals(method.getPath())) {
                        method = this.formLogin(this.httpClient, method, this.password);
                    }
                } else {
                    method = this.formLogin(this.httpClient, method, this.password);
                }
            }
            if (isHttpAuthentication && !DavGatewayHttpClientFacade.hasNTLMorNegotiate(this.httpClient)) {
                this.httpClient.getParams().setParameter("http.authentication.preemptive", (Object)true);
            }
            this.exchangeUri = java.net.URI.create(method.getURI().getURI());
            method.releaseConnection();
        }
        catch (DavMailAuthenticationException exc) {
            this.close();
            LOGGER.error((Object)exc.getMessage());
            throw exc;
        }
        catch (ConnectException | UnknownHostException exc) {
            this.close();
            BundleMessage message = new BundleMessage("EXCEPTION_CONNECT", exc.getClass().getName(), exc.getMessage());
            LOGGER.error((Object)message);
            throw new DavMailException("EXCEPTION_DAVMAIL_CONFIGURATION", message);
        }
        catch (WebdavNotAvailableException exc) {
            this.close();
            throw exc;
        }
        catch (IOException exc) {
            this.close();
            LOGGER.error((Object)BundleMessage.formatLog("EXCEPTION_EXCHANGE_LOGIN_FAILED", exc));
            throw new DavMailException("EXCEPTION_EXCHANGE_LOGIN_FAILED", new Object[]{exc});
        }
        LOGGER.debug((Object)("Authenticated with " + this.url));
    }

    protected boolean isHttpAuthentication(HttpClient httpClient, String url) {
        return DavGatewayHttpClientFacade.getHttpStatus(httpClient, url) == 401;
    }

    protected boolean isAuthenticated(HttpMethod method) {
        boolean authenticated = false;
        if (method.getStatusCode() == 200 && "/ews/services.wsdl".equalsIgnoreCase(method.getPath())) {
            authenticated = true;
        } else {
            for (Cookie cookie : this.httpClient.getState().getCookies()) {
                if (!cookie.getName().startsWith("cadata") && !"sessionid".equals(cookie.getName()) && !"UserContext".equals(cookie.getName())) continue;
                authenticated = true;
                break;
            }
        }
        return authenticated;
    }

    protected HttpMethod formLogin(HttpClient httpClient, HttpMethod initmethod, String password) throws IOException {
        LOGGER.debug((Object)"Form based authentication detected");
        HttpMethod logonMethod = this.buildLogonMethod(httpClient, initmethod);
        if (logonMethod == null) {
            LOGGER.debug((Object)("Authentication form not found at " + initmethod.getURI() + ", trying default url"));
            logonMethod = new PostMethod("/owa/auth/owaauth.dll");
        }
        logonMethod = this.postLogonMethod(httpClient, logonMethod, password);
        return logonMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpMethod buildLogonMethod(HttpClient httpClient, HttpMethod initmethod) throws IOException {
        PostMethod logonMethod = null;
        HtmlCleaner cleaner = new HtmlCleaner();
        this.usernameInputs.clear();
        try {
            TagNode node = cleaner.clean(initmethod.getResponseBodyAsStream());
            List forms = node.getElementListByName("form", true);
            TagNode logonForm = null;
            if (forms.size() == 1) {
                logonForm = (TagNode)forms.get(0);
            } else if (forms.size() > 1) {
                for (Object form : forms) {
                    if (!"logonForm".equals(((TagNode)form).getAttributeByName("name"))) continue;
                    logonForm = (TagNode)form;
                }
            }
            if (logonForm != null) {
                String logonMethodPath = logonForm.getAttributeByName("action");
                if (logonMethodPath != null && logonMethodPath.length() == 0) {
                    logonMethodPath = "/owa/auth.owa";
                }
                logonMethod = new PostMethod(this.getAbsoluteUri(initmethod, logonMethodPath));
                List inputList = node.getElementListByName("input", true);
                for (Object input : inputList) {
                    String type = ((TagNode)input).getAttributeByName("type");
                    String name = ((TagNode)input).getAttributeByName("name");
                    String value = ((TagNode)input).getAttributeByName("value");
                    if ("hidden".equalsIgnoreCase(type) && name != null && value != null) {
                        logonMethod.addParameter(name, value);
                    }
                    if (name == null) {
                        LOGGER.debug((Object)"Skip invalid input with empty name");
                        continue;
                    }
                    if (USER_NAME_FIELDS.contains(name)) {
                        this.usernameInputs.add(name);
                        continue;
                    }
                    if (PASSWORD_FIELDS.contains(name)) {
                        this.passwordInput = name;
                        continue;
                    }
                    if ("addr".equals(name)) {
                        HttpMethod newInitMethod = DavGatewayHttpClientFacade.executeFollowRedirects(httpClient, (HttpMethod)logonMethod);
                        logonMethod = this.buildLogonMethod(httpClient, newInitMethod);
                        continue;
                    }
                    if (TOKEN_FIELDS.contains(name)) {
                        logonMethod.addParameter(name, DavGatewayOTPPrompt.getOneTimePassword());
                        continue;
                    }
                    if (!"otc".equals(name)) continue;
                    String pinsafeUser = this.getAliasFromLogin();
                    if (pinsafeUser == null) {
                        pinsafeUser = this.username;
                    }
                    GetMethod getMethod = new GetMethod("/PINsafeISAFilter.dll?username=" + pinsafeUser);
                    try {
                        int status = httpClient.executeMethod((HttpMethod)getMethod);
                        if (status != 200) {
                            throw DavGatewayHttpClientFacade.buildHttpResponseException((HttpMethod)getMethod);
                        }
                        BufferedImage captchaImage = ImageIO.read(getMethod.getResponseBodyAsStream());
                        logonMethod.addParameter(name, DavGatewayOTPPrompt.getCaptchaValue(captchaImage));
                    }
                    finally {
                        getMethod.releaseConnection();
                    }
                }
            } else {
                List frameList = node.getElementListByName("frame", true);
                if (frameList.size() == 1) {
                    String src = ((TagNode)frameList.get(0)).getAttributeByName("src");
                    if (src != null) {
                        LOGGER.debug((Object)"Frames detected in form page, try frame content");
                        initmethod.releaseConnection();
                        HttpMethod newInitMethod = DavGatewayHttpClientFacade.executeFollowRedirects(httpClient, src);
                        logonMethod = this.buildLogonMethod(httpClient, newInitMethod);
                    }
                } else {
                    List scriptList = node.getElementListByName("script", true);
                    for (Object script : scriptList) {
                        List contents = ((TagNode)script).getAllChildren();
                        for (Object content : contents) {
                            String location;
                            String scriptValue;
                            if (content instanceof CommentNode) {
                                scriptValue = ((CommentNode)content).getCommentedContent();
                                String sUrl = StringUtil.getToken(scriptValue, "var a_sUrl = \"", "\"");
                                String sLgn = StringUtil.getToken(scriptValue, "var a_sLgnQS = \"", "\"");
                                if (sLgn == null) {
                                    sLgn = StringUtil.getToken(scriptValue, "var a_sLgn = \"", "\"");
                                }
                                if (sUrl == null || sLgn == null) continue;
                                String src = this.getScriptBasedFormURL(initmethod, sLgn + sUrl);
                                LOGGER.debug((Object)("Detected script based logon, redirect to form at " + src));
                                HttpMethod newInitMethod = DavGatewayHttpClientFacade.executeFollowRedirects(httpClient, src);
                                logonMethod = this.buildLogonMethod(httpClient, newInitMethod);
                                continue;
                            }
                            if (!(content instanceof ContentNode) || (location = StringUtil.getToken(scriptValue = ((ContentNode)content).getContent(), "window.location.replace(\"", "\"")) == null) continue;
                            LOGGER.debug((Object)("Post logon redirect to: " + location));
                            logonMethod = DavGatewayHttpClientFacade.executeFollowRedirects(httpClient, location);
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error parsing login form at " + initmethod.getURI()));
        }
        finally {
            initmethod.releaseConnection();
        }
        return logonMethod;
    }

    protected HttpMethod postLogonMethod(HttpClient httpClient, HttpMethod logonMethod, String password) throws IOException {
        this.setAuthFormFields(logonMethod, httpClient, password);
        httpClient.getState().addCookie(new Cookie(httpClient.getHostConfiguration().getHost(), "PBack", "0", "/", null, false));
        logonMethod = DavGatewayHttpClientFacade.executeFollowRedirects(httpClient, logonMethod);
        this.checkFormLoginQueryString(logonMethod);
        if (!this.isAuthenticated(logonMethod)) {
            if ((logonMethod = this.buildLogonMethod(httpClient, logonMethod)) != null) {
                if (this.otpPreAuthFound && this.otpPreAuthRetries < 3) {
                    return this.postLogonMethod(httpClient, logonMethod, password);
                }
                logonMethod = DavGatewayHttpClientFacade.executeFollowRedirects(httpClient, logonMethod);
                this.checkFormLoginQueryString(logonMethod);
                if (!this.isAuthenticated(logonMethod)) {
                    this.throwAuthenticationFailed();
                }
            } else {
                this.throwAuthenticationFailed();
            }
        }
        if (logonMethod != null && "/owa/languageselection.aspx".equals(logonMethod.getPath())) {
            logonMethod = this.submitLanguageSelectionForm(logonMethod);
        }
        return logonMethod;
    }

    protected HttpMethod submitLanguageSelectionForm(HttpMethod logonMethod) throws IOException {
        PostMethod postLanguageFormMethod;
        HtmlCleaner cleaner = new HtmlCleaner();
        try {
            TagNode node = cleaner.clean(logonMethod.getResponseBodyAsStream());
            List forms = node.getElementListByName("form", true);
            if (forms.size() != 1) {
                throw new IOException("Form not found");
            }
            TagNode languageForm = (TagNode)forms.get(0);
            String languageMethodPath = languageForm.getAttributeByName("action");
            postLanguageFormMethod = new PostMethod(this.getAbsoluteUri(logonMethod, languageMethodPath));
            List inputList = languageForm.getElementListByName("input", true);
            for (Object input : inputList) {
                String name = ((TagNode)input).getAttributeByName("name");
                String value = ((TagNode)input).getAttributeByName("value");
                if (name == null || value == null) continue;
                postLanguageFormMethod.addParameter(name, value);
            }
            List selectList = languageForm.getElementListByName("select", true);
            for (Object select : selectList) {
                String name = ((TagNode)select).getAttributeByName("name");
                List optionList = ((TagNode)select).getElementListByName("option", true);
                String value = null;
                for (Object option : optionList) {
                    if (((TagNode)option).getAttributeByName("selected") == null) continue;
                    value = ((TagNode)option).getAttributeByName("value");
                    break;
                }
                if (name == null || value == null) continue;
                postLanguageFormMethod.addParameter(name, value);
            }
        }
        catch (IOException e) {
            String errorMessage = "Error parsing language selection form at " + logonMethod.getURI();
            LOGGER.error((Object)errorMessage);
            throw new IOException(errorMessage);
        }
        finally {
            logonMethod.releaseConnection();
        }
        return DavGatewayHttpClientFacade.executeFollowRedirects(this.httpClient, (HttpMethod)postLanguageFormMethod);
    }

    protected void setAuthFormFields(HttpMethod logonMethod, HttpClient httpClient, String password) throws IllegalArgumentException {
        String usernameInput;
        if (this.usernameInputs.size() == 2) {
            String userid;
            int pipeIndex = this.username.indexOf(124);
            if (pipeIndex < 0) {
                LOGGER.debug((Object)"Multiple user fields detected, please use userid|username as user name in client, except when userid is username");
                userid = this.username;
            } else {
                userid = this.username.substring(0, pipeIndex);
                this.username = this.username.substring(pipeIndex + 1);
                DavGatewayHttpClientFacade.setCredentials(httpClient, this.username, password);
            }
            ((PostMethod)logonMethod).removeParameter("userid");
            ((PostMethod)logonMethod).addParameter("userid", userid);
            usernameInput = "username";
        } else {
            usernameInput = this.usernameInputs.size() == 1 ? this.usernameInputs.get(0) : "username";
        }
        ((PostMethod)logonMethod).removeParameter(usernameInput);
        if (this.passwordInput != null) {
            ((PostMethod)logonMethod).removeParameter(this.passwordInput);
        }
        ((PostMethod)logonMethod).removeParameter("trusted");
        ((PostMethod)logonMethod).removeParameter("flags");
        if (this.passwordInput == null) {
            this.otpPreAuthFound = true;
            ++this.otpPreAuthRetries;
            ((PostMethod)logonMethod).addParameter(usernameInput, this.preAuthusername);
        } else {
            this.otpPreAuthFound = false;
            this.otpPreAuthRetries = 0;
            ((PostMethod)logonMethod).addParameter(usernameInput, this.username);
            ((PostMethod)logonMethod).addParameter(this.passwordInput, password);
            ((PostMethod)logonMethod).addParameter("trusted", "4");
            ((PostMethod)logonMethod).addParameter("flags", "4");
        }
    }

    protected String getAbsoluteUri(HttpMethod method, String path) throws URIException {
        URI uri = method.getURI();
        if (path != null) {
            uri.setQuery(null);
            if (path.startsWith("/")) {
                uri.setPath(path);
            } else {
                if (path.startsWith("http://") || path.startsWith("https://")) {
                    return path;
                }
                String currentPath = method.getPath();
                int end = currentPath.lastIndexOf(47);
                if (end >= 0) {
                    uri.setPath(currentPath.substring(0, end + 1) + path);
                } else {
                    throw new URIException(uri.getURI());
                }
            }
        }
        return uri.getURI();
    }

    protected String getScriptBasedFormURL(HttpMethod initmethod, String pathQuery) throws URIException {
        URI initmethodURI = initmethod.getURI();
        int queryIndex = pathQuery.indexOf(63);
        if (queryIndex >= 0) {
            if (queryIndex > 0) {
                String newPath = pathQuery.substring(0, queryIndex);
                if (newPath.startsWith("/")) {
                    initmethodURI.setPath(newPath);
                } else {
                    String currentPath = initmethodURI.getPath();
                    int folderIndex = currentPath.lastIndexOf(47);
                    if (folderIndex >= 0) {
                        initmethodURI.setPath(currentPath.substring(0, folderIndex + 1) + newPath);
                    } else {
                        initmethodURI.setPath('/' + newPath);
                    }
                }
            }
            initmethodURI.setQuery(pathQuery.substring(queryIndex + 1));
        }
        return initmethodURI.getURI();
    }

    protected void checkFormLoginQueryString(HttpMethod logonMethod) throws DavMailAuthenticationException {
        String queryString = logonMethod.getQueryString();
        if (queryString != null && (queryString.contains("reason=2") || queryString.contains("reason=4"))) {
            logonMethod.releaseConnection();
            this.throwAuthenticationFailed();
        }
    }

    protected void throwAuthenticationFailed() throws DavMailAuthenticationException {
        if (this.username != null && this.username.contains("\\")) {
            throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED");
        }
        throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED_RETRY");
    }

    public String getAliasFromLogin() {
        if (this.username.indexOf(64) >= 0) {
            return null;
        }
        String result = this.username;
        int index = Math.max(result.indexOf(92), result.indexOf(47));
        if (index >= 0) {
            result = result.substring(index + 1);
        }
        return result;
    }

    public void close() {
        DavGatewayHttpClientFacade.close(this.httpClient);
    }

    @Override
    public O365Token getToken() {
        throw new UnsupportedOperationException();
    }

    @Override
    public java.net.URI getExchangeUri() {
        return this.exchangeUri;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getUsername() {
        return this.username;
    }

    static {
        USER_NAME_FIELDS.add("username");
        USER_NAME_FIELDS.add("txtusername");
        USER_NAME_FIELDS.add("userid");
        USER_NAME_FIELDS.add("SafeWordUser");
        USER_NAME_FIELDS.add("user_name");
        USER_NAME_FIELDS.add("login");
        USER_NAME_FIELDS.add("UserName");
        PASSWORD_FIELDS = new HashSet<String>();
        PASSWORD_FIELDS.add("password");
        PASSWORD_FIELDS.add("txtUserPass");
        PASSWORD_FIELDS.add("pw");
        PASSWORD_FIELDS.add("basicPassword");
        PASSWORD_FIELDS.add("passwd");
        PASSWORD_FIELDS.add("Password");
        TOKEN_FIELDS = new HashSet<String>();
        TOKEN_FIELDS.add("SafeWordPassword");
        TOKEN_FIELDS.add("passcode");
    }
}

