/*
 * Decompiled with CFR 0.152.
 */
package davmail.ui.tray;

import davmail.ui.tray.OSXTrayInterface;
import java.awt.Desktop;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class OSXHandler
implements InvocationHandler {
    private final OSXTrayInterface davGatewayTray;
    public static final boolean IS_JAVA9 = Double.parseDouble(System.getProperty("java.specification.version")) >= 1.9;

    public OSXHandler(OSXTrayInterface davGatewayTray) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        this.davGatewayTray = davGatewayTray;
        this.addEventHandlers();
    }

    public void addEventHandlers() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> preferencesHandlerClass;
        Class<?> aboutHandlerClass;
        Object application;
        Class<?> applicationClass;
        if (IS_JAVA9) {
            applicationClass = Class.forName("java.awt.Desktop");
            application = Desktop.getDesktop();
            aboutHandlerClass = Class.forName("java.awt.desktop.AboutHandler");
            preferencesHandlerClass = Class.forName("java.awt.desktop.PreferencesHandler");
        } else {
            applicationClass = Class.forName("com.apple.eawt.Application");
            application = applicationClass.getMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
            aboutHandlerClass = Class.forName("com.apple.eawt.AboutHandler");
            preferencesHandlerClass = Class.forName("com.apple.eawt.PreferencesHandler");
        }
        Object proxy = Proxy.newProxyInstance(OSXHandler.class.getClassLoader(), new Class[]{aboutHandlerClass, preferencesHandlerClass}, (InvocationHandler)this);
        applicationClass.getDeclaredMethod("setAboutHandler", aboutHandlerClass).invoke(application, proxy);
        applicationClass.getDeclaredMethod("setPreferencesHandler", preferencesHandlerClass).invoke(application, proxy);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        if ("handleAbout".equals(method.getName())) {
            this.davGatewayTray.about();
        } else if ("handlePreferences".equals(method.getName())) {
            this.davGatewayTray.preferences();
        }
        return null;
    }
}

