/*
 * Decompiled with CFR 0.152.
 */
package davmail.ui.tray;

import davmail.BundleMessage;
import davmail.DavGateway;
import davmail.Settings;
import davmail.ui.AboutFrame;
import davmail.ui.SettingsFrame;
import davmail.ui.tray.DavGatewayTray;
import davmail.ui.tray.DavGatewayTrayInterface;
import davmail.util.IOUtil;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;

public class SwtGatewayTray
implements DavGatewayTrayInterface {
    private static final Logger LOGGER = Logger.getLogger(SwtGatewayTray.class);
    private static final Object LOCK = new Object();
    SettingsFrame settingsFrame;
    AboutFrame aboutFrame;
    private static TrayItem trayItem;
    private static ArrayList<Image> frameIcons;
    private static org.eclipse.swt.graphics.Image image;
    private static org.eclipse.swt.graphics.Image image2;
    private static org.eclipse.swt.graphics.Image inactiveImage;
    private static Display display;
    private static Shell shell;
    private boolean isActive = true;
    private boolean isReady;
    private Error error;
    private boolean firstMessage = true;

    protected SwtGatewayTray() {
    }

    @Override
    public List<Image> getFrameIcons() {
        return frameIcons;
    }

    @Override
    public void switchIcon() {
        this.isActive = true;
        display.syncExec(() -> {
            org.eclipse.swt.graphics.Image currentImage = trayItem.getImage();
            if (currentImage != null && currentImage.equals((Object)image)) {
                trayItem.setImage(image2);
            } else {
                trayItem.setImage(image);
            }
        });
    }

    @Override
    public void resetIcon() {
        display.syncExec(() -> trayItem.setImage(image));
    }

    @Override
    public void inactiveIcon() {
        this.isActive = false;
        display.syncExec(() -> trayItem.setImage(inactiveImage));
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void displayMessage(String message, Level level) {
        if (trayItem != null) {
            display.asyncExec(() -> {
                int messageType = 0;
                if (level.equals((Object)Level.INFO)) {
                    messageType = 2;
                } else if (level.equals((Object)Level.WARN)) {
                    messageType = 8;
                } else if (level.equals((Object)Level.ERROR)) {
                    messageType = 1;
                }
                if (messageType != 0) {
                    ToolTip toolTip = new ToolTip(shell, 0x1000 | messageType);
                    toolTip.setText(BundleMessage.format("UI_DAVMAIL_GATEWAY", new Object[0]));
                    toolTip.setMessage(message);
                    trayItem.setToolTip(toolTip);
                    if (this.firstMessage) {
                        this.firstMessage = false;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    toolTip.setVisible(true);
                }
                trayItem.setToolTipText(BundleMessage.format("UI_DAVMAIL_GATEWAY", new Object[0]) + '\n' + message);
            });
        }
    }

    public static org.eclipse.swt.graphics.Image loadSwtImage(String fileName) {
        org.eclipse.swt.graphics.Image result = null;
        try {
            ClassLoader classloader = DavGatewayTray.class.getClassLoader();
            URL imageUrl = classloader.getResource(fileName);
            if (imageUrl == null) {
                throw new IOException(fileName);
            }
            byte[] imageContent = IOUtil.readFully(imageUrl.openStream());
            org.eclipse.swt.graphics.Image tempImage = new org.eclipse.swt.graphics.Image((Device)display, (InputStream)new ByteArrayInputStream(imageContent));
            org.eclipse.swt.graphics.Image backgroundImage = new org.eclipse.swt.graphics.Image(null, 24, 24);
            ImageData imageData = backgroundImage.getImageData();
            imageData.transparentPixel = imageData.getPixel(0, 0);
            backgroundImage.dispose();
            result = new org.eclipse.swt.graphics.Image(null, imageData);
            GC gc = new GC((Drawable)result);
            gc.drawImage(tempImage, 4, 4);
            tempImage.dispose();
        }
        catch (IOException e) {
            DavGatewayTray.warn(new BundleMessage("LOG_UNABLE_TO_LOAD_IMAGE", new Object[0]), e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void init() {
        try {
            Class<?> gtk = Class.forName("org.eclipse.swt.internal.gtk.GTK");
            boolean isGTK3 = (Boolean)gtk.getDeclaredField("GTK3").get(null);
            LOGGER.debug((Object)("org.eclipse.swt.internal.gtk.GTK.GTK3=" + isGTK3));
            if (isGTK3) {
                LOGGER.warn((Object)"GTK 3 not supported, please set SWT_GTK3=0");
            }
        }
        catch (Throwable gtk) {
            // empty catch block
        }
        try {
            Class<?> gdk = Class.forName("org.eclipse.swt.internal.gtk.GDK");
            gdk.getDeclaredMethod("gdk_error_trap_push", new Class[0]).invoke(null, new Object[0]);
            LOGGER.debug((Object)"Called org.eclipse.swt.internal.gtk.GDK.gdk_error_trap_push");
        }
        catch (Throwable gdk) {
            // empty catch block
        }
        try {
            OS.class.getDeclaredMethod("gdk_error_trap_push", new Class[0]).invoke(null, new Object[0]);
            LOGGER.debug((Object)"Called org.eclipse.swt.internal.gtk.OS.gdk_error_trap_push");
        }
        catch (Exception gdk) {
            // empty catch block
        }
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception e) {
            DavGatewayTray.warn(new BundleMessage("LOG_UNABLE_TO_SET_LOOK_AND_FEEL", new Object[0]));
        }
        new Thread("SWT"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DeviceData data = new DeviceData();
                    data.debug = true;
                    display = new Display(data);
                    shell = new Shell(display);
                    Tray tray = display.getSystemTray();
                    if (tray != null) {
                        trayItem = new TrayItem(tray, 0);
                        trayItem.setToolTipText(BundleMessage.format("UI_DAVMAIL_GATEWAY", new Object[0]));
                        frameIcons = new ArrayList();
                        frameIcons.add(DavGatewayTray.loadImage("tray128.png"));
                        frameIcons.add(DavGatewayTray.loadImage("tray.png"));
                        image = SwtGatewayTray.loadSwtImage("tray.png");
                        image2 = SwtGatewayTray.loadSwtImage("tray2.png");
                        inactiveImage = SwtGatewayTray.loadSwtImage("trayinactive.png");
                        trayItem.setImage(image);
                        trayItem.addDisposeListener(e -> {
                            if (image != null && !image.isDisposed()) {
                                image.dispose();
                            }
                            if (image2 != null && !image2.isDisposed()) {
                                image2.dispose();
                            }
                            if (inactiveImage != null && !inactiveImage.isDisposed()) {
                                inactiveImage.dispose();
                            }
                        });
                        Menu popup = new Menu((Decorations)shell, 8);
                        trayItem.addListener(35, event -> display.asyncExec(() -> popup.setVisible(true)));
                        MenuItem aboutItem = new MenuItem(popup, 8);
                        aboutItem.setText(BundleMessage.format("UI_ABOUT", new Object[0]));
                        aboutItem.addListener(13, event -> SwingUtilities.invokeLater(() -> {
                            if (SwtGatewayTray.this.aboutFrame == null) {
                                SwtGatewayTray.this.aboutFrame = new AboutFrame();
                            }
                            SwtGatewayTray.this.aboutFrame.update();
                            SwtGatewayTray.this.aboutFrame.setVisible(true);
                            SwtGatewayTray.this.aboutFrame.toFront();
                            SwtGatewayTray.this.aboutFrame.requestFocus();
                        }));
                        trayItem.addListener(14, event -> SwingUtilities.invokeLater(() -> SwtGatewayTray.this.openSettingsFrame()));
                        MenuItem defaultItem = new MenuItem(popup, 8);
                        defaultItem.setText(BundleMessage.format("UI_SETTINGS", new Object[0]));
                        defaultItem.addListener(13, event -> SwingUtilities.invokeLater(() -> SwtGatewayTray.this.openSettingsFrame()));
                        MenuItem logItem = new MenuItem(popup, 8);
                        logItem.setText(BundleMessage.format("UI_SHOW_LOGS", new Object[0]));
                        logItem.addListener(13, event -> SwingUtilities.invokeLater(DavGatewayTray::showLogs));
                        MenuItem exitItem = new MenuItem(popup, 8);
                        exitItem.setText(BundleMessage.format("UI_EXIT", new Object[0]));
                        exitItem.addListener(13, event -> DavGateway.stop());
                        if (Settings.isFirstStart()) {
                            SwingUtilities.invokeLater(() -> {
                                if (SwtGatewayTray.this.settingsFrame == null) {
                                    SwtGatewayTray.this.settingsFrame = new SettingsFrame();
                                }
                                SwtGatewayTray.this.settingsFrame.setVisible(true);
                                SwtGatewayTray.this.settingsFrame.toFront();
                                SwtGatewayTray.this.settingsFrame.requestFocus();
                            });
                        }
                        Object object = LOCK;
                        synchronized (object) {
                            SwtGatewayTray.this.isReady = true;
                            LOCK.notifyAll();
                        }
                        while (!shell.isDisposed()) {
                            if (display.readAndDispatch()) continue;
                            display.sleep();
                        }
                    }
                    if (SwtGatewayTray.this.settingsFrame != null) {
                        SwtGatewayTray.this.settingsFrame.dispose();
                    }
                    if (SwtGatewayTray.this.aboutFrame != null) {
                        SwtGatewayTray.this.aboutFrame.dispose();
                    }
                }
                catch (Exception exc) {
                    DavGatewayTray.error(exc);
                }
                catch (Error exc) {
                    SwtGatewayTray.this.error = exc;
                    throw exc;
                }
                System.exit(0);
            }
        }.start();
        while (true) {
            try {
                while (true) {
                    Object e = LOCK;
                    synchronized (e) {
                        if (this.error != null) {
                            throw this.error;
                        }
                        if (this.isReady) {
                            return;
                        }
                        LOCK.wait(1000L);
                    }
                }
            }
            catch (InterruptedException e) {
                DavGatewayTray.error(new BundleMessage("LOG_ERROR_WAITING_FOR_SWT_INIT", new Object[0]), e);
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    private void openSettingsFrame() {
        if (this.settingsFrame == null) {
            this.settingsFrame = new SettingsFrame();
        }
        this.settingsFrame.reload();
        this.settingsFrame.setVisible(true);
        this.settingsFrame.toFront();
        this.settingsFrame.requestFocus();
    }

    @Override
    public void dispose() {
        shell.dispose();
    }
}

