/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.service;

import java.net.SocketAddress;
import java.util.Collections;
import java.util.Set;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.util.IdentityHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTransportMetadata
implements TransportMetadata {
    private final String providerName;
    private final String name;
    private final boolean connectionless;
    private final boolean fragmentation;
    private final Class<? extends SocketAddress> addressType;
    private final Class<? extends IoSessionConfig> sessionConfigType;
    private final Set<Class<? extends Object>> envelopeTypes;

    public DefaultTransportMetadata(String string, String string2, boolean bl, boolean bl2, Class<? extends SocketAddress> clazz, Class<? extends IoSessionConfig> clazz2, Class<?> ... classArray) {
        if (string == null) {
            throw new IllegalArgumentException("providerName");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("name");
        }
        if ((string = string.trim().toLowerCase()).length() == 0) {
            throw new IllegalArgumentException("providerName is empty.");
        }
        if ((string2 = string2.trim().toLowerCase()).length() == 0) {
            throw new IllegalArgumentException("name is empty.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("addressType");
        }
        if (classArray == null) {
            throw new IllegalArgumentException("envelopeTypes");
        }
        if (classArray.length == 0) {
            throw new IllegalArgumentException("envelopeTypes is empty.");
        }
        if (clazz2 == null) {
            throw new IllegalArgumentException("sessionConfigType");
        }
        this.providerName = string;
        this.name = string2;
        this.connectionless = bl;
        this.fragmentation = bl2;
        this.addressType = clazz;
        this.sessionConfigType = clazz2;
        IdentityHashSet identityHashSet = new IdentityHashSet();
        for (Class<?> clazz3 : classArray) {
            identityHashSet.add(clazz3);
        }
        this.envelopeTypes = Collections.unmodifiableSet(identityHashSet);
    }

    @Override
    public Class<? extends SocketAddress> getAddressType() {
        return this.addressType;
    }

    @Override
    public Class<? extends IoSessionConfig> getSessionConfigType() {
        return this.sessionConfigType;
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isConnectionless() {
        return this.connectionless;
    }

    @Override
    public boolean hasFragmentation() {
        return this.fragmentation;
    }

    public String toString() {
        return this.name;
    }
}

