/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderAdapter;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

public abstract class CumulativeProtocolDecoder
extends ProtocolDecoderAdapter {
    private final AttributeKey BUFFER = new AttributeKey(this.getClass(), "buffer");

    protected CumulativeProtocolDecoder() {
    }

    public void decode(IoSession ioSession, IoBuffer ioBuffer, ProtocolDecoderOutput protocolDecoderOutput) throws Exception {
        int n;
        if (!ioSession.getTransportMetadata().hasFragmentation()) {
            while (ioBuffer.hasRemaining() && this.doDecode(ioSession, ioBuffer, protocolDecoderOutput)) {
            }
            return;
        }
        boolean bl = true;
        IoBuffer ioBuffer2 = (IoBuffer)ioSession.getAttribute(this.BUFFER);
        if (ioBuffer2 != null) {
            n = 0;
            if (ioBuffer2.isAutoExpand()) {
                try {
                    ioBuffer2.put(ioBuffer);
                    n = 1;
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            if (n != 0) {
                ioBuffer2.flip();
            } else {
                ioBuffer2.flip();
                IoBuffer ioBuffer3 = IoBuffer.allocate(ioBuffer2.remaining() + ioBuffer.remaining()).setAutoExpand(true);
                ioBuffer3.order(ioBuffer2.order());
                ioBuffer3.put(ioBuffer2);
                ioBuffer3.put(ioBuffer);
                ioBuffer3.flip();
                ioBuffer2 = ioBuffer3;
                ioSession.setAttribute(this.BUFFER, ioBuffer2);
            }
        } else {
            ioBuffer2 = ioBuffer;
            bl = false;
        }
        do {
            n = ioBuffer2.position();
            boolean bl2 = this.doDecode(ioSession, ioBuffer2, protocolDecoderOutput);
            if (!bl2) break;
            if (ioBuffer2.position() != n) continue;
            throw new IllegalStateException("doDecode() can't return true when buffer is not consumed.");
        } while (ioBuffer2.hasRemaining());
        if (ioBuffer2.hasRemaining()) {
            if (bl && ioBuffer2.isAutoExpand()) {
                ioBuffer2.compact();
            } else {
                this.storeRemainingInSession(ioBuffer2, ioSession);
            }
        } else if (bl) {
            this.removeSessionBuffer(ioSession);
        }
    }

    protected abstract boolean doDecode(IoSession var1, IoBuffer var2, ProtocolDecoderOutput var3) throws Exception;

    public void dispose(IoSession ioSession) throws Exception {
        this.removeSessionBuffer(ioSession);
    }

    private void removeSessionBuffer(IoSession ioSession) {
        ioSession.removeAttribute(this.BUFFER);
    }

    private void storeRemainingInSession(IoBuffer ioBuffer, IoSession ioSession) {
        IoBuffer ioBuffer2 = IoBuffer.allocate(ioBuffer.capacity()).setAutoExpand(true);
        ioBuffer2.order(ioBuffer.order());
        ioBuffer2.put(ioBuffer);
        ioSession.setAttribute(this.BUFFER, ioBuffer2);
    }
}

