/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.proxy.handlers.http.ntlm;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.proxy.ProxyAuthException;
import org.apache.mina.proxy.handlers.http.AbstractAuthLogicHandler;
import org.apache.mina.proxy.handlers.http.HttpProxyRequest;
import org.apache.mina.proxy.handlers.http.HttpProxyResponse;
import org.apache.mina.proxy.handlers.http.ntlm.NTLMUtilities;
import org.apache.mina.proxy.session.ProxyIoSession;
import org.apache.mina.proxy.utils.StringUtilities;
import org.apache.mina.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpNTLMAuthLogicHandler
extends AbstractAuthLogicHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpNTLMAuthLogicHandler.class);
    private byte[] challengePacket = null;

    public HttpNTLMAuthLogicHandler(ProxyIoSession proxyIoSession) throws ProxyAuthException {
        super(proxyIoSession);
        ((HttpProxyRequest)this.request).checkRequiredProperties("USER", "PWD", "DOMAIN", "WORKSTATION");
    }

    public void doHandshake(IoFilter.NextFilter nextFilter) throws ProxyAuthException {
        LOGGER.debug(" doHandshake()");
        if (this.step > 0 && this.challengePacket == null) {
            throw new IllegalStateException("NTLM Challenge packet not received");
        }
        HttpProxyRequest httpProxyRequest = (HttpProxyRequest)this.request;
        HashMap<String, List<String>> hashMap = httpProxyRequest.getHeaders() != null ? httpProxyRequest.getHeaders() : new HashMap<String, List<String>>();
        String string = httpProxyRequest.getProperties().get("DOMAIN");
        String string2 = httpProxyRequest.getProperties().get("WORKSTATION");
        if (this.step > 0) {
            LOGGER.debug("  sending NTLM challenge response");
            byte[] byArray = NTLMUtilities.extractChallengeFromType2Message(this.challengePacket);
            int n = NTLMUtilities.extractFlagsFromType2Message(this.challengePacket);
            String string3 = httpProxyRequest.getProperties().get("USER");
            String string4 = httpProxyRequest.getProperties().get("PWD");
            byte[] byArray2 = NTLMUtilities.createType3Message(string3, string4, byArray, string, string2, n, null);
            StringUtilities.addValueToHeader(hashMap, "Proxy-Authorization", "NTLM " + new String(Base64.encodeBase64(byArray2)), true);
        } else {
            LOGGER.debug("  sending NTLM negotiation packet");
            byte[] byArray = NTLMUtilities.createType1Message(string2, string, null, null);
            StringUtilities.addValueToHeader(hashMap, "Proxy-Authorization", "NTLM " + new String(Base64.encodeBase64(byArray)), true);
        }
        HttpNTLMAuthLogicHandler.addKeepAliveHeaders(hashMap);
        httpProxyRequest.setHeaders(hashMap);
        this.writeRequest(nextFilter, httpProxyRequest);
        ++this.step;
    }

    private String getNTLMHeader(HttpProxyResponse httpProxyResponse) {
        List<String> list = httpProxyResponse.getHeaders().get("Proxy-Authenticate");
        for (String string : list) {
            if (!string.startsWith("NTLM")) continue;
            return string;
        }
        return null;
    }

    public void handleResponse(HttpProxyResponse httpProxyResponse) throws ProxyAuthException {
        String string;
        if (this.step == 0) {
            string = this.getNTLMHeader(httpProxyResponse);
            this.step = 1;
            if (string == null || string.length() < 5) {
                return;
            }
        }
        if (this.step == 1) {
            string = this.getNTLMHeader(httpProxyResponse);
            if (string == null || string.length() < 5) {
                throw new ProxyAuthException("Unexpected error while reading server challenge !");
            }
            try {
                this.challengePacket = Base64.decodeBase64(string.substring(5).getBytes(this.proxyIoSession.getCharsetName()));
            }
            catch (IOException iOException) {
                throw new ProxyAuthException("Unable to decode the base64 encoded NTLM challenge", iOException);
            }
        } else {
            throw new ProxyAuthException("Received unexpected response code (" + httpProxyResponse.getStatusLine() + ").");
        }
        this.step = 2;
    }
}

