/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Sound;
import cz.vity.freerapid.utilities.os.SystemCommanderFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdesktop.application.ApplicationContext;

public final class QuietMode {
    private static final Logger logger = Logger.getLogger(QuietMode.class.getName());
    private static final QuietMode INSTANCE = new QuietMode();
    private final ApplicationContext context = MainApp.getAContext();

    public static QuietMode getInstance() {
        return INSTANCE;
    }

    private QuietMode() {
    }

    public boolean isEnabled() {
        return AppPrefs.getProperty("quietModeEnabled", false);
    }

    public void setEnabled(boolean enabled) {
        AppPrefs.storeProperty("quietModeEnabled", enabled);
    }

    public boolean isActive() {
        if (this.isEnabled()) {
            String mode = AppPrefs.getProperty("quietModeActivationMode", "always");
            if ("always".equals(mode)) {
                return true;
            }
            if ("whenWindowsFound".equals(mode)) {
                return this.findWindow();
            }
        }
        return false;
    }

    private boolean findWindow() {
        List<String> windows;
        try {
            windows = SystemCommanderFactory.getInstance().getSystemCommanderInstance(this.context).getTopLevelWindowsList();
        }
        catch (IOException e) {
            LogUtils.processException(logger, e);
            return false;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Detected system windows " + Arrays.toString(windows.toArray(new String[windows.size()])));
        }
        boolean caseSensitive = AppPrefs.getProperty("quietModeCaseSensitiveSearch", false);
        List<String> stringsToFind = this.getActivationStrings();
        if (!caseSensitive) {
            for (int i = 0; i < stringsToFind.size(); ++i) {
                stringsToFind.set(i, stringsToFind.get(i).toLowerCase(Locale.ENGLISH));
            }
        }
        for (String window : windows) {
            if (!caseSensitive) {
                window = window.toLowerCase(Locale.ENGLISH);
            }
            for (String stringToFind : stringsToFind) {
                if (!window.contains(stringToFind)) continue;
                logger.info("Quiet mode is active");
                return true;
            }
        }
        return false;
    }

    public boolean isSoundsDisabled() {
        return AppPrefs.getProperty("quietModeNoSounds", true);
    }

    public boolean isCaptchaDisabled() {
        return AppPrefs.getProperty("quietModeNoCaptcha", true);
    }

    public boolean isDialogsDisabled() {
        return AppPrefs.getProperty("quietModeNoConfirmDialogs", true);
    }

    public void playUserInteractionRequiredSound() {
        if (AppPrefs.getProperty("quietModePlaySoundOnActivate", false)) {
            Sound.playSound(this.context.getResourceMap().getString("userInteractionRequiredWav", new Object[0]), false);
        }
    }

    public List<String> getActivationStrings() {
        ArrayList<String> list = new ArrayList<String>();
        String quietModeActivationStrings = AppPrefs.getProperty("quietModeActivationStrings", "VLC media player|iTunes|Call of Duty|- SMPlayer");
        for (String string : quietModeActivationStrings.split("(?<!\\\\)\\|")) {
            if ((string = string.trim()).isEmpty()) continue;
            list.add(string.replace("\\|", "|"));
        }
        return list;
    }

    public void setActivationStrings(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String string : list) {
            sb.append(string.replace("|", "\\|")).append('|');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        AppPrefs.storeProperty("quietModeActivationStrings", sb.toString());
    }
}

