/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.value.Trigger;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.dialogs.AppDialog;
import cz.vity.freerapid.swing.ComponentFactory;
import cz.vity.freerapid.swing.LimitedPlainDocument;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.binding.MyPresentationModel;
import cz.vity.freerapid.swing.components.CompTitledPane;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jdesktop.application.Action;
import org.jdesktop.swinghelper.buttonpanel.JXButtonPanel;

public class ConnectDialog
extends AppDialog {
    private static final Logger logger = Logger.getLogger(ConnectDialog.class.getName());
    private MyPresentationModel model = null;
    private JTextField fieldHostName;
    private JTextField fieldPort;
    private JCheckBox checkAuthentification;
    private JTextField fieldUserName;
    private JPasswordField fieldPassword;
    private JCheckBox checkStorePassword;
    private JButton btnOk;
    private JButton btnCancel;
    private JPanel contentPanel;
    private JLabel labelLoginName;
    private JLabel labelPassword;
    private JLabel labelWarning;
    private JCheckBox checkUseProxy;
    private JCheckBox checkSocksProxy;

    public ConnectDialog(JDialog owner) {
        super((Dialog)owner, true);
        this.setName("ConnectDialog");
        try {
            this.initComponents();
            this.build();
        }
        catch (Exception e) {
            LogUtils.processException(logger, e);
            this.doClose();
        }
    }

    @Action
    public void cancelBtnAction() {
        this.model.triggerFlush();
        this.doClose();
    }

    @Action
    public void okBtnAction() {
        this.setResult(0);
        this.model.triggerCommit();
        AppPrefs.storeProperty("proxy.password", Utils.generateXorString(String.valueOf(this.fieldPassword.getPassword())));
        this.doClose();
    }

    @Override
    public void doClose() {
        if (this.model != null) {
            this.model.release();
        }
        super.doClose();
    }

    private void build() {
        this.inject();
        this.buildGUI();
        this.buildModels();
        this.setAction(this.btnOk, "okBtnAction");
        this.setAction(this.btnCancel, "cancelBtnAction");
        this.pack();
        this.setResizable(true);
        ConnectDialog.locateOnOpticalScreenCenter(this);
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.btnCancel;
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.btnOk;
    }

    private void buildModels() {
        this.model = new MyPresentationModel(null, (ValueModel)new Trigger());
        this.bind(this.fieldHostName, "proxy.url", (Object)"");
        this.bind(this.fieldUserName, "proxy.username", (Object)"");
        this.bind(this.fieldPort, "proxy.port", (Object)"");
        this.bind(this.checkStorePassword, "proxy.savepassword", (Object)false);
        this.bind(this.checkAuthentification, "proxy.login", (Object)false);
        this.bind(this.checkUseProxy, "proxy", (Object)false);
        this.bind(this.checkSocksProxy, "defaultConnectionSocks", (Object)false);
        this.fieldPassword.setText(Utils.generateXorString(AppPrefs.getProperty("proxy.password", "")));
    }

    private void buildGUI() {
        this.checkAuthentification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = ConnectDialog.this.checkAuthentification.isSelected();
                ConnectDialog.this.updateEnabledUseLogin(enabled);
                if (enabled) {
                    Swinger.inputFocus(ConnectDialog.this.fieldUserName);
                }
            }
        });
        this.checkUseProxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectDialog.this.updateEnabledUseProxy(ConnectDialog.this.checkUseProxy.isSelected());
            }
        });
        boolean useProxy = AppPrefs.getProperty("proxy", false);
        this.updateEnabledUseProxy(useProxy);
        this.updateEnabledUseLogin(AppPrefs.getProperty("proxy.login", false) && useProxy);
    }

    private void updateEnabledUseProxy(boolean enabled) {
        Component[] components;
        for (Component comp : components = this.contentPanel.getComponents()) {
            if (comp.equals(this.checkUseProxy)) continue;
            comp.setEnabled(enabled);
        }
        this.checkSocksProxy.setEnabled(enabled);
        if (this.checkAuthentification.isSelected() && enabled) {
            this.updateEnabledUseLogin(true);
        } else {
            this.updateEnabledUseLogin(false);
        }
        if (enabled) {
            Swinger.inputFocus(this.fieldHostName);
        }
    }

    private void updateEnabledUseLogin(boolean enabled) {
        this.fieldUserName.setEnabled(enabled);
        this.fieldPassword.setEnabled(enabled);
        this.checkStorePassword.setEnabled(enabled);
        this.labelLoginName.setEnabled(enabled);
        this.labelPassword.setEnabled(enabled);
        this.labelWarning.setEnabled(enabled);
    }

    private void bind(JCheckBox checkBox, String key, Object defaultValue) {
        Bindings.bind(checkBox, this.model.getBufferedPreferences(key, defaultValue));
    }

    private void bind(JTextField field, String key, Object defaultValue) {
        Bindings.bind(field, this.model.getBufferedPreferences(key, defaultValue), false);
    }

    private void initComponents() {
        JPanel dialogPane = new JPanel();
        this.checkUseProxy = new JCheckBox();
        this.checkSocksProxy = new JCheckBox();
        this.checkUseProxy.setName("checkUseHttpProxy");
        this.checkSocksProxy.setName("checkSocksProxy");
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 2));
        topPanel.add(this.checkUseProxy);
        topPanel.add(Box.createHorizontalGlue());
        topPanel.add(this.checkSocksProxy);
        CompTitledPane panelProxyPane = new CompTitledPane(topPanel);
        this.contentPanel = panelProxyPane.getContentPane();
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JLabel labelHostName = new JLabel();
        this.fieldHostName = ComponentFactory.getTextField();
        JLabel labelPortNumber = new JLabel();
        this.fieldPort = ComponentFactory.getTextField();
        this.checkAuthentification = new JCheckBox();
        this.labelLoginName = new JLabel();
        this.fieldUserName = ComponentFactory.getTextField();
        this.labelPassword = new JLabel();
        this.fieldPassword = new JPasswordField();
        this.checkStorePassword = new JCheckBox();
        this.labelWarning = new JLabel();
        JXButtonPanel buttonBar = new JXButtonPanel();
        buttonBar.setCyclic(true);
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        CellConstraints cc = new CellConstraints();
        this.fieldPort.setDocument(new LimitedPlainDocument("[0-9]{0,6}"));
        this.setName("ConnectDialog");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        dialogPane.setBorder(Borders.DIALOG);
        dialogPane.setName("dialogPane");
        dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setName("contentPanel");
        labelHostName.setLabelFor(this.fieldHostName);
        labelHostName.setName("labelHostName");
        this.fieldHostName.setColumns(10);
        this.fieldHostName.setName("fieldHostName");
        labelPortNumber.setLabelFor(this.fieldPort);
        labelPortNumber.setName("labelPortNumber");
        this.fieldPort.setColumns(5);
        this.fieldPort.setName("fieldPort");
        this.checkAuthentification.setName("checkUserProxy");
        this.labelLoginName.setLabelFor(this.fieldUserName);
        this.labelLoginName.setName("labelLoginName");
        this.fieldUserName.setName("fieldLogin");
        this.labelPassword.setLabelFor(this.fieldPassword);
        this.labelPassword.setName("labelPassword");
        this.fieldPassword.setName("fieldPassword");
        this.checkStorePassword.setName("checkStorePassword");
        this.labelWarning.setName("labelWarning");
        PanelBuilder contentPanelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormSpecs.PREF_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.PREFERRED, 1.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}), this.contentPanel);
        contentPanelBuilder.add((Component)labelHostName, cc.xy(1, 1));
        contentPanelBuilder.add((Component)this.fieldHostName, cc.xy(3, 1));
        contentPanelBuilder.add((Component)labelPortNumber, cc.xy(5, 1));
        contentPanelBuilder.add((Component)this.fieldPort, cc.xy(7, 1));
        contentPanelBuilder.add((Component)this.checkAuthentification, new CellConstraints(1, 3, 3, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 7, 0, 0)));
        contentPanelBuilder.add((Component)this.labelLoginName, cc.xy(1, 5));
        contentPanelBuilder.add((Component)this.fieldUserName, cc.xy(3, 5));
        contentPanelBuilder.add((Component)this.labelPassword, cc.xy(1, 7));
        contentPanelBuilder.add((Component)this.fieldPassword, cc.xy(3, 7));
        contentPanelBuilder.add((Component)this.checkStorePassword, cc.xywh(5, 7, 3, 1));
        contentPanelBuilder.add((Component)this.labelWarning, cc.xywh(1, 9, 7, 1));
        dialogPane.add((Component)panelProxyPane, "Center");
        buttonBar.setBorder(Borders.BUTTON_BAR_PAD);
        buttonBar.setName("buttonBar");
        this.btnOk.setName("btnOk");
        this.btnCancel.setName("btnCancel");
        PanelBuilder buttonBarBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormSpecs.GLUE_COLSPEC, FormSpecs.BUTTON_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ComponentFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs("pref")), buttonBar);
        ((FormLayout)buttonBar.getLayout()).setColumnGroups(new int[][]{{2, 4}});
        buttonBarBuilder.add((Component)this.btnOk, cc.xy(2, 1));
        buttonBarBuilder.add((Component)this.btnCancel, cc.xy(4, 1));
        dialogPane.add((Component)buttonBar, "South");
        contentPane.add((Component)dialogPane, "Center");
    }
}

