/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs.filechooser;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.dialogs.filechooser.EnhancedFileFilter;
import cz.vity.freerapid.swing.Swinger;
import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import org.jdesktop.appframework.swingx.SingleXFrameApplication;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;

abstract class JAppFileChooser
extends JFileChooser {
    public JAppFileChooser(File currentDirectory) {
        super(currentDirectory);
        this.setName(this.getDialogName());
        Swinger.getResourceMap(JAppFileChooser.class).injectComponents(this);
    }

    @Override
    public int showSaveDialog(Component parent) throws HeadlessException {
        return super.showSaveDialog(parent);
    }

    @Override
    protected JDialog createDialog(Component parent) throws HeadlessException {
        JDialog dialog = super.createDialog(parent);
        Application application = Application.getInstance(Application.class);
        ApplicationContext context = application.getContext();
        if (context.getApplication() instanceof SingleXFrameApplication) {
            dialog.setName(this.getDialogName());
            ((SingleXFrameApplication)context.getApplication()).prepareDialog(dialog, false);
        }
        return dialog;
    }

    public void setFileName(String fileName) {
        FileChooserUI chooserUI = this.getUI();
        if (chooserUI instanceof BasicFileChooserUI) {
            ((BasicFileChooserUI)chooserUI).setFileName(fileName);
        }
    }

    protected abstract String getDialogName();

    public void updateFileFilters(List<EnhancedFileFilter> fileFilters, String lastUsedKey) {
        if (lastUsedKey == null) {
            return;
        }
        for (EnhancedFileFilter fileFilter : fileFilters) {
            this.addChoosableFileFilter(fileFilter);
        }
        int filterIndex = AppPrefs.getProperty(lastUsedKey, fileFilters.size() - 1);
        if (filterIndex >= 0 && filterIndex < fileFilters.size()) {
            this.setFileFilter(fileFilters.get(filterIndex));
        }
    }
}

