/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.utilities.os.SystemCommander;
import cz.vity.freerapid.utilities.os.SystemCommanderFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.jdesktop.application.ApplicationContext;

public class SystemManager {
    private ManagerDirector director;
    private ApplicationContext context;
    private static final Logger logger = Logger.getLogger(SystemManager.class.getName());

    public SystemManager(ManagerDirector director, ApplicationContext context) {
        this.director = director;
        this.context = context;
    }

    void initManager() {
        final PropertyChangeListener pcl = new PropertyChangeListener(){
            private boolean lastState = false;

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean newState;
                boolean bl = newState = AppPrefs.getProperty("preventStandbyWhileDownloading", false) && SystemManager.this.isDownloading();
                if (newState != this.lastState) {
                    this.lastState = newState;
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("preventSystemStandby(" + newState + ")");
                    }
                    SystemCommander commander = SystemCommanderFactory.getInstance().getSystemCommanderInstance(SystemManager.this.context);
                    commander.preventSystemStandby(newState);
                }
            }
        };
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                if ("preventStandbyWhileDownloading".equals(evt.getKey())) {
                    pcl.propertyChange(null);
                }
            }
        });
        this.director.getDataManager().getProcessManager().addPropertyChangeListener("downloading", pcl);
    }

    private boolean isDownloading() {
        return this.director.getDataManager().getDownloading() > 0;
    }
}

