/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.core.AppPrefs;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskService;

public class TaskServiceManager {
    private static final Logger logger = Logger.getLogger(TaskServiceManager.class.getName());
    public static final String DOWNLOAD_SERVICE = "downloadService";
    public static final String RUN_CHECK_SERVICE = "runCheckService";
    public static final String MOVE_FILE_SERVICE = "moveFile";
    public static final String WORK_WITH_FILE_SERVICE = "workWithFile";
    public static final String DATABASE_SERVICE = "databaseService";
    private final ApplicationContext context;

    public TaskServiceManager(ApplicationContext context) {
        this.context = context;
    }

    public synchronized TaskService getTaskService(String name) {
        TaskService service = this.context.getTaskService(name);
        if (service == null) {
            if (DOWNLOAD_SERVICE.equals(name)) {
                return this.initDownloadTaskService();
            }
            if (RUN_CHECK_SERVICE.equals(name)) {
                return this.initRunCheckTaskService();
            }
            if (MOVE_FILE_SERVICE.equals(name)) {
                return this.initMoveFileTaskService();
            }
            if (WORK_WITH_FILE_SERVICE.equals(name)) {
                return this.initWorkWithFileTaskService();
            }
            if (DATABASE_SERVICE.equals(name)) {
                return this.initWorkWithDatabaseTaskService();
            }
        }
        return service;
    }

    private TaskService initDownloadTaskService() {
        return this.initTaskService(DOWNLOAD_SERVICE, Executors.newCachedThreadPool());
    }

    private TaskService initRunCheckTaskService() {
        int max = AppPrefs.getProperty("maxSimultaneousRunCheck", 5);
        return this.initTaskService(RUN_CHECK_SERVICE, TaskServiceManager.newExecutorService(max));
    }

    private TaskService initMoveFileTaskService() {
        return this.initTaskService(MOVE_FILE_SERVICE, TaskServiceManager.newExecutorService(1));
    }

    private TaskService initWorkWithFileTaskService() {
        return this.initTaskService(WORK_WITH_FILE_SERVICE, TaskServiceManager.newExecutorService(1));
    }

    private TaskService initWorkWithDatabaseTaskService() {
        return this.initTaskService(DATABASE_SERVICE, Executors.newSingleThreadExecutor());
    }

    private static ExecutorService newExecutorService(int numThreads) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(numThreads, numThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    private TaskService initTaskService(String name, ExecutorService executor) {
        TaskService service = new TaskService(name, executor);
        this.context.addTaskService(service);
        logger.info("Creating pool " + name);
        return service;
    }

    public void runTask(String taskServiceName, Task task) {
        this.getTaskService(taskServiceName).execute(task);
    }
}

