/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient;

import cz.vity.freerapid.plugins.webclient.interfaces.FileStreamRecognizer;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;

public class DefaultFileStreamRecognizer
implements FileStreamRecognizer {
    private static final Logger logger = Logger.getLogger(DefaultFileStreamRecognizer.class.getName());
    protected static final String[] DEFAULT_STREAM_VALUES = new String[]{"application/", "image/", "audio/", "video/", "<empty>"};
    protected static final String[] DEFAULT_TEXT_VALUES = new String[]{"text/", "xml", "javascript", "json", "smil"};
    protected final String[] streamValues;
    protected final String[] textValues;
    protected final boolean exactMatch;

    public DefaultFileStreamRecognizer() {
        this.streamValues = new String[0];
        this.textValues = new String[0];
        this.exactMatch = false;
    }

    public DefaultFileStreamRecognizer(String[] streamValues, String[] textValues, boolean exactMatch) {
        this.streamValues = streamValues;
        this.textValues = textValues;
        this.exactMatch = exactMatch;
    }

    @Override
    public boolean isStream(HttpMethod method, boolean showWarnings) {
        String contentType = this.getContentType(method);
        if (this.isOnList(contentType, this.textValues)) {
            return false;
        }
        if (this.isOnList(contentType, this.streamValues)) {
            return true;
        }
        if (!this.exactMatch) {
            if (this.isOnList(contentType, DEFAULT_TEXT_VALUES)) {
                return false;
            }
            if (this.isOnList(contentType, DEFAULT_STREAM_VALUES)) {
                return true;
            }
        }
        if (showWarnings) {
            logger.warning("Unknown content type: " + contentType);
        }
        return true;
    }

    protected boolean isOnList(String contentType, String[] list) {
        for (String s : list) {
            if (!contentType.contains(s)) continue;
            return true;
        }
        return false;
    }

    protected String getContentType(HttpMethod method) {
        String contentType;
        Header header = method.getResponseHeader("Content-Type");
        if (header != null && (contentType = header.getValue()) != null && !contentType.isEmpty()) {
            return contentType.toLowerCase(Locale.ENGLISH);
        }
        return "<empty>";
    }
}

