/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient;

import cz.vity.freerapid.plugins.exceptions.BuildMethodException;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpDownloadClient;
import cz.vity.freerapid.plugins.webclient.utils.PlugUtils;
import cz.vity.freerapid.utilities.Utils;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.util.URIUtil;

public final class MethodBuilder {
    private static final Logger logger = Logger.getLogger(MethodBuilder.class.getName());
    private static final Random random = new Random();
    private static final int FORM_MATCHER_TITLE_GROUP = 1;
    private static final int FORM_MATCHER_FORM_CONTENT = 2;
    private final String content;
    private HttpDownloadClient client;
    private Map<String, String> parameters = new LinkedHashMap<String, String>(4);
    private Map<String, String> headers = new LinkedHashMap<String, String>(2);
    private String referer;
    private String action;
    private HttpMethodEnum postMethod = HttpMethodEnum.POST;
    private String baseURL;
    private boolean encodeParameters = false;
    private String encoding = "UTF-8";
    private boolean autoReplaceEntities = true;
    private boolean encodePathAndQuery;
    private boolean addWww = false;
    private static Pattern formPattern;
    private static Pattern parameterInputPattern;
    private static Pattern parameterTypePattern;
    private static Pattern parameterNamePattern;
    private static Pattern parameterValuePattern;
    private static Pattern aHrefPattern;
    private static Pattern imgPattern;
    private static Pattern iframePattern;
    private boolean updateWww = false;

    public HttpMethodEnum getMethodAction() {
        return this.postMethod;
    }

    public MethodBuilder(String content, HttpDownloadClient client) {
        this.content = content;
        this.client = client;
    }

    public MethodBuilder(HttpDownloadClient client) {
        this(client.getContentAsString(), client);
    }

    public MethodBuilder setActionFromFormByName(String formIDOrName, boolean useFormParameters) throws BuildMethodException {
        Matcher formMatcher = this.getFormMatcher();
        int start = 0;
        boolean found = false;
        Pattern namePattern = Pattern.compile("(?:name|id)\\s?=\\s?(?:\"|')?" + formIDOrName + "(?:\"|'|\\s|>|$)", 10);
        while (formMatcher.find(start)) {
            String title = formMatcher.group(1);
            if (namePattern.matcher(title).find()) {
                this.inputForm(useFormParameters, title, formMatcher.group(2));
                found = true;
                break;
            }
            start = formMatcher.end();
        }
        if (!found) {
            throw new BuildMethodException("Tag <Form> with a name or ID '" + formIDOrName + "' was not found!");
        }
        return this;
    }

    public MethodBuilder setActionFromFormWhereActionContains(String text, boolean useFormParameters) throws BuildMethodException {
        Matcher formMatcher = this.getFormMatcher();
        boolean found = false;
        int start = 0;
        String lower = text.toLowerCase();
        while (formMatcher.find(start)) {
            String title = formMatcher.group(1);
            String action = this.extractAction(title);
            if (action != null && action.toLowerCase().contains(lower)) {
                this.inputForm(useFormParameters, title, formMatcher.group(2));
                found = true;
                break;
            }
            start = formMatcher.end();
        }
        if (!found) {
            throw new BuildMethodException("<Form> with defined action containing '" + text + "' was not found!");
        }
        return this;
    }

    public MethodBuilder setActionFromFormWhereTagContains(String text, boolean useFormParameters) throws BuildMethodException {
        Matcher formMatcher = this.getFormMatcher();
        boolean found = false;
        int start = 0;
        String lower = text.toLowerCase();
        while (formMatcher.find(start)) {
            String title = formMatcher.group(1);
            if (title.toLowerCase().contains(lower) || formMatcher.group(2).toLowerCase().contains(lower)) {
                this.inputForm(useFormParameters, title, formMatcher.group(2));
                found = true;
                break;
            }
            start = formMatcher.end();
        }
        if (!found) {
            throw new BuildMethodException("Tag <Form> containing '" + text + "' in the title was not found!");
        }
        return this;
    }

    public MethodBuilder setWww(boolean shouldContainWww) {
        this.updateWww = true;
        this.addWww = shouldContainWww;
        return this;
    }

    public MethodBuilder setActionFromTextBetween(String textBefore, String textAfter) throws BuildMethodException {
        if (textBefore == null) {
            throw new IllegalArgumentException("The text before the searched string cannot be null");
        }
        if (textAfter == null) {
            throw new IllegalArgumentException("The text after the searched string cannot be null");
        }
        Matcher matcher = Pattern.compile(Pattern.quote(Utils.rtrim(textBefore)) + "\\s*(.+?)\\s*" + Pattern.quote(Utils.ltrim(textAfter)), 42).matcher(this.content);
        if (!matcher.find()) {
            throw new BuildMethodException(String.format("The searched text between string '%s' and '%s' was not found.", textBefore, textAfter));
        }
        this.action = matcher.group(1).trim();
        this.postMethod = HttpMethodEnum.GET;
        this.checkAutoreplaceEntities();
        return this;
    }

    public MethodBuilder setActionFromAHrefWhereATagContains(String text) throws BuildMethodException {
        Matcher matcher = this.getAHrefMatcher();
        boolean found = false;
        int start = 0;
        String lower = text.toLowerCase();
        while (matcher.find(start)) {
            String content = matcher.group(2);
            if (content.toLowerCase().contains(lower)) {
                this.action = matcher.group(1);
                this.checkAutoreplaceEntities();
                found = true;
                this.postMethod = HttpMethodEnum.GET;
                break;
            }
            start = matcher.end();
        }
        if (!found) {
            throw new BuildMethodException("Tag <A> containing '" + text + "' was not found!");
        }
        return this;
    }

    private void checkAutoreplaceEntities() {
        if (this.autoReplaceEntities && this.action != null) {
            this.action = this.action.startsWith("&#104;&#116;&#116;&#112;") ? PlugUtils.unescapeHtml(this.action) : PlugUtils.replaceEntities(this.action);
        }
    }

    public MethodBuilder setActionFromImgSrcWhereTagContains(String text) throws BuildMethodException {
        if (imgPattern == null) {
            imgPattern = Pattern.compile("(<img(?:.*?)src\\s?=\\s?(?:\"|')(.+?)(?:\"|')(?:.*?)>)", 42);
        }
        Matcher matcher = imgPattern.matcher(this.content);
        boolean found = false;
        int start = 0;
        String lower = text.toLowerCase();
        while (matcher.find(start)) {
            String content = matcher.group(1);
            if (content.toLowerCase().contains(lower)) {
                this.action = matcher.group(2);
                this.checkAutoreplaceEntities();
                found = true;
                this.postMethod = HttpMethodEnum.GET;
                break;
            }
            start = matcher.end();
        }
        if (!found) {
            throw new BuildMethodException("Tag <img> containing '" + text + "' was not found!");
        }
        return this;
    }

    public MethodBuilder setActionFromIFrameSrcWhereTagContains(String text) throws BuildMethodException {
        if (iframePattern == null) {
            iframePattern = Pattern.compile("(<i?frame(?:.*?)src\\s?=\\s?(?:\"|')(.+?)(?:\"|')(?:.*?)>)", 42);
        }
        Matcher matcher = iframePattern.matcher(this.content);
        boolean found = false;
        int start = 0;
        String lower = text.toLowerCase();
        while (matcher.find(start)) {
            String content = matcher.group(1);
            if (content.toLowerCase().contains(lower)) {
                this.action = matcher.group(2);
                this.checkAutoreplaceEntities();
                found = true;
                this.postMethod = HttpMethodEnum.GET;
                break;
            }
            start = matcher.end();
        }
        if (!found) {
            throw new BuildMethodException("Tag <iframe> containing '" + text + "' was not found!");
        }
        return this;
    }

    public MethodBuilder setActionFromFormByIndex(int index, boolean useFormParameters) throws BuildMethodException {
        if (index < 1) {
            throw new IllegalArgumentException("Index must be higher or equal to 1");
        }
        Matcher formMatcher = this.getFormMatcher();
        int start = 0;
        int count = 1;
        boolean found = false;
        while (formMatcher.find(start)) {
            if (count++ == index) {
                found = true;
                this.inputForm(useFormParameters, formMatcher.group(1), formMatcher.group(2));
                break;
            }
            start = formMatcher.end();
        }
        if (!found) {
            throw new BuildMethodException("<Form> with index " + index + " from the top was not found");
        }
        return this;
    }

    private HttpMethodEnum extractMethod(String title) {
        Pattern actionPattern = Pattern.compile("method\\s?=\\s?(?:\"|')?\"(POST|GET)(?:\"|'|\\s*>)", 10);
        Matcher matcher = actionPattern.matcher(title);
        if (matcher.find()) {
            if ("POST".equalsIgnoreCase(matcher.group(1))) {
                return HttpMethodEnum.POST;
            }
            return HttpMethodEnum.GET;
        }
        return HttpMethodEnum.POST;
    }

    public MethodBuilder setMethodAction(String action) {
        this.action = action;
        return this;
    }

    public MethodBuilder setBaseURL(String baseURL) throws BuildMethodException {
        if (baseURL == null) {
            this.baseURL = null;
            return this;
        }
        try {
            new java.net.URI(baseURL);
        }
        catch (URISyntaxException e) {
            throw new BuildMethodException(e.getMessage());
        }
        this.baseURL = baseURL;
        return this;
    }

    public MethodBuilder addParameters(String ... parameters) throws BuildMethodException {
        if (parameters.length == 0) {
            throw new IllegalArgumentException("You have to provide some parameter names");
        }
        HashSet<String> set = new HashSet<String>(parameters.length);
        set.addAll(Arrays.asList(parameters));
        this.populateParameters(this.content);
        LinkedHashMap<String, String> p = new LinkedHashMap<String, String>(this.parameters);
        for (String paramName : this.parameters.keySet()) {
            if (set.contains(paramName)) {
                set.remove(paramName);
                continue;
            }
            p.remove(paramName);
        }
        if (!set.isEmpty()) {
            throw new BuildMethodException("The parameters " + Arrays.toString(set.toArray()) + " were not found");
        }
        this.parameters = p;
        return this;
    }

    public MethodBuilder removeParameter(String name) {
        this.parameters.remove(name);
        return this;
    }

    public MethodBuilder replaceEntitiesInAction() {
        this.action = PlugUtils.replaceEntities(this.action);
        return this;
    }

    public MethodBuilder unescapeHtml() {
        this.action = PlugUtils.unescapeHtml(this.action);
        return this;
    }

    public MethodBuilder clearParameters() {
        this.parameters.clear();
        return this;
    }

    public MethodBuilder setParameter(String name, String value) {
        if (value == null) {
            return this.removeParameter(name);
        }
        this.parameters.put(name, value);
        return this;
    }

    public MethodBuilder setAndEncodeParameter(String name, String value) throws BuildMethodException {
        return this.setParameter(name, this.encode(value));
    }

    private String encode(String value) throws BuildMethodException {
        String encoded;
        try {
            encoded = URLEncoder.encode(value, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new BuildMethodException(e.getMessage());
        }
        return encoded;
    }

    public MethodBuilder encodeLastPartOfAction() throws BuildMethodException {
        this.setEncodePathAndQuery(true);
        return this;
    }

    public MethodBuilder setEncodePathAndQuery(boolean b) throws BuildMethodException {
        this.encodePathAndQuery = b;
        return this;
    }

    public MethodBuilder setReferer(String referer) {
        this.referer = referer;
        return this;
    }

    public String getReferer() {
        return this.referer;
    }

    public HttpMethod toGetMethod() throws BuildMethodException {
        String s;
        if (this.referer != null) {
            this.client.setReferer(this.referer);
        }
        String uri = this.generateURL();
        if (!this.parameters.isEmpty()) {
            StringBuilder builder = new StringBuilder(uri);
            if (!uri.contains("?")) {
                builder.append('?');
            }
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                char lastChar = builder.charAt(builder.length() - 1);
                if (lastChar != '&' && lastChar != '?' && lastChar != '/') {
                    builder.append('&');
                }
                builder.append(entry.getKey()).append('=');
                if (!this.encodeParameters) {
                    builder.append(entry.getValue());
                    continue;
                }
                builder.append(this.encode(entry.getValue()));
            }
            uri = builder.toString();
        }
        try {
            s = this.encodePathAndQuery ? URIUtil.encodePathQuery(uri, this.encoding) : uri;
        }
        catch (URIException e) {
            throw new BuildMethodException("Cannot create URI");
        }
        uri = this.checkURI(s);
        GetMethod getMethod = this.client.getGetMethod(uri);
        this.setAdditionalHeaders(getMethod);
        return getMethod;
    }

    private void inputForm(boolean useFormParameters, String title, String content) {
        this.action = this.extractAction(title);
        if (this.action != null) {
            this.checkAutoreplaceEntities();
        } else {
            logger.info("Form has no defined action attribute");
        }
        this.postMethod = this.extractMethod(title);
        if (useFormParameters) {
            this.populateParameters(content);
        }
    }

    private static String getCorrectGroup(Matcher matcher) {
        for (int i = matcher.groupCount(); i > 0; --i) {
            String group = matcher.group(i);
            if (group == null) continue;
            return group;
        }
        throw new IllegalStateException("Group cannot be empty");
    }

    private void populateParameters(String content) {
        if (parameterInputPattern == null) {
            parameterInputPattern = Pattern.compile("<input (.+?>)", 42);
        }
        if (parameterTypePattern == null) {
            parameterTypePattern = Pattern.compile("type\\s?=\\s?(?:\"|')?(.*?)(?:\"|'|\\s|>)", 10);
        }
        if (parameterNamePattern == null) {
            parameterNamePattern = Pattern.compile("(?:name\\s?=\\s?)(?:([\"]([^\"]+)[\">])|([']([^']+)['>])|(([^'\">\\s]+)[/\\s>]))", 10);
        }
        if (parameterValuePattern == null) {
            parameterValuePattern = Pattern.compile("(?:value\\s?=\\s?)(?:([\"]([^\"]+)[\">])|([']([^']+)['>])|(([^'\">\\s]+)[/\\s>]))", 10);
        }
        Matcher matcher = parameterInputPattern.matcher(content);
        while (matcher.find()) {
            String input = matcher.group(1);
            Matcher matchName = parameterNamePattern.matcher(input);
            if (!matchName.find()) continue;
            String paramName = MethodBuilder.getCorrectGroup(matchName);
            String paramType = null;
            Matcher matchType = parameterTypePattern.matcher(input);
            if (matchType.find()) {
                paramType = matchType.group(1);
            }
            if ("image".equals(paramType)) {
                this.parameters.put(paramName + ".x", String.valueOf(random.nextInt(100)));
                this.parameters.put(paramName + ".y", String.valueOf(random.nextInt(100)));
                continue;
            }
            Matcher matchValue = parameterValuePattern.matcher(input);
            if (matchValue.find()) {
                this.parameters.put(paramName, MethodBuilder.getCorrectGroup(matchValue));
                continue;
            }
            this.parameters.put(paramName, "");
        }
    }

    private String extractAction(String title) {
        Pattern actionPattern = Pattern.compile("action\\s?=\\s?(?:\"|')?(.*?)(?:\"|'|\\s*>)", 10);
        Matcher matcher = actionPattern.matcher(title);
        if (matcher.find()) {
            String s = matcher.group(1);
            if (s.isEmpty()) {
                return null;
            }
            return s;
        }
        return null;
    }

    private String generateURL() throws BuildMethodException {
        String lowercase;
        String result = this.buildUrl();
        if (this.updateWww && (lowercase = result.toLowerCase(Locale.ENGLISH)).startsWith("http://")) {
            if (lowercase.startsWith("http://www.")) {
                if (!this.addWww) {
                    result = "http://" + result.substring(11);
                    logger.info("Removing WWW " + result);
                }
            } else if (this.addWww) {
                result = "http://www." + result.substring(7);
                logger.info("Adding WWW " + result);
            }
        }
        return result;
    }

    private String buildUrl() throws BuildMethodException {
        if (this.baseURL == null && this.action == null) {
            throw new BuildMethodException("Both action and base url has to be not null");
        }
        if (this.action != null) {
            if (this.action.toLowerCase(Locale.ENGLISH).startsWith("http")) {
                return this.action;
            }
            if (this.baseURL != null && this.baseURL.toLowerCase(Locale.ENGLISH).startsWith("http")) {
                if (this.action != null) {
                    String ac = this.action;
                    if (this.action.startsWith("/")) {
                        ac = this.action.substring(1);
                    } else if (this.action.startsWith("./")) {
                        ac = this.action.substring(2);
                    }
                    if (!this.baseURL.endsWith("/")) {
                        return this.baseURL + "/" + ac;
                    }
                    return this.baseURL + ac;
                }
            } else {
                throw new BuildMethodException("Cannot build method. No base URL defined - no action (baseURL or action) starts with 'http'");
            }
        }
        return this.baseURL;
    }

    private String checkURI(String url) throws BuildMethodException {
        String uriCharset = this.client.getHTTPClient().getParams().getUriCharset();
        logger.info("Converting " + url + " with  URI charset " + uriCharset);
        try {
            return new URI(url, true, uriCharset).toString();
        }
        catch (URIException e) {
            logger.warning(String.format("Invalid URL - '%s' does not match URI specification with URI charset %s", url, uriCharset));
            try {
                return new URI(URIUtil.encodePathQuery(url, this.encoding), true, uriCharset).toString();
            }
            catch (URIException e1) {
                throw new BuildMethodException("Invalid URL - does not match URI specification: " + url);
            }
        }
    }

    private Matcher getFormMatcher() {
        if (formPattern == null) {
            formPattern = Pattern.compile("<form(.*?)>(.*?)</form", 42);
        }
        return formPattern.matcher(this.content);
    }

    private Matcher getAHrefMatcher() {
        if (aHrefPattern == null) {
            aHrefPattern = Pattern.compile("<a(?:.*?)href\\s?=\\s?(?:\"|')(.+?)(?:\"|')(?:.*?)>(.*?)</a>", 42);
        }
        return aHrefPattern.matcher(this.content);
    }

    public HttpMethod toPostMethod() throws BuildMethodException {
        if (this.referer != null) {
            this.client.setReferer(this.referer);
        }
        String s = this.generateURL();
        if (this.encodePathAndQuery) {
            try {
                s = URIUtil.encodePathQuery(s, this.encoding);
            }
            catch (URIException e) {
                throw new BuildMethodException("Cannot create URI");
            }
        }
        s = this.checkURI(s);
        PostMethod postMethod = this.client.getPostMethod(s);
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            postMethod.addParameter(entry.getKey(), this.encodeParameters ? this.encode(entry.getValue()) : entry.getValue());
        }
        this.setAdditionalHeaders(postMethod);
        return postMethod;
    }

    public HttpMethod toHttpMethod() throws BuildMethodException {
        if (this.postMethod == HttpMethodEnum.POST) {
            return this.toPostMethod();
        }
        return this.toGetMethod();
    }

    public String getAction() {
        return this.action;
    }

    public MethodBuilder setAction(String action) {
        this.action = action;
        if (action.toLowerCase(Locale.ENGLISH).startsWith("http")) {
            this.postMethod = HttpMethodEnum.GET;
        }
        if (this.isAutoReplaceEntitiesEnabled()) {
            this.replaceEntitiesInAction();
        }
        return this;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public HttpDownloadClient getClient() {
        return this.client;
    }

    public void setClient(HttpDownloadClient client) {
        this.client = client;
    }

    public boolean isEncodeParameters() {
        return this.encodeParameters;
    }

    public MethodBuilder setEncodeParameters(boolean encodeParameters) {
        this.encodeParameters = encodeParameters;
        return this;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public MethodBuilder setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public boolean isAutoReplaceEntitiesEnabled() {
        return this.autoReplaceEntities;
    }

    public MethodBuilder setAutoReplaceEntities(boolean autoReplaceEntities) {
        this.autoReplaceEntities = autoReplaceEntities;
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public MethodBuilder setHeader(String name, String value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.headers.put(name, value);
        return this;
    }

    private void setAdditionalHeaders(HttpMethod method) {
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            if (entry.getValue() != null) {
                method.setRequestHeader(entry.getKey(), entry.getValue());
                continue;
            }
            method.removeRequestHeader(entry.getKey());
        }
    }

    public MethodBuilder setAjax() {
        this.setHeader("X-Requested-With", "XMLHttpRequest");
        return this;
    }

    public String getEscapedURI() throws BuildMethodException {
        try {
            return this.toHttpMethod().getURI().getEscapedURI();
        }
        catch (URIException e) {
            throw new BuildMethodException("Cannot build URI from action");
        }
    }

    public static enum HttpMethodEnum {
        POST,
        GET;

    }
}

