/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing;

import cz.vity.freerapid.utilities.Browser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.hyperlink.LinkModel;
import org.jdesktop.swingx.hyperlink.LinkModelAction;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.HyperlinkProvider;

public final class SwingXUtils {
    private SwingXUtils() {
    }

    public static TableCellRenderer getHyperLinkTableCellRenderer() {
        LinkModelAction action = new LinkModelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkModel linkModel = (LinkModel)e.getSource();
                Browser.openBrowser(linkModel.getURL());
            }
        });
        return new DefaultTableRenderer(new HyperlinkProvider(action, LinkModel.class));
    }

    public static LinkModel createLink(String urlString) {
        try {
            return SwingXUtils.createLink(new URL(urlString));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static LinkModel createLink(URL urlString) {
        final String s = urlString.toExternalForm();
        return new LinkModel(s, null, urlString){

            @Override
            public String toString() {
                return s;
            }
        };
    }
}

