/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing.components;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComboBox;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class PopdownButton
extends JToggleButton {
    private JToggleButton fButton = this;
    private JPopupMenu fPopupMenu = new JPopupMenu();

    public PopdownButton() {
        this.fButton.putClientProperty("JButton.buttonType", "textured");
        this.fButton.addMouseListener(this.createButtonMouseListener());
        this.fPopupMenu.addPopupMenuListener(this.createPopupMenuListener());
        JComboBox box = new JComboBox();
        Object preventHide = box.getClientProperty("doNotCancelPopup");
        this.fButton.putClientProperty("doNotCancelPopup", preventHide);
    }

    private MouseListener createButtonMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (PopdownButton.this.fPopupMenu.isShowing()) {
                    PopdownButton.this.hidePopupMenu();
                } else {
                    PopdownButton.this.showPopupMenu();
                }
            }
        };
    }

    private PopupMenuListener createPopupMenuListener() {
        return new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                PopdownButton.this.fButton.setSelected(false);
            }
        };
    }

    private void hidePopupMenu() {
        this.fPopupMenu.setVisible(false);
    }

    private void showPopupMenu() {
        this.fPopupMenu.show(this.fButton, 5, this.fButton.getHeight());
    }

    public JPopupMenu getPopupMenu() {
        return this.fPopupMenu;
    }
}

