/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities;

import cz.vity.freerapid.utilities.FileUtils;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class OSDesktop {
    private static final Logger logger = Logger.getLogger(OSDesktop.class.getName());

    public static void openFile(File file) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().open(FileUtils.getAbsolutFile(file));
            }
            catch (IOException e) {
                LogUtils.processException(logger, e);
            }
            catch (RuntimeException e) {
                LogUtils.processException(logger, e);
            }
        }
    }

    public static void openDirectoryForFile(File file) {
        File parentFile = file.getParentFile();
        if (Utils.isWindows() && file.exists()) {
            try {
                Runtime.getRuntime().exec("explorer.exe /n,/e,/select,\"" + file.getAbsolutePath() + '\"');
            }
            catch (IOException e) {
                LogUtils.processException(logger, e);
            }
        } else {
            OSDesktop.openFile(parentFile);
        }
    }
}

