/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.async;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Locale;
import jlibs.nbp.Feeder;
import jlibs.nbp.InputStreamChannel;
import jlibs.nbp.NBChannel;
import jlibs.nbp.NBParser;
import jlibs.nbp.NBReaderChannel;
import jlibs.nbp.ReadableCharChannel;
import jlibs.xml.sax.async.AsyncXMLReader;
import jlibs.xml.sax.async.XMLScanner;
import org.apache.xerces.impl.XMLEntityManager;
import org.xml.sax.InputSource;

public class XMLFeeder
extends Feeder {
    AsyncXMLReader xmlReader;
    String publicID;
    String systemID;
    Runnable postAction;
    private int iProlog = 0;
    CharBuffer singleChar = CharBuffer.allocate(1);
    CharBuffer sixChars = CharBuffer.allocate(6);
    XMLScanner prologParser;
    private static final int MAX_PROLOG_LENGTH = 70;
    int elemDepth;

    public XMLFeeder(AsyncXMLReader xmlReader, NBParser parser, InputSource source, XMLScanner declParser) throws IOException {
        super(parser);
        this.xmlReader = xmlReader;
        this.init(source, declParser);
    }

    public static String toURL(String systemID) throws IOException {
        if (systemID == null) {
            return null;
        }
        int ix = systemID.indexOf(58, 0);
        if (ix >= 3 && ix <= 8) {
            return systemID;
        }
        String absPath = new File(systemID).getAbsolutePath();
        char sep = File.separatorChar;
        if (sep != '/') {
            absPath = absPath.replace(sep, '/');
        }
        if (absPath.length() > 0 && absPath.charAt(0) != '/') {
            absPath = "/" + absPath;
        }
        return new URL("file", "", absPath).toString();
    }

    final void init(InputSource is, XMLScanner prologParser) throws IOException {
        this.postAction = null;
        this.iProlog = 0;
        this.prologParser = prologParser;
        this.elemDepth = 0;
        this.publicID = is.getPublicId();
        this.systemID = XMLFeeder.toURL(is.getSystemId());
        Reader charStream = is.getCharacterStream();
        if (charStream != null) {
            this.setChannel((ReadableCharChannel)new NBReaderChannel(charStream));
        } else {
            InputStream inputStream = is.getByteStream();
            String encoding = is.getEncoding();
            if (inputStream == null) {
                assert (this.systemID != null);
                if (this.systemID.startsWith("file:/")) {
                    try {
                        inputStream = new FileInputStream(new File(new URI(this.systemID)));
                    }
                    catch (URISyntaxException ex) {
                        throw new IOException(ex);
                    }
                } else {
                    String contentType;
                    int index;
                    URLConnection con = new URL(this.systemID).openConnection();
                    if (con instanceof HttpURLConnection) {
                        HttpURLConnection httpCon = (HttpURLConnection)con;
                        XMLEntityManager.setInstanceFollowRedirects((HttpURLConnection)httpCon, (boolean)true);
                    }
                    inputStream = con.getInputStream();
                    String charset = null;
                    String rawContentType = con.getContentType();
                    int n = index = rawContentType != null ? rawContentType.indexOf(59) : -1;
                    if (index != -1) {
                        contentType = rawContentType.substring(0, index).trim();
                        charset = rawContentType.substring(index + 1).trim();
                        if (charset.startsWith("charset=") && ((charset = charset.substring(8).trim()).charAt(0) == '\"' && charset.charAt(charset.length() - 1) == '\"' || charset.charAt(0) == '\'' && charset.charAt(charset.length() - 1) == '\'')) {
                            charset = charset.substring(1, charset.length() - 1);
                        }
                    } else {
                        contentType = rawContentType.trim();
                    }
                    String detectedEncoding = null;
                    if (contentType.equals("text/xml")) {
                        detectedEncoding = charset != null ? charset : "US-ASCII";
                    } else if (contentType.equals("application/xml") && charset != null) {
                        detectedEncoding = charset;
                    }
                    if (detectedEncoding != null) {
                        encoding = detectedEncoding;
                    }
                }
            }
            NBChannel channel = new NBChannel((ReadableByteChannel)new InputStreamChannel(inputStream));
            if (encoding == null) {
                channel.setEncoding("UTF-8", true);
            } else {
                channel.setEncoding(encoding, false);
            }
            this.setChannel((ReadableCharChannel)channel);
        }
    }

    protected Feeder read() throws IOException {
        this.xmlReader.setFeeder(this);
        if (this.prologParser != null) {
            int read;
            block0: while (this.iProlog < 6) {
                this.sixChars.clear();
                read = this.channel.read(this.sixChars);
                if (read == 0) {
                    return this;
                }
                if (read == -1) {
                    this.charBuffer.append("<?xml ", 0, this.iProlog);
                    return this.onPrologEOF();
                }
                char[] chars = this.sixChars.array();
                for (int i = 0; i < read; ++i) {
                    char ch = chars[i];
                    if (this.isPrologStart(ch)) {
                        ++this.iProlog;
                        if (this.iProlog != 6) continue;
                        this.charBuffer.append("<?xml ");
                        for (i = 0; i < 70; ++i) {
                            this.singleChar.clear();
                            read = this.channel.read(this.singleChar);
                            if (read != 1) break;
                            ch = this.singleChar.get(0);
                            this.charBuffer.append(ch);
                            if (ch == '>') break;
                        }
                        if (this.charBuffer.position() > 0) {
                            this.charBuffer.flip();
                            this.charBuffer.position(this.prologParser.consume(this.charBuffer.array(), this.charBuffer.position(), this.charBuffer.limit(), false));
                            this.charBuffer.compact();
                        }
                        if (read == 0) {
                            return this;
                        }
                        if (read != -1) continue block0;
                        return this.onPrologEOF();
                    }
                    this.charBuffer.append("<?xml ", 0, this.iProlog);
                    while (i < read) {
                        this.charBuffer.append(chars[i++]);
                    }
                    this.iProlog = 7;
                    this.prologParser = null;
                    continue block0;
                }
            }
            while (this.iProlog != 7) {
                this.singleChar.clear();
                read = this.channel.read(this.singleChar);
                if (read == 0) {
                    return this;
                }
                if (read == -1) {
                    return this.onPrologEOF();
                }
                this.prologParser.consume(this.singleChar.array(), 0, 1, false);
            }
        }
        return super.read();
    }

    private Feeder onPrologEOF() throws IOException {
        this.charBuffer.flip();
        this.channel.close();
        this.channel = null;
        return super.read();
    }

    private boolean isPrologStart(char ch) {
        switch (this.iProlog) {
            case 0: {
                return ch == '<';
            }
            case 1: {
                return ch == '?';
            }
            case 2: {
                return ch == 'x';
            }
            case 3: {
                return ch == 'm';
            }
            case 4: {
                return ch == 'l';
            }
            case 5: {
                return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
            }
        }
        throw new Error("impossible");
    }

    void setDeclaredEncoding(String encoding) {
        String declaredEncoding;
        NBChannel nbChannel;
        String detectedEncoding;
        this.iProlog = 7;
        this.parser.setLocation((NBParser)this.prologParser);
        if (encoding != null && this.channel instanceof NBChannel && !(detectedEncoding = (nbChannel = (NBChannel)this.channel).decoder().charset().name().toUpperCase(Locale.ENGLISH)).equals(declaredEncoding = encoding.toUpperCase(Locale.ENGLISH))) {
            if (detectedEncoding.startsWith("UTF-16") && declaredEncoding.equals("UTF-16")) {
                return;
            }
            if (!detectedEncoding.equals(encoding)) {
                nbChannel.decoder(Charset.forName(encoding).newDecoder());
            }
        }
    }

    public InputSource resolve(String publicID, String systemID) throws IOException {
        InputSource inputSource = new InputSource(this.resolve(systemID));
        inputSource.setPublicId(publicID);
        return inputSource;
    }

    public String resolve(String systemID) throws IOException {
        if (systemID == null) {
            return null;
        }
        if (this.systemID == null) {
            return XMLFeeder.toURL(systemID);
        }
        if (systemID.length() == 0) {
            return systemID;
        }
        int ix = systemID.indexOf(58, 0);
        if (ix >= 3 && ix <= 8) {
            return systemID;
        }
        try {
            return new URI(this.systemID).resolve(new URI(systemID)).toString();
        }
        catch (URISyntaxException ex) {
            return systemID;
        }
    }
}

