/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.xsl;

import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import jlibs.core.lang.StringUtil;

public class TransformerUtil {
    public static final String OUTPUT_KEY_INDENT_AMOUT = "{http://xml.apache.org/xslt}indent-amount";

    public static Transformer setOutputProperties(Transformer transformer, boolean omitXMLDeclaration, int indentAmount, String encoding) {
        transformer.setOutputProperty("omit-xml-declaration", omitXMLDeclaration ? "yes" : "no");
        if (indentAmount >= 0) {
            transformer.setOutputProperty("indent", "yes");
            if (indentAmount > 0) {
                transformer.setOutputProperty(OUTPUT_KEY_INDENT_AMOUT, String.valueOf(indentAmount));
            }
        }
        if (!StringUtil.isWhitespace((CharSequence)encoding)) {
            transformer.setOutputProperty("encoding", encoding.trim());
        }
        return transformer;
    }

    public static Transformer newTransformer(Source source, boolean omitXMLDeclaration, int indentAmount, String encoding) throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = source != null ? factory.newTransformer(source) : factory.newTransformer();
        return TransformerUtil.setOutputProperties(transformer, omitXMLDeclaration, indentAmount, encoding);
    }

    public static TransformerHandler newTransformerHandler(Source source, boolean omitXMLDeclaration, int indentAmount, String encoding) throws TransformerConfigurationException {
        SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();
        TransformerHandler handler = source != null ? factory.newTransformerHandler(source) : factory.newTransformerHandler();
        TransformerUtil.setOutputProperties(handler.getTransformer(), omitXMLDeclaration, indentAmount, encoding);
        return handler;
    }
}

