/*
 * Decompiled with CFR 0.152.
 */
package net.beeger.squareness.delegate;

import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import net.beeger.squareness.util.SquarenessBorderFactory;
import net.beeger.squareness.util.SquarenessButtonPainter;
import net.beeger.squareness.util.SquarenessListenerFactory;

public class SquarenessButtonUI
extends BasicButtonUI {
    private static SquarenessButtonUI _buttonUI = new SquarenessButtonUI();

    public static ComponentUI createUI(JComponent component) {
        return _buttonUI;
    }

    public void installUI(JComponent component) {
        component.putClientProperty("SquarenessRollover", Boolean.FALSE);
        component.addMouseListener(SquarenessListenerFactory.getButtonRolloverMouseListener());
        super.installUI(component);
    }

    public void uninstallUI(JComponent component) {
        component.removeMouseListener(SquarenessListenerFactory.getButtonRolloverMouseListener());
        super.uninstallUI(component);
    }

    public void paint(Graphics graphics, JComponent component) {
        if (!"yes".equals(component.getClientProperty("SquarenessCheckedJEDITROLLOVER"))) {
            component.putClientProperty("SquarenessCheckedJEDITROLLOVER", "yes");
            boolean jEditRolloverButton = false;
            Class<?> currentClass = component.getClass();
            String currentClassName = currentClass.getName();
            while (!(jEditRolloverButton || currentClass == null || currentClassName.startsWith("java.") || currentClassName.startsWith("javax."))) {
                if ("org.gjt.sp.jedit.gui.RolloverButton".equals(currentClass.getName())) {
                    jEditRolloverButton = true;
                    continue;
                }
                currentClass = currentClass.getSuperclass();
            }
            if (jEditRolloverButton) {
                component.setBorder(SquarenessBorderFactory.getButtonRolloverBorder());
            }
        }
        SquarenessButtonPainter.paintButton(graphics, (AbstractButton)component);
        super.paint(graphics, component);
    }
}

