/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsScrollBarButton;
import com.pagosoft.plaf.PgsUtils;
import com.pagosoft.plaf.PlafOptions;
import com.pagosoft.swing.ColorUtils;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;

public class PgsScrollBarUI
extends MetalScrollBarUI {
    private static Color shadowColor;
    private static Color highlightColor;
    private static Color darkShadowColor;
    private static Color thumbColor;
    private static Color thumbShadow;
    private static Color thumbHighlightColor;

    public static ComponentUI createUI(JComponent c) {
        return new PgsScrollBarUI();
    }

    @Override
    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        shadowColor = UIManager.getColor("ScrollBar.shadow");
        highlightColor = UIManager.getColor("ScrollBar.highlight");
        darkShadowColor = UIManager.getColor("ScrollBar.darkShadow");
        thumbColor = UIManager.getColor("ScrollBar.thumb");
        thumbShadow = UIManager.getColor("ScrollBar.thumbShadow");
        thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
        this.trackColor = UIManager.getColor("ScrollBar.track");
        this.trackHighlightColor = UIManager.getColor("ScrollBar.trackHighlight");
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle r) {
        super.paintTrack(g, c, r);
        g.translate(r.x, r.y);
        if (((JScrollBar)c).getOrientation() == 1) {
            Graphics2D gfx = (Graphics2D)g;
            gfx.setPaint(new GradientPaint(0.0f, 0.0f, this.trackColor, r.width, 0.0f, this.trackHighlightColor, true));
            gfx.fillRect(0, 0, r.width, r.height);
            g.setColor(thumbShadow);
            if (PgsUtils.isLeftToRight(c)) {
                g.drawLine(0, 0, 0, r.height - 1);
            } else {
                g.drawLine(r.width - 1, 0, r.width - 1, r.height - 1);
            }
        } else {
            Graphics2D gfx = (Graphics2D)g;
            gfx.setPaint(new GradientPaint(0.0f, 0.0f, this.trackColor, 0.0f, r.height, this.trackHighlightColor, true));
            gfx.fillRect(0, 0, r.width, r.height);
            g.setColor(thumbShadow);
            g.drawLine(0, 0, r.width - 1, 0);
        }
        g.translate(-r.x, -r.y);
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle r) {
        super.paintThumb(g, c, r);
        if (!c.isEnabled()) {
            return;
        }
        g.translate(r.x, r.y);
        if (((JScrollBar)c).getOrientation() == 1) {
            Graphics2D gfx = (Graphics2D)g;
            if (PlafOptions.isOfficeScrollBarEnabled()) {
                gfx.setPaint(new GradientPaint(0.0f, 0.0f, thumbHighlightColor, 0.0f, r.height / 2 + 1, thumbColor, true));
                gfx.fillRect(0, 0, r.width, r.height);
            } else {
                gfx.setPaint(new GradientPaint(0.0f, 0.0f, thumbHighlightColor, r.width / 2 + 1, 0.0f, thumbColor, true));
                gfx.fillRect(0, 0, r.width, r.height);
            }
            g.setColor(thumbShadow);
            if (PgsUtils.isLeftToRight(this.scrollbar)) {
                g.drawLine(0, 0, 0, r.height - 1);
            } else {
                g.drawLine(r.width - 1, 0, r.width - 1, r.height - 1);
            }
            if (this.scrollbar.getValue() != this.scrollbar.getMaximum() - this.scrollbar.getModel().getExtent()) {
                g.drawLine(0, r.height - 1, r.width - 1, r.height - 1);
            }
            if (this.scrollbar.getValue() != 0) {
                g.drawLine(0, 0, r.width, 0);
                g.setColor(thumbHighlightColor);
                g.drawLine(1, 1, r.width - 1, 1);
            } else {
                g.setColor(thumbHighlightColor);
                g.drawLine(1, 0, r.width - 1, 0);
            }
            g.drawLine(1, 1, 1, r.height - 2);
            int x = (int)r.getWidth() / 2;
            int y = (int)r.getHeight() / 2;
            boolean isSmallThumb = r.getHeight() <= 20.0;
            g.setColor(ColorUtils.getTranslucentColor(thumbShadow, 150));
            if (!isSmallThumb) {
                g.drawLine(x - 3, y - 8, x + 3, y - 8);
            }
            g.drawLine(x - 3, y - 4, x + 3, y - 4);
            g.drawLine(x - 3, y, x + 3, y);
            g.drawLine(x - 3, y + 4, x + 3, y + 4);
            if (!isSmallThumb) {
                g.drawLine(x - 3, y + 8, x + 3, y + 8);
            }
            g.setColor(ColorUtils.getTranslucentColor(thumbHighlightColor, 150));
            if (!isSmallThumb) {
                g.drawLine(x - 2, y - 7, x + 4, y - 7);
            }
            g.drawLine(x - 2, y - 3, x + 4, y - 3);
            g.drawLine(x - 2, y + 1, x + 4, y + 1);
            g.drawLine(x - 2, y + 5, x + 4, y + 5);
            if (!isSmallThumb) {
                g.drawLine(x - 2, y + 9, x + 4, y + 9);
            }
        } else {
            Graphics2D gfx = (Graphics2D)g;
            if (PlafOptions.isOfficeScrollBarEnabled()) {
                gfx.setPaint(new GradientPaint(0.0f, 0.0f, thumbHighlightColor, r.width / 2 + 1, 0.0f, thumbColor, true));
                gfx.fillRect(0, 0, r.width, r.height);
            } else {
                gfx.setPaint(new GradientPaint(0.0f, 0.0f, thumbHighlightColor, 0.0f, r.height / 2 + 1, thumbColor, true));
                gfx.fillRect(0, 0, r.width, r.height);
            }
            g.setColor(thumbShadow);
            g.drawLine(0, 0, r.width - 1, 0);
            if (this.scrollbar.getValue() != this.scrollbar.getMaximum() - this.scrollbar.getModel().getExtent()) {
                g.drawLine(r.width - 1, 0, r.width - 1, r.height - 1);
            }
            if (this.scrollbar.getValue() != 0) {
                g.drawLine(0, 0, 0, r.height - 1);
                g.setColor(thumbHighlightColor);
                g.drawLine(1, 1, 1, r.height - 1);
            } else {
                g.setColor(thumbHighlightColor);
                g.drawLine(0, 1, 0, r.height - 1);
            }
            g.drawLine(1, 1, r.width - 2, 1);
            int x = (int)r.getWidth() / 2;
            int y = (int)r.getHeight() / 2;
            boolean isSmallThumb = r.getWidth() <= 20.0;
            g.setColor(ColorUtils.getTranslucentColor(thumbShadow, 200));
            if (!isSmallThumb) {
                g.drawLine(x - 8, y - 3, x - 8, y + 3);
            }
            g.drawLine(x - 4, y - 3, x - 4, y + 3);
            g.drawLine(x, y - 3, x, y + 3);
            g.drawLine(x + 4, y - 3, x + 4, y + 3);
            if (!isSmallThumb) {
                g.drawLine(x + 8, y - 3, x + 8, y + 3);
            }
            g.setColor(ColorUtils.getTranslucentColor(thumbHighlightColor, 200));
            if (!isSmallThumb) {
                g.drawLine(x - 7, y - 2, x - 7, y + 4);
            }
            g.drawLine(x - 3, y - 2, x - 3, y + 4);
            g.drawLine(x + 1, y - 2, x + 1, y + 4);
            g.drawLine(x + 5, y - 2, x + 5, y + 4);
            if (!isSmallThumb) {
                g.drawLine(x + 9, y - 2, x + 9, y + 4);
            }
        }
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        this.decreaseButton = new PgsScrollBarButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        this.increaseButton = new PgsScrollBarButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }
}

