/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.OS;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;
import javax.swing.text.JTextComponent;

public class TextComponentPopupHandler
extends MouseAdapter {
    private static TextComponentPopupHandler INSTANCE;
    private ResourceBundle bundle = ResourceBundle.getBundle("com.pagosoft.plaf.Bundle");
    private Action cutAction = new CutAction();
    private Action copyAction = new CopyAction();
    private Action pasteAction = new PasteAction();
    private Action deleteAction = new DeleteAction();
    private Action selectAllAction = new SelectAllAction();
    private JPopupMenu popupMenu;
    private JTextComponent comp;

    public static TextComponentPopupHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TextComponentPopupHandler();
        }
        return INSTANCE;
    }

    private TextComponentPopupHandler() {
    }

    public ImageIcon getIcon(String name) {
        try {
            return new ImageIcon(TextComponentPopupHandler.class.getResource("/com/pagosoft/plaf/icons/" + name));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!e.isPopupTrigger() && (OS.isMacOsX() || e.getButton() != 3) || MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
            return;
        }
        if (!(e.getComponent() instanceof JTextComponent)) {
            return;
        }
        this.comp = (JTextComponent)e.getComponent();
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.cutAction);
        this.popupMenu.add(this.copyAction);
        this.popupMenu.add(this.pasteAction);
        this.popupMenu.add(this.deleteAction);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.selectAllAction);
        this.popupMenu.show(this.comp, e.getX(), e.getY());
    }

    private class SelectAllAction
    extends AbstractAction {
        public SelectAllAction() {
            super(TextComponentPopupHandler.this.bundle.getString("textcomponent.selectall"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control A"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextComponentPopupHandler.this.comp.selectAll();
        }

        @Override
        public boolean isEnabled() {
            return TextComponentPopupHandler.this.comp.isEnabled() && TextComponentPopupHandler.this.comp.getText().length() > 0;
        }
    }

    private class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super(TextComponentPopupHandler.this.bundle.getString("textcomponent.delete"), TextComponentPopupHandler.this.getIcon("editdelete.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextComponentPopupHandler.this.comp.replaceSelection(null);
        }

        @Override
        public boolean isEnabled() {
            return TextComponentPopupHandler.this.comp.isEditable() && TextComponentPopupHandler.this.comp.isEnabled() && TextComponentPopupHandler.this.comp.getSelectedText() != null;
        }
    }

    private class PasteAction
    extends AbstractAction {
        public PasteAction() {
            super(TextComponentPopupHandler.this.bundle.getString("textcomponent.paste"), TextComponentPopupHandler.this.getIcon("editpaste.png"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control V"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextComponentPopupHandler.this.comp.paste();
        }

        @Override
        public boolean isEnabled() {
            if (TextComponentPopupHandler.this.comp.isEditable() && TextComponentPopupHandler.this.comp.isEnabled()) {
                Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
                return contents.isDataFlavorSupported(DataFlavor.stringFlavor);
            }
            return false;
        }
    }

    private class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super(TextComponentPopupHandler.this.bundle.getString("textcomponent.copy"), TextComponentPopupHandler.this.getIcon("editcopy.png"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control C"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextComponentPopupHandler.this.comp.copy();
        }

        @Override
        public boolean isEnabled() {
            return TextComponentPopupHandler.this.comp.isEnabled() && TextComponentPopupHandler.this.comp.getSelectedText() != null;
        }
    }

    private class CutAction
    extends AbstractAction {
        public CutAction() {
            super(TextComponentPopupHandler.this.bundle.getString("textcomponent.cut"), TextComponentPopupHandler.this.getIcon("editcut.png"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control X"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextComponentPopupHandler.this.comp.cut();
        }

        @Override
        public boolean isEnabled() {
            return TextComponentPopupHandler.this.comp.isEditable() && TextComponentPopupHandler.this.comp.isEnabled() && TextComponentPopupHandler.this.comp.getSelectedText() != null;
        }
    }
}

