/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Language;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.server.AtDXmlSerializer;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.ServerTools;
import org.languagetool.server.V1TextChecker;
import org.languagetool.tools.RuleMatchAsXmlSerializer;

class V1EOLTextChecker
extends V1TextChecker {
    private static final String XML_CONTENT_TYPE = "text/xml; charset=UTF-8";

    V1EOLTextChecker(HTTPServerConfig config, boolean internalServer) {
        super(config, internalServer);
    }

    @Override
    protected void setHeaders(HttpExchange httpExchange) {
        ServerTools.setCommonHeaders(httpExchange, XML_CONTENT_TYPE, this.config.allowOriginUrl);
    }

    @Override
    protected String getResponse(String text, Language lang, Language motherTongue, List<RuleMatch> matches) {
        if (this.config.getMode() == HTTPServerConfig.Mode.AfterTheDeadline) {
            AtDXmlSerializer serializer = new AtDXmlSerializer();
            return serializer.ruleMatchesToXml(matches, text);
        }
        RuleMatch ruleMatch = new RuleMatch(new FakeRule(), 0, 1, "Internal error: The software you're using is making use of an old LanguageTool API. Please ask the software developer to use the recent JSON API. Follow the link below for more information.");
        List<RuleMatch> ruleMatches = text.length() > 0 ? Collections.singletonList(ruleMatch) : Collections.emptyList();
        RuleMatchAsXmlSerializer serializer = new RuleMatchAsXmlSerializer();
        String xml = serializer.ruleMatchesToXml(ruleMatches, text, 40, lang, motherTongue);
        return xml.replaceFirst("\\?>", "?>\n");
    }

    static class FakeRule
    extends Rule {
        FakeRule() {
        }

        @Override
        public String getId() {
            return "API_EOL_PSEUDO_ID";
        }

        @Override
        public URL getUrl() {
            try {
                return new URL("https://languagetool.org/http-api/migration.php");
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String getDescription() {
            return "A pseudo rule indicating the API is end-of-life";
        }

        @Override
        public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
            return new RuleMatch[0];
        }

        @Override
        public void reset() {
        }
    }
}

