/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractApplicationAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;
import org.jhotdraw.util.ResourceBundleUtil;

public class OpenRecentAction
extends AbstractApplicationAction {
    public static final String ID = "file.openRecent";
    private File file;

    public OpenRecentAction(Application app, File file) {
        super(app);
        this.file = file;
        this.putValue("Name", file.getName());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Application app = this.getApplication();
        if (app.isEnabled()) {
            View p;
            app.setEnabled(false);
            View emptyView = app.getActiveView();
            if (emptyView == null || emptyView.getFile() != null || emptyView.hasUnsavedChanges()) {
                emptyView = null;
            }
            if (emptyView == null) {
                p = app.createView();
                app.add(p);
                app.show(p);
            } else {
                p = emptyView;
            }
            this.openFile(p);
        }
    }

    protected void openFile(final View view) {
        Application app = this.getApplication();
        app.setEnabled(true);
        int multipleOpenId = 1;
        for (View aView : app.views()) {
            if (aView == view || aView.getFile() == null || !aView.getFile().equals(this.file)) continue;
            multipleOpenId = Math.max(multipleOpenId, aView.getMultipleOpenId() + 1);
        }
        view.setMultipleOpenId(multipleOpenId);
        view.setEnabled(false);
        view.execute(new Worker(){

            @Override
            public Object construct() {
                try {
                    if (OpenRecentAction.this.file.exists()) {
                        view.read(OpenRecentAction.this.file);
                        return null;
                    }
                    ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
                    return new IOException(labels.getFormatted("file.open.fileDoesNotExist.message", OpenRecentAction.this.file.getName()));
                }
                catch (Throwable e) {
                    return e;
                }
            }

            @Override
            public void finished(Object value) {
                OpenRecentAction.this.fileOpened(view, OpenRecentAction.this.file, value);
            }
        });
    }

    protected void fileOpened(final View view, File file, Object value) {
        if (value == null) {
            view.setFile(file);
            Frame w = (Frame)SwingUtilities.getWindowAncestor(view.getComponent());
            if (w != null) {
                w.setExtendedState(w.getExtendedState() & 0xFFFFFFFE);
                w.toFront();
            }
            view.setEnabled(true);
            view.getComponent().requestFocus();
        } else {
            String message = null;
            if (value instanceof Throwable) {
                ((Throwable)value).printStackTrace();
                message = ((Throwable)value).getMessage();
                if (message == null) {
                    message = value.toString();
                }
            }
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
            JSheet.showMessageSheet(view.getComponent(), "<html>" + UIManager.getString("OptionPane.css") + "<b>" + labels.getFormatted("file.open.couldntOpen.message", file.getName()) + "</b><br>" + (message == null ? "" : message), 0, new SheetListener(){

                @Override
                public void optionSelected(SheetEvent evt) {
                    view.setEnabled(true);
                }
            });
        }
    }
}

