/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.draw.RestoreDataEdit;
import org.jhotdraw.draw.TransformEdit;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.util.ResourceBundleUtil;

public abstract class AbstractRotateHandle
extends AbstractHandle {
    private Point location;
    private Object restoreData;
    private AffineTransform transform;
    private Point2D.Double center;
    private double startTheta;
    private double startLength;

    public AbstractRotateHandle(Figure owner) {
        super(owner);
    }

    @Override
    public boolean isCombinableWith(Handle h) {
        return false;
    }

    @Override
    public String getToolTipText(Point p) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        return labels.getString("handle.rotate.toolTipText");
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.getEditor().getTool().supportsHandleInteraction()) {
            this.drawCircle(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.ROTATE_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.ROTATE_HANDLE_STROKE_COLOR));
        } else {
            this.drawCircle(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.ROTATE_HANDLE_FILL_COLOR_DISABLED), this.getEditor().getHandleAttribute(HandleAttributeKeys.ROTATE_HANDLE_STROKE_COLOR_DISABLED));
        }
    }

    @Override
    protected Rectangle basicGetBounds() {
        Rectangle r = new Rectangle(this.getLocation());
        int h = this.getHandlesize();
        r.x -= h / 2;
        r.y -= h / 2;
        r.width = r.height = h;
        return r;
    }

    public Point getLocation() {
        if (this.location == null) {
            return this.view.drawingToView(this.getOrigin());
        }
        return this.location;
    }

    protected Rectangle2D.Double getTransformedBounds() {
        Figure owner = this.getOwner();
        Rectangle2D.Double bounds = owner.getBounds();
        if (AttributeKeys.TRANSFORM.get(owner) != null) {
            Rectangle2D r = AttributeKeys.TRANSFORM.get(owner).createTransformedShape(bounds).getBounds2D();
            bounds.x = r.getX();
            bounds.y = r.getY();
            bounds.width = r.getWidth();
            bounds.height = r.getHeight();
        }
        return bounds;
    }

    protected Object getRestoreData() {
        return this.restoreData;
    }

    protected double getStartTheta() {
        return this.startTheta;
    }

    protected abstract Point2D.Double getOrigin();

    protected abstract Point2D.Double getCenter();

    @Override
    public void trackStart(Point anchor, int modifiersEx) {
        this.location = new Point(anchor.x, anchor.y);
        this.restoreData = this.getOwner().getTransformRestoreData();
        this.transform = new AffineTransform();
        this.center = this.getCenter();
        Point2D.Double anchorPoint = this.view.viewToDrawing(anchor);
        this.startTheta = Geom.angle(this.center.x, this.center.y, anchorPoint.x, anchorPoint.y);
        this.startLength = Geom.length(this.center.x, this.center.y, anchorPoint.x, anchorPoint.y);
    }

    @Override
    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        this.location = new Point(lead.x, lead.y);
        Point2D.Double leadPoint = this.view.viewToDrawing(lead);
        double stepTheta = Geom.angle(this.center.x, this.center.y, leadPoint.x, leadPoint.y);
        double stepLength = Geom.length(this.center.x, this.center.y, leadPoint.x, leadPoint.y);
        double currentTheta = this.view.getConstrainer().constrainAngle(stepTheta - this.startTheta);
        this.transform.setToIdentity();
        this.transform.translate(this.center.x, this.center.y);
        this.transform.rotate(currentTheta);
        this.transform.translate(-this.center.x, -this.center.y);
        this.getOwner().willChange();
        this.getOwner().restoreTransformTo(this.restoreData);
        this.getOwner().transform(this.transform);
        this.getOwner().changed();
    }

    @Override
    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        this.view.getDrawing().fireUndoableEditHappened(new RestoreDataEdit(this.getOwner(), this.restoreData));
        this.fireAreaInvalidated(this.getDrawingArea());
        this.location = null;
        this.invalidate();
        this.fireAreaInvalidated(this.getDrawingArea());
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        Figure f = this.getOwner();
        this.center = this.getCenter();
        if (f.isTransformable()) {
            AffineTransform tx = new AffineTransform();
            switch (evt.getKeyCode()) {
                case 37: 
                case 38: {
                    tx.rotate(-Math.PI / 180, this.center.x, this.center.y);
                    evt.consume();
                    break;
                }
                case 39: 
                case 40: {
                    tx.rotate(Math.PI / 180, this.center.x, this.center.y);
                    evt.consume();
                }
            }
            f.willChange();
            f.transform(tx);
            f.changed();
            this.fireUndoableEditHappened(new TransformEdit(f, tx));
        }
    }
}

