/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.BezierControlPointHandle;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.BezierNodeEdit;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.undo.CompositeEdit;
import org.jhotdraw.util.ResourceBundleUtil;

public class BezierNodeHandle
extends AbstractHandle {
    protected int index;
    private CompositeEdit edit;
    private BezierPath.Node oldNode;
    private Figure transformOwner;

    public BezierNodeHandle(BezierFigure owner, int index) {
        this(owner, index, owner);
    }

    public BezierNodeHandle(BezierFigure owner, int index, Figure transformOwner) {
        super(owner);
        this.index = index;
        this.transformOwner = transformOwner;
        transformOwner.addFigureListener(this);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.transformOwner.removeFigureListener(this);
        this.transformOwner = null;
    }

    @Override
    public void draw(Graphics2D g) {
        Color strokeColor;
        Color fillColor;
        BezierFigure f = this.getOwner();
        int size = f.getNodeCount();
        boolean isClosed = f.isClosed();
        if (this.getEditor().getTool().supportsHandleInteraction()) {
            fillColor = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_NODE_HANDLE_FILL_COLOR);
            strokeColor = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_NODE_HANDLE_STROKE_COLOR);
        } else {
            fillColor = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_NODE_HANDLE_FILL_COLOR_DISABLED);
            strokeColor = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_NODE_HANDLE_STROKE_COLOR_DISABLED);
        }
        if (size > this.index) {
            BezierPath.Node v = f.getNode(this.index);
            if (v.mask == 0 || this.index == 0 && v.mask == 1 && !isClosed || this.index == size - 1 && v.mask == 2 && !isClosed) {
                this.drawRectangle(g, fillColor, strokeColor);
            } else if (v.mask == 1 || v.mask == 2 || this.index == 0 && !isClosed || this.index == size - 1 && !isClosed) {
                this.drawDiamond(g, fillColor, strokeColor);
            } else {
                this.drawCircle(g, fillColor, strokeColor);
            }
        }
    }

    @Override
    public BezierFigure getOwner() {
        return (BezierFigure)super.getOwner();
    }

    protected Point getLocation() {
        if (this.getOwner().getNodeCount() > this.index) {
            Point2D.Double p = this.getOwner().getPoint(this.index, 0);
            if (SVGAttributeKeys.TRANSFORM.get(this.getTransformOwner()) != null) {
                ((AffineTransform)SVGAttributeKeys.TRANSFORM.get(this.getTransformOwner())).transform(p, p);
            }
            return this.view.drawingToView(p);
        }
        return new Point(10, 10);
    }

    protected BezierPath.Node getBezierNode() {
        return this.getOwner().getNodeCount() > this.index ? this.getOwner().getNode(this.index) : null;
    }

    @Override
    protected Rectangle basicGetBounds() {
        Rectangle r = new Rectangle(this.getLocation());
        int h = this.getHandlesize();
        r.x -= h / 2;
        r.y -= h / 2;
        r.width = r.height = h;
        return r;
    }

    protected Figure getTransformOwner() {
        return this.transformOwner;
    }

    @Override
    public void trackStart(Point anchor, int modifiersEx) {
        BezierFigure figure = this.getOwner();
        this.edit = new CompositeEdit("Punkt verschieben");
        this.view.getDrawing().fireUndoableEditHappened(this.edit);
        Point2D.Double location = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(this.getLocation()));
        Point2D.Double p = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(anchor));
        this.oldNode = figure.getNode(this.index);
        this.fireHandleRequestSecondaryHandles();
    }

    @Override
    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        BezierFigure figure = this.getOwner();
        figure.willChange();
        Point2D.Double p = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(lead));
        if (SVGAttributeKeys.TRANSFORM.get(this.getTransformOwner()) != null) {
            try {
                ((AffineTransform)SVGAttributeKeys.TRANSFORM.get(this.getTransformOwner())).inverseTransform(p, p);
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
        BezierPath.Node n = figure.getNode(this.index);
        n.moveTo(p);
        figure.setNode(this.index, n);
        figure.changed();
    }

    private void fireAreaInvalidated(BezierPath.Node v) {
        Rectangle2D.Double dr = new Rectangle2D.Double(v.x[0], v.y[0], 0.0, 0.0);
        for (int i = 1; i < 3; ++i) {
            dr.add(v.x[i], v.y[i]);
        }
        Rectangle vr = this.view.drawingToView(dr);
        vr.grow(this.getHandlesize(), this.getHandlesize());
        this.fireAreaInvalidated(vr);
    }

    @Override
    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        BezierFigure f = this.getOwner();
        BezierPath.Node oldValue = (BezierPath.Node)this.oldNode.clone();
        BezierPath.Node newValue = f.getNode(this.index);
        if ((modifiersEx & 0x3C0) != 0 && (modifiersEx & 8) == 0) {
            f.willChange();
            newValue.mask = this.index > 0 && this.index < f.getNodeCount() || f.isClosed() ? (newValue.mask + 3) % 4 : (this.index == 0 ? ((newValue.mask & 2) == 0 ? 2 : 0) : ((newValue.mask & 1) == 0 ? 1 : 0));
            f.setNode(this.index, newValue);
            f.changed();
            this.fireHandleRequestSecondaryHandles();
        }
        this.view.getDrawing().fireUndoableEditHappened(new BezierNodeEdit(f, this.index, oldValue, newValue){

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                BezierNodeHandle.this.fireHandleRequestSecondaryHandles();
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                BezierNodeHandle.this.fireHandleRequestSecondaryHandles();
            }
        });
        this.view.getDrawing().fireUndoableEditHappened(this.edit);
    }

    @Override
    public boolean isCombinableWith(Handle h) {
        return false;
    }

    @Override
    public void trackDoubleClick(Point p, int modifiersEx) {
        final BezierFigure f = this.getOwner();
        if (f.getNodeCount() > 2 && (modifiersEx & 0x380) == 0) {
            Rectangle invalidatedArea = this.getDrawingArea();
            f.willChange();
            final BezierPath.Node removedNode = f.removeNode(this.index);
            f.changed();
            this.fireHandleRequestRemove(invalidatedArea);
            this.fireUndoableEditHappened(new AbstractUndoableEdit(){

                @Override
                public String getPresentationName() {
                    ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                    return labels.getString("edit.bezierPath.joinSegments.text");
                }

                @Override
                public void redo() throws CannotRedoException {
                    super.redo();
                    BezierNodeHandle.this.view.removeFromSelection(f);
                    f.willChange();
                    f.removeNode(BezierNodeHandle.this.index);
                    f.changed();
                    BezierNodeHandle.this.view.addToSelection(f);
                }

                @Override
                public void undo() throws CannotUndoException {
                    super.undo();
                    BezierNodeHandle.this.view.removeFromSelection(f);
                    f.willChange();
                    f.addNode(BezierNodeHandle.this.index, removedNode);
                    f.changed();
                    BezierNodeHandle.this.view.addToSelection(f);
                }
            });
        }
    }

    @Override
    public Collection<Handle> createSecondaryHandles() {
        int i;
        BezierFigure f = this.getOwner();
        LinkedList<Handle> list = new LinkedList<Handle>();
        BezierPath.Node v = f.getNode(this.index);
        if ((v.mask & 1) != 0 && (this.index != 0 || f.isClosed())) {
            list.add(new BezierControlPointHandle(f, this.index, 1, this.getTransformOwner()));
        }
        if ((v.mask & 2) != 0 && (this.index < f.getNodeCount() - 1 || f.isClosed())) {
            list.add(new BezierControlPointHandle(f, this.index, 2, this.getTransformOwner()));
        }
        if (this.index > 0 || f.isClosed()) {
            i = this.index == 0 ? f.getNodeCount() - 1 : this.index - 1;
            v = f.getNode(i);
            if ((v.mask & 2) != 0) {
                list.add(new BezierControlPointHandle(f, i, 2, this.getTransformOwner()));
            }
        }
        if (this.index < f.getNodeCount() - 1 || f.isClosed()) {
            i = this.index == f.getNodeCount() - 1 ? 0 : this.index + 1;
            v = f.getNode(i);
            if ((v.mask & 1) != 0) {
                list.add(new BezierControlPointHandle(f, i, 1, this.getTransformOwner()));
            }
        }
        return list;
    }

    @Override
    public String getToolTipText(Point p) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        BezierPath.Node node = this.getBezierNode();
        return node == null ? null : labels.getFormatted("handle.bezierNode.toolTipText", labels.getFormatted(node.getMask() == 0 ? "handle.bezierNode.linear.value" : (node.getMask() == 3 ? "handle.bezierNode.cubic.value" : "handle.bezierNode.quadratic.value"), new Object[0]));
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        final BezierFigure f = this.getOwner();
        this.oldNode = f.getNode(this.index);
        switch (evt.getKeyCode()) {
            case 38: {
                f.willChange();
                f.setPoint(this.index, new Point2D.Double(this.oldNode.x[0], this.oldNode.y[0] - 1.0));
                f.changed();
                this.view.getDrawing().fireUndoableEditHappened(new BezierNodeEdit(f, this.index, this.oldNode, f.getNode(this.index)));
                evt.consume();
                break;
            }
            case 40: {
                f.willChange();
                f.setPoint(this.index, new Point2D.Double(this.oldNode.x[0], this.oldNode.y[0] + 1.0));
                f.changed();
                this.view.getDrawing().fireUndoableEditHappened(new BezierNodeEdit(f, this.index, this.oldNode, f.getNode(this.index)));
                evt.consume();
                break;
            }
            case 37: {
                f.willChange();
                f.setPoint(this.index, new Point2D.Double(this.oldNode.x[0] - 1.0, this.oldNode.y[0]));
                f.changed();
                this.view.getDrawing().fireUndoableEditHappened(new BezierNodeEdit(f, this.index, this.oldNode, f.getNode(this.index)));
                evt.consume();
                break;
            }
            case 39: {
                f.willChange();
                f.setPoint(this.index, new Point2D.Double(this.oldNode.x[0] + 1.0, this.oldNode.y[0]));
                f.changed();
                this.view.getDrawing().fireUndoableEditHappened(new BezierNodeEdit(f, this.index, this.oldNode, f.getNode(this.index)));
                evt.consume();
                break;
            }
            case 8: 
            case 127: {
                Rectangle invalidatedArea = this.getDrawingArea();
                f.willChange();
                final BezierPath.Node removedNode = f.removeNode(this.index);
                f.changed();
                this.fireHandleRequestRemove(invalidatedArea);
                this.fireUndoableEditHappened(new AbstractUndoableEdit(){

                    @Override
                    public String getPresentationName() {
                        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                        return labels.getString("edit.bezierPath.joinSegment.text");
                    }

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        BezierNodeHandle.this.view.removeFromSelection(f);
                        f.willChange();
                        f.removeNode(BezierNodeHandle.this.index);
                        f.changed();
                        BezierNodeHandle.this.view.addToSelection(f);
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        BezierNodeHandle.this.view.removeFromSelection(f);
                        f.willChange();
                        f.addNode(BezierNodeHandle.this.index, removedNode);
                        f.changed();
                        BezierNodeHandle.this.view.addToSelection(f);
                    }
                });
                evt.consume();
            }
        }
    }
}

