/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.MenuElement;
import org.jhotdraw.draw.action.PaletteMenuItemUI;
import org.jhotdraw.draw.action.VerticalGridLayout;

public class JPopupButton
extends JButton {
    private JPopupMenu popupMenu;
    private int columnCount = 1;
    private Action action;
    private Rectangle actionArea;
    private Font itemFont;
    public static final Font ITEM_FONT = new Font("Dialog", 0, 10);
    private int popupAnchor = 6;
    private ActionPropertyHandler actionPropertyHandler = new ActionPropertyHandler();

    public JPopupButton() {
        this.initComponents();
        this.setFocusable(false);
        this.itemFont = ITEM_FONT;
    }

    public void setItemFont(Font newValue) {
        this.itemFont = newValue;
        if (this.popupMenu != null) {
            this.updateFont(this.popupMenu);
        }
    }

    public void setAction(Action action, Rectangle actionArea) {
        if (this.action != null) {
            this.action.removePropertyChangeListener(this.actionPropertyHandler);
        }
        this.action = action;
        this.actionArea = actionArea;
        if (action != null) {
            action.addPropertyChangeListener(this.actionPropertyHandler);
        }
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int count, boolean isVertical) {
        this.columnCount = count;
        this.getPopupMenu().setLayout(new VerticalGridLayout(0, this.getColumnCount(), isVertical));
    }

    public AbstractButton add(Action action) {
        JMenuItem item = this.getPopupMenu().add(action);
        if (this.getColumnCount() > 1) {
            item.setUI(new PaletteMenuItemUI());
        }
        item.setFont(this.itemFont);
        return item;
    }

    public void add(JMenu submenu) {
        JMenuItem item = this.getPopupMenu().add(submenu);
        this.updateFont(submenu);
    }

    public void add(JComponent submenu) {
        this.getPopupMenu().add(submenu);
    }

    private void updateFont(MenuElement menu) {
        menu.getComponent().setFont(this.itemFont);
        for (MenuElement child : menu.getSubElements()) {
            this.updateFont(child);
        }
    }

    public void add(JMenuItem item) {
        this.getPopupMenu().add(item);
        item.setFont(this.itemFont);
    }

    public void addSeparator() {
        this.getPopupMenu().addSeparator();
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }

    public JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.setLayout(new VerticalGridLayout(0, this.getColumnCount()));
        }
        return this.popupMenu;
    }

    public void setPopupAlpha(float newValue) {
        float oldValue = this.getPopupAlpha();
        this.getPopupMenu().putClientProperty("Quaqua.PopupMenu.alpha", Float.valueOf(newValue));
        this.firePropertyChange("popupAlpha", oldValue, newValue);
    }

    public float getPopupAlpha() {
        Float value = (Float)this.getPopupMenu().getClientProperty("Quaqua.PopupMenu.alpha");
        return value == null ? 0.75f : value.floatValue();
    }

    public int getPopupAnchor() {
        return this.popupAnchor;
    }

    public void setPopupAnchor(int newValue) {
        this.popupAnchor = newValue;
    }

    protected void showPopup(MouseEvent evt) {
        if (!(this.popupMenu == null || this.actionArea != null && this.actionArea.contains(evt.getX() - this.getInsets().left, evt.getY() - this.getInsets().top))) {
            int y;
            int x;
            switch (this.popupAnchor) {
                case 4: {
                    x = this.getWidth() - this.popupMenu.getPreferredSize().width;
                    y = this.getHeight();
                    break;
                }
                default: {
                    x = 0;
                    y = this.getHeight();
                }
            }
            if (this.getParent() instanceof JToolBar) {
                JToolBar toolbar = (JToolBar)this.getParent();
                if (toolbar.getOrientation() == 1) {
                    y = 0;
                    x = toolbar.getX() > toolbar.getParent().getInsets().left ? -this.popupMenu.getPreferredSize().width : this.getWidth();
                } else if (toolbar.getY() > toolbar.getParent().getInsets().top) {
                    y = -this.popupMenu.getPreferredSize().height;
                }
            }
            this.popupMenu.show(this, x, y);
            this.popupMenu.repaint();
        }
    }

    private void initComponents() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                JPopupButton.this.handleMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                JPopupButton.this.performAction(evt);
            }
        });
    }

    private void performAction(MouseEvent evt) {
        if (this.actionArea != null && this.actionArea.contains(evt.getX() - this.getInsets().left, evt.getY() - this.getInsets().top)) {
            this.action.actionPerformed(new ActionEvent(this, 1001, null, evt.getWhen(), evt.getModifiers()));
        }
    }

    private void handleMousePressed(MouseEvent evt) {
        this.showPopup(evt);
    }

    private class ActionPropertyHandler
    implements PropertyChangeListener {
        private ActionPropertyHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("enabled")) {
                JPopupButton.this.setEnabled((Boolean)evt.getNewValue());
            } else {
                JPopupButton.this.repaint();
            }
        }
    }
}

