/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.fontchooser;

import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jhotdraw.gui.fontchooser.AbstractFontChooserModel;
import org.jhotdraw.gui.fontchooser.FontCollectionNode;
import org.jhotdraw.gui.fontchooser.FontFaceNode;
import org.jhotdraw.gui.fontchooser.FontFamilyNode;
import org.jhotdraw.util.ResourceBundleUtil;

public class DefaultFontChooserModel
extends AbstractFontChooserModel {
    protected DefaultMutableTreeNode root = new DefaultMutableTreeNode();

    public DefaultFontChooserModel() {
    }

    public DefaultFontChooserModel(Font[] fonts) {
        this.setFonts(fonts);
    }

    public void setFonts(Font[] fonts) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.gui.Labels");
        ArrayList<FontFamilyNode> families = new ArrayList<FontFamilyNode>();
        HashMap<String, FontFamilyNode> familyMap = new HashMap<String, FontFamilyNode>();
        for (Font f : fonts) {
            FontFamilyNode family;
            String familyName = f.getFamily();
            if (familyMap.containsKey(familyName)) {
                family = (FontFamilyNode)familyMap.get(familyName);
            } else {
                family = new FontFamilyNode(familyName);
                familyMap.put(familyName, family);
            }
            family.add(new FontFaceNode(f));
        }
        families.addAll(familyMap.values());
        Collections.sort(families);
        this.root.removeAllChildren();
        this.root.add(new FontCollectionNode(labels.getString("FontCollection.allFonts"), (ArrayList)families.clone()));
        this.root.add(new FontCollectionNode(labels.getString("FontCollection.web"), this.collectFamiliesNamed(families, "Arial", "Arial Black", "Comic Sans MS", "Georgia", "Impact", "Times New Roman", "Trebuchet MS", "Verdana", "Webdings")));
        this.root.add(new FontCollectionNode(labels.getString("FontCollection.system"), this.collectFamiliesNamed(families, "Dialog", "DialogInput", "Monospaced", "SansSerif", "Serif")));
        this.root.add(new FontCollectionNode(labels.getString("FontCollection.serif"), this.collectFamiliesNamed(families, "Adobe Caslon Pro", "Adobe Garamond Pro", "American Typewriter", "Arno Pro", "Baskerville", "Baskerville Old Face", "Bell MT", "Big Caslon", "Bodoni SvtyTwo ITC TT", "Bodoni SvtyTwo OS ITC TT", "Bodoni SvtyTwo SC ITC TT", "Book Antiqua", "Bookman Old Style", "Calisto MT", "Chaparral Pro", "Century", "Century Schoolbook", "Cochin", "Footlight MT Light", "Garamond", "Garamond Premier Pro", "Georgia", "Goudy Old Style", "Hoefler Text", "Lucida Bright", "Lucida Fax", "Minion Pro", "Palatino", "Times", "Times New Roman", "Palatino Linotype", "Bitstream Vera Serif Bold", "Bodoni MT", "Bodoni MT Black", "Bodoni MT Condensed", "Californian FB", "Cambria", "Cambria Math", "Centaur", "Constantia", "High Tower Text", "Perpetua", "Poor Richard", "Rockwell Condensed", "Slimbach-Black", "Slimbach-BlackItalic", "Slimbach-Bold", "Slimbach-BoldItalic", "Slimbach-Book", "Slimbach-BookItalic", "Slimbach-Medium", "Slimbach-MediumItalic", "Sylfaen", "Andalus", "Angsana New", "AngsanaUPC", "Arabic Typesetting", "Cambria", "Cambria Math", "Constantia", "DaunPenh", "David", "DilleniaUPC", "EucrosiaUPC", "Frank Ruehl", "IrisUPC", "Iskoola Pota", "JasmineUPC", "KodchiangUPC", "Narkisim")));
        this.root.add(new FontCollectionNode(labels.getString("FontCollection.sansSerif"), this.collectFamiliesNamed(families, "Abadi MT Condensed Extra Bold", "Abadi MT Condensed Light", "Al Bayan", "AppleGothic", "Arial", "Arial Black", "Arial Narrow", "Arial Rounded MT Bold", "Arial Unicode MS", "Bell Gothic Std", "Blair MdITC TT", "Century Gothic", "Frutiger", "Futura", "Geneva", "Gill Sans", "Gulim", "Helvetica", "Helvetica Neue", "Lucida Grande", "Lucida Sans", "Microsoft Sans Serif", "Myriad Pro", "News Gothic", "Tahoma", "Trebuchet MS", "Verdana", "Franklin Gothic Medium", "Lucida Sans Unicode", "Agency FB", "Berlin Sans FB", "Berlin Sans FB Demi Bold", "Bitstream Vera Sans Bold", "Calibri", "Candara", "Corbel", "Estrangelo Edessa", "Eras Bold ITC", "Eras Demi ITC", "Eras Light ITC", "Eras Medium ITC", "Franklin Gothic Book", "Franklin Gothic Demi", "Franklin Gothic Demi Cond", "Franklin Gothic Heavy", "Franklin Gothic Medium Cond", "Gill Sans MT", "Gill Sans MT Condensed", "Gill Sans MT Ext Condensed Bold", "Maiandra GD", "MS Reference Sans...", "Tw Cen MT", "Tw Cen MT Condensed", "Tw Cen MT Condensed Extra Bold", "Aharoni", "Browallia New", "BrowalliaUPC", "Calibri", "Candara", "Corbel", "Cordia New", "CordiaUPC", "DokChampa", "Dotum", "Estrangelo Edessa", "Euphemia", "Freesia UPC", "Gautami", "Gisha", "Kalinga", "Kartika", "Levenim MT", "LilyUPC", "Malgun Gothic", "Meiryo", "Miriam", "Segoe UI")));
        this.root.add(new FontCollectionNode(labels.getString("FontCollection.script"), this.collectFamiliesNamed(families, "Apple Chancery", "Bickham Script Pro", "Blackmoor LET", "Bradley Hand ITC TT", "Brush Script MT", "Brush Script Std", "Chalkboard", "Charlemagne Std", "Comic Sans MS", "Curlz MT", "Edwardian Script ITC", "Footlight MT Light", "Giddyup Std", "Handwriting - Dakota", "Harrington", "Herculanum", "Kokonor", "Lithos Pro", "Lucida Blackletter", "Lucida Calligraphy", "Lucida Handwriting", "Marker Felt", "Matura MT Script Capitals", "Mistral", "Monotype Corsiva", "Party LET", "Papyrus", "Santa Fe LET", "Savoye LET", "SchoolHouse Cursive B", "SchoolHouse Printed A", "Skia", "Snell Roundhand", "Tekton Pro", "Trajan Pro", "Zapfino", "Blackadder ITC", "Bradley Hand ITC", "Chiller", "Freestyle Script", "French Script MT", "Gigi", "Harlow Solid Italic", "Informal Roman", "Juice ITC", "Kristen ITC", "Kunstler Script", "Magneto Bold", "Maiandra GD", "Old English Text", "Palace Script MT", "Parchment", "Pristina", "Rage Italic", "Ravie", "Script MT Bold", "Tempus Sans ITC", "Viner Hand ITC", "Vivaldi Italic", "Vladimir Script", "Segoe Print", "Segoe Script")));
        this.root.add(new FontCollectionNode(labels.getString("FontCollection.monospaced"), this.collectFamiliesNamed(families, "Andale Mono", "Courier", "Courier New", "Letter Gothic Std", "Lucida Sans Typewriter", "Monaco", "OCR A Std", "Orator Std", "Prestige Elite Std", "Lucida Console", "Bitstream Vera S...", "Consolas", "OCR A Extended", "OCR B", "Consolas", "DotumChe", "Miriam Fixed", "Rod")));
        this.root.add(new FontCollectionNode(labels.getString("FontCollection.decorative"), this.collectFamiliesNamed(families, "Academy Engraved LET", "Arial Black", "Bank Gothic", "Bauhaus 93", "Bernard MT Condensed", "Birch Std", "Blackoak Std", "BlairMdITC TT", "Bordeaux Roman Bold LET", "Braggadocio", "Britannic Bold", "Capitals", "Colonna MT", "Cooper Black", "Cooper Std", "Copperplate", "Copperplate Gothic Bold", "Copperplate Gothic Light", "Cracked", "Desdemona", "Didot", "Eccentric Std", "Engravers MT", "Eurostile", "Gill Sans Ultra Bold", "Gloucester MT Extra Condensed", "Haettenschweiler", "Hobo Std", "Impact", "Imprint MT Shadow", "Jazz LET", "Kino MT", "Matura MT Script Capitals", "Mesquite Std", "Modern No. 20", "Mona Lisa Solid ITC TT", "MS Gothic", "Nueva Std", "Onyx", "Optima", "Perpetua Titling MT", "Playbill", "Poplar Std", "PortagoITC TT", "Princetown LET", "Rockwell", "Rockwell Extra Bold", "Rosewood Std", "Santa Fe LET", "Stencil", "Stencil Std", "Stone Sans ITC TT", "Stone Sans OS ITC TT", "Stone Sans Sem ITC TT", "Stone Sans Sem OS ITCTT", "Stone Sans Sem OS ITC TT", "Synchro LET", "Wide Latin", "Algerian", "Bodoni MT Black", "Bodoni MT Poster Compressed", "Broadway", "Castellar", "Elephant", "Felix Titling", "Franklin Gothic Heavy", "Gill Sans MT Ext Condensed Bold", "Gill Sans Ultra Bold Condensed", "Goudy Stout", "Jokerman", "Juice ITC", "Magneto", "Magneto Bold", "Niagara Engraved", "Niagara Solid", "Poor Richard", "Ravie", "Rockwell Condensed", "Showcard Gothic", "Slimbach-Black", "Slimbach-BlackItalic", "Snap ITC")));
        this.root.add(new FontCollectionNode(labels.getString("FontCollection.symbols"), this.collectFamiliesNamed(families, "Apple Symbols", "Blackoack Std", "Bodoni Ornaments ITC TT", "EuropeanPi", "Monotype Sorts", "MT Extra", "Symbol", "Type Embellishments One LET", "Webdings", "Wingdings", "Wingdings 2", "Wingdings 3", "Zapf Dingbats", "Bookshelf Symbol")));
        FontCollectionNode others = new FontCollectionNode(labels.getString("FontCollection.other"));
        HashSet<FontFamilyNode> otherFamilySet = new HashSet<FontFamilyNode>();
        otherFamilySet.addAll(families);
        int n = this.root.getChildCount();
        for (int i = 1; i < n; ++i) {
            FontCollectionNode fcn = (FontCollectionNode)this.root.getChildAt(i);
            for (FontFamilyNode ffn : fcn.families()) {
                otherFamilySet.remove(ffn);
            }
        }
        ArrayList<FontFamilyNode> otherFamilies = new ArrayList<FontFamilyNode>();
        for (FontFamilyNode ffn : otherFamilySet) {
            otherFamilies.add(ffn.clone());
        }
        Collections.sort(otherFamilies);
        others.addAll(otherFamilies);
        this.root.add(others);
        this.fireTreeStructureChanged(this, new TreePath(this.root));
    }

    protected ArrayList<FontFamilyNode> collectFamiliesNamed(ArrayList<FontFamilyNode> families, String ... names) {
        ArrayList<FontFamilyNode> coll = new ArrayList<FontFamilyNode>();
        HashSet<String> nameMap = new HashSet<String>();
        nameMap.addAll(Arrays.asList(names));
        for (FontFamilyNode family : families) {
            String fName = family.getName();
            if (!nameMap.contains(family.getName())) continue;
            coll.add(family.clone());
        }
        return coll;
    }

    @Override
    public boolean isEditable(MutableTreeNode node) {
        boolean result = true;
        if (node instanceof FontFaceNode) {
            result &= ((FontFaceNode)node).isEditable();
            node = (MutableTreeNode)node.getParent();
        }
        if (result && node instanceof FontFamilyNode) {
            result &= ((FontFamilyNode)node).isEditable();
            node = (MutableTreeNode)node.getParent();
        }
        if (result && node instanceof FontCollectionNode) {
            result &= ((FontFamilyNode)node).isEditable();
        }
        return result;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((TreeNode)parent).getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((TreeNode)parent).getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((TreeNode)node).isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ((TreeNode)parent).getIndex((TreeNode)child);
    }

    public static class UIResource
    extends DefaultFontChooserModel
    implements javax.swing.plaf.UIResource {
    }
}

