/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.fontchooser;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jhotdraw.gui.fontchooser.FontCollectionNode;
import org.jhotdraw.gui.fontchooser.FontFaceNode;

public class FontFamilyNode
implements MutableTreeNode,
Comparable<FontFamilyNode>,
Cloneable {
    private FontCollectionNode parent;
    private String name;
    private ArrayList<FontFaceNode> children = new ArrayList();

    public FontFamilyNode(String name) {
        this.name = name;
    }

    @Override
    public int compareTo(FontFamilyNode that) {
        return Collator.getInstance().compare(this.name, that.name);
    }

    public FontFamilyNode clone() {
        FontFamilyNode that;
        try {
            that = (FontFamilyNode)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            InternalError error = new InternalError("Clone failed");
            error.initCause(ex);
            throw error;
        }
        that.parent = null;
        that.children = new ArrayList();
        for (FontFaceNode f : this.children) {
            that.insert(f.clone(), that.getChildCount());
        }
        return that;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public void add(FontFaceNode newChild) {
        this.insert(newChild, this.getChildCount());
    }

    @Override
    public void insert(MutableTreeNode newChild, int index) {
        FontFamilyNode oldParent = (FontFamilyNode)newChild.getParent();
        if (oldParent != null) {
            oldParent.remove(newChild);
        }
        newChild.setParent(this);
        this.children.add(index, (FontFaceNode)newChild);
    }

    @Override
    public void remove(int childIndex) {
        FontFaceNode child = this.getChildAt(childIndex);
        this.children.remove(childIndex);
        child.setParent(null);
    }

    @Override
    public void remove(MutableTreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(aChild)) {
            throw new IllegalArgumentException("argument is not a child");
        }
        this.remove(this.getIndex(aChild));
    }

    @Override
    public void setUserObject(Object object) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        this.parent = (FontCollectionNode)newParent;
    }

    @Override
    public FontFaceNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }

    public List<FontFaceNode> faces() {
        return Collections.unmodifiableList(this.children);
    }

    public boolean isNodeChild(TreeNode aNode) {
        boolean retval = aNode == null ? false : (this.getChildCount() == 0 ? false : aNode.getParent() == this);
        return retval;
    }

    public boolean isEditable() {
        return true;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof FontFamilyNode) {
            FontFamilyNode that = (FontFamilyNode)o;
            return that.name.equals(this.name);
        }
        return false;
    }
}

