/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jhotdraw.color.CMYKICCColorSystem;
import org.jhotdraw.color.CMYKNominalColorSystem;
import org.jhotdraw.color.ColorSliderModel;
import org.jhotdraw.color.ColorSystem;
import org.jhotdraw.color.DefaultColorSliderModel;
import org.jhotdraw.color.HSLRGBColorSystem;
import org.jhotdraw.color.HSLRYBColorSystem;
import org.jhotdraw.color.HSVRGBColorSystem;
import org.jhotdraw.color.HSVRYBColorSystem;
import org.jhotdraw.color.JColorWheel;
import org.jhotdraw.color.RGBColorSystem;

public class WheelsAndSlidersMain
extends JPanel {
    private Color color;
    private JLabel colorLabel;
    private LinkedList<ColorSliderModel> models;
    private Handler handler;
    private JPanel chooserPanel;
    private JLabel previewLabel;

    public WheelsAndSlidersMain() {
        this.initComponents();
        this.models = new LinkedList();
        this.handler = new Handler();
        this.previewLabel.setOpaque(true);
        this.chooserPanel.add(this.createColorWheelChooser(new HSVRGBColorSystem()));
        this.chooserPanel.add(this.createColorWheelChooser(new HSLRGBColorSystem()));
        this.chooserPanel.add(this.createColorWheelChooser(new HSVRYBColorSystem()));
        this.chooserPanel.add(this.createColorWheelChooser(new HSLRYBColorSystem()));
        this.chooserPanel.add(this.createColorWheelChooser(new HSLRYBColorSystem(), 0, 2, 1));
        this.chooserPanel.add(this.createSliderChooser(new HSVRGBColorSystem()));
        this.chooserPanel.add(this.createSliderChooser(new RGBColorSystem()));
        this.chooserPanel.add(this.createSliderChooser(new CMYKICCColorSystem()));
        this.chooserPanel.add(this.createSliderChooser(new CMYKNominalColorSystem()));
    }

    private JPanel createColorWheelChooser(ColorSystem sys) {
        return this.createColorWheelChooser(sys, 0, 1, 2);
    }

    private JPanel createColorWheelChooser(ColorSystem sys, int angularIndex, int radialIndex, int verticalIndex) {
        JPanel p = new JPanel(new BorderLayout());
        DefaultColorSliderModel m = new DefaultColorSliderModel(sys);
        this.models.add(m);
        m.addChangeListener(this.handler);
        JColorWheel w = new JColorWheel();
        w.setAngularComponentIndex(angularIndex);
        w.setRadialComponentIndex(radialIndex);
        w.setVerticalComponentIndex(verticalIndex);
        w.setModel(m);
        JSlider s = new JSlider(1);
        m.configureSlider(verticalIndex, s);
        p.add((Component)w, "Center");
        p.add((Component)s, "East");
        return p;
    }

    private JPanel createSliderChooser(ColorSystem sys) {
        JPanel p = new JPanel(new GridLayout(0, 1));
        DefaultColorSliderModel m = new DefaultColorSliderModel(sys);
        this.models.add(m);
        m.addChangeListener(this.handler);
        for (int i = 0; i < m.getComponentCount(); ++i) {
            JSlider s = new JSlider(0);
            m.configureSlider(i, s);
            p.add(s);
        }
        return p;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame("Wheel");
                f.add(new WheelsAndSlidersMain());
                f.setDefaultCloseOperation(3);
                f.pack();
                f.setVisible(true);
            }
        });
    }

    private void initComponents() {
        this.chooserPanel = new JPanel();
        this.previewLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.chooserPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.chooserPanel.setLayout(new GridLayout(2, 0, 10, 10));
        this.add((Component)this.chooserPanel, "Center");
        this.previewLabel.setText("Color");
        this.add((Component)this.previewLabel, "South");
    }

    private class Handler
    implements ChangeListener {
        private int adjusting;

        private Handler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.adjusting++ == 0) {
                ColorSliderModel m = (ColorSliderModel)e.getSource();
                WheelsAndSlidersMain.this.color = m.getColor();
                WheelsAndSlidersMain.this.previewLabel.setBackground(WheelsAndSlidersMain.this.color);
                for (ColorSliderModel c : WheelsAndSlidersMain.this.models) {
                    if (c == m) continue;
                    c.setColor(WheelsAndSlidersMain.this.color);
                }
            }
            --this.adjusting;
        }
    }
}

