/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.mini;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jhotdraw.geom.Bezier;
import org.jhotdraw.geom.BezierPath;

public class BezierDemo
extends JPanel {
    private ArrayList<Example> examples = new ArrayList();
    private JDialog dumpDialog;
    private JTextArea dumpArea;
    private MouseHandler handler = new MouseHandler();
    private Canvas canvas;
    private JButton dumpButton;
    private JButton eraseButton;
    private JPanel jPanel1;
    private JCheckBox showBezierCheck;
    private JCheckBox showControlsCheck;
    private JCheckBox showDigitizedCheck;
    private JCheckBox showPolylineCheck;
    private JCheckBox showPreprocessedCheck;
    private JLabel toleranceLabel;
    private JSlider zoomSlider;

    public BezierDemo() {
        this.initComponents();
        this.canvas = new Canvas();
        this.canvas.setOpaque(true);
        this.canvas.setBackground(Color.WHITE);
        this.canvas.addMouseListener(this.handler);
        this.canvas.addMouseMotionListener(this.handler);
        this.add((Component)this.canvas, "Center");
        Point2D.Double[] d = new Point2D.Double[]{};
        BezierPath digi = new BezierPath();
        digi.addAll((Collection<Point2D.Double>)Arrays.asList(d));
        Example ex = new Example();
        this.examples.add(ex);
        ex.digitized = digi;
        ex.error = 2.0;
    }

    public static void main(String[] arg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame("Bezier Demo");
                f.setDefaultCloseOperation(3);
                f.add(new BezierDemo());
                f.setPreferredSize(new Dimension(400, 300));
                f.pack();
                f.setVisible(true);
            }
        });
    }

    private double getSquaredError() {
        double error = this.getError();
        return error * error;
    }

    private double getError() {
        double error = 2.0 / this.getZoomFactor();
        return error;
    }

    private double getZoomFactor() {
        return (double)this.zoomSlider.getValue() / 100.0;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.toleranceLabel = new JLabel();
        this.zoomSlider = new JSlider();
        this.showDigitizedCheck = new JCheckBox();
        this.showPreprocessedCheck = new JCheckBox();
        this.showPolylineCheck = new JCheckBox();
        this.showBezierCheck = new JCheckBox();
        this.showControlsCheck = new JCheckBox();
        this.eraseButton = new JButton();
        this.dumpButton = new JButton();
        this.setLayout(new BorderLayout());
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(12, 20, 20, 20));
        this.jPanel1.setLayout(new GridBagLayout());
        this.toleranceLabel.setText("Zoom:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.toleranceLabel, gridBagConstraints);
        this.zoomSlider.setMaximum(800);
        this.zoomSlider.setMinimum(100);
        this.zoomSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                BezierDemo.this.zoomChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.zoomSlider, gridBagConstraints);
        this.showDigitizedCheck.setText("Show Source Points");
        this.showDigitizedCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BezierDemo.this.checkboxPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.showDigitizedCheck, gridBagConstraints);
        this.showPreprocessedCheck.setText("Show Preprocessed Points");
        this.showPreprocessedCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BezierDemo.this.checkboxPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.showPreprocessedCheck, gridBagConstraints);
        this.showPolylineCheck.setSelected(true);
        this.showPolylineCheck.setText("Show Polyline");
        this.showPolylineCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BezierDemo.this.checkboxPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.jPanel1.add((Component)this.showPolylineCheck, gridBagConstraints);
        this.showBezierCheck.setSelected(true);
        this.showBezierCheck.setText("Show Bezier Path");
        this.showBezierCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BezierDemo.this.checkboxPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.jPanel1.add((Component)this.showBezierCheck, gridBagConstraints);
        this.showControlsCheck.setText("Show Bezier Controls");
        this.showControlsCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BezierDemo.this.checkboxPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.showControlsCheck, gridBagConstraints);
        this.eraseButton.setText("Erase");
        this.eraseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BezierDemo.this.eraseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel1.add((Component)this.eraseButton, gridBagConstraints);
        this.dumpButton.setText("Dump");
        this.dumpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BezierDemo.this.dumpButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel1.add((Component)this.dumpButton, gridBagConstraints);
        this.add((Component)this.jPanel1, "North");
    }

    private void eraseButtonActionPerformed(ActionEvent evt) {
        this.examples.clear();
        this.canvas.repaint();
    }

    private void zoomChanged(ChangeEvent evt) {
        this.canvas.repaint();
    }

    private void dumpButtonActionPerformed(ActionEvent evt) {
        if (this.dumpDialog == null) {
            this.dumpDialog = new JDialog();
            this.dumpDialog.setTitle("Dump");
            this.dumpArea = new JTextArea();
            this.dumpDialog.add(new JScrollPane(this.dumpArea));
            this.dumpDialog.setSize(400, 400);
        }
        StringBuilder buf = new StringBuilder();
        buf.append("        Point2D.Double[] d = { //  Digitized points \n");
        for (int i = 0; i < this.examples.size(); ++i) {
            for (BezierPath.Node node : this.examples.get((int)i).digitized) {
                buf.append("            new Point2D.Double(");
                buf.append(node.x[0]);
                buf.append(",");
                buf.append(node.y[0]);
                buf.append("),\n");
            }
        }
        buf.append("        };\n");
        this.dumpArea.setText(buf.toString());
        this.dumpDialog.setVisible(true);
    }

    private void checkboxPerformed(ActionEvent evt) {
        this.canvas.repaint();
    }

    private class Canvas
    extends JPanel {
        private Canvas() {
        }

        @Override
        public void paintComponent(Graphics gr) {
            long start = System.currentTimeMillis();
            super.paintComponent(gr);
            Graphics2D g = (Graphics2D)gr;
            for (Example ex : BezierDemo.this.examples) {
                if (ex.bezier == null) {
                    ex.bezier = Bezier.fitBezierPath(ex.digitized, ex.error);
                }
                if (ex.segments != null) continue;
                ArrayList<Point2D.Double> digitizedPoints = new ArrayList<Point2D.Double>();
                for (BezierPath.Node node : ex.digitized) {
                    digitizedPoints.add(new Point2D.Double(node.x[0], node.y[0]));
                }
                ex.segments = new ArrayList();
                ex.segments = Bezier.splitAtCorners(digitizedPoints, 1.3439035240356336, BezierDemo.this.getError() * 2.0);
                int n = ex.segments.size();
                for (int i = 0; i < n; ++i) {
                    ArrayList<Point2D.Double> seg = ex.segments.get(i);
                    seg = Bezier.removeClosePoints(seg, BezierDemo.this.getError());
                    seg = Bezier.reduceNoise(seg, 0.8);
                    ex.segments.set(i, seg);
                }
            }
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            AffineTransform identityTransform = g.getTransform();
            AffineTransform tx = g.getTransform();
            double zoomFactor = BezierDemo.this.getZoomFactor();
            tx.scale(zoomFactor, zoomFactor);
            g.setTransform(tx);
            if (BezierDemo.this.showPolylineCheck.isSelected()) {
                g.setColor(Color.black);
                for (Example ex : BezierDemo.this.examples) {
                    g.draw(ex.digitized);
                }
            }
            if (BezierDemo.this.showBezierCheck.isSelected()) {
                g.setColor(Color.blue);
                for (Example ex : BezierDemo.this.examples) {
                    g.draw(ex.bezier);
                }
            }
            g.setTransform(identityTransform);
            if (BezierDemo.this.showDigitizedCheck.isSelected()) {
                for (Example ex : BezierDemo.this.examples) {
                    g.setColor(Color.white);
                    for (BezierPath.Node node : ex.digitized) {
                        g.fillRect((int)(node.x[0] * zoomFactor - 2.0), (int)(node.y[0] * zoomFactor - 2.0), 5, 5);
                    }
                }
                for (Example ex : BezierDemo.this.examples) {
                    g.setColor(Color.black);
                    for (BezierPath.Node node : ex.digitized) {
                        g.fillRect((int)(node.x[0] * zoomFactor - 1.0), (int)(node.y[0] * zoomFactor - 1.0), 3, 3);
                    }
                }
            }
            if (BezierDemo.this.showPreprocessedCheck.isSelected()) {
                for (Example ex : BezierDemo.this.examples) {
                    Point2D.Double node;
                    int i;
                    int n;
                    g.setColor(Color.WHITE);
                    for (ArrayList arrayList : ex.segments) {
                        n = arrayList.size();
                        for (i = 0; i < n; ++i) {
                            node = (Point2D.Double)arrayList.get(i);
                            g.fillRect((int)(node.x * zoomFactor - 2.0), (int)(node.y * zoomFactor - 2.0), 5, 5);
                        }
                    }
                    for (ArrayList arrayList : ex.segments) {
                        n = arrayList.size();
                        for (i = 0; i < n; ++i) {
                            node = (Point2D.Double)arrayList.get(i);
                            g.setColor(i == 0 || i == n - 1 ? Color.RED : Color.CYAN);
                            g.fillRect((int)(node.x * zoomFactor - 1.0), (int)(node.y * zoomFactor - 1.0), 3, 3);
                        }
                    }
                }
            }
            if (BezierDemo.this.showControlsCheck.isSelected()) {
                for (Example ex : BezierDemo.this.examples) {
                    for (BezierPath.Node node : ex.bezier) {
                        if (node.mask == 0) continue;
                        if (node.mask == 3 && node.keepColinear) {
                            g.setColor(Color.WHITE);
                            g.fillRect((int)(node.x[1] * zoomFactor - 2.0), (int)(node.y[1] * zoomFactor - 2.0), 5, 5);
                            g.fillRect((int)(node.x[2] * zoomFactor - 2.0), (int)(node.y[2] * zoomFactor - 2.0), 5, 5);
                            g.setColor(Color.CYAN);
                            g.fillRect((int)(node.x[1] * zoomFactor - 1.0), (int)(node.y[1] * zoomFactor - 1.0), 3, 3);
                            g.draw(new Line2D.Double(node.x[1] * zoomFactor, node.y[1] * zoomFactor, node.x[0] * zoomFactor, node.y[0] * zoomFactor));
                            g.fillRect((int)(node.x[2] * zoomFactor - 1.0), (int)(node.y[2] * zoomFactor - 1.0), 3, 3);
                            g.draw(new Line2D.Double(node.x[2] * zoomFactor, node.y[2] * zoomFactor, node.x[0] * zoomFactor, node.y[0] * zoomFactor));
                            continue;
                        }
                        if ((node.mask & 1) == 1) {
                            g.setColor(Color.WHITE);
                            g.fillRect((int)(node.x[1] * zoomFactor - 2.0), (int)(node.y[1] * zoomFactor - 2.0), 5, 5);
                            g.setColor(Color.MAGENTA);
                            g.fillRect((int)(node.x[1] * zoomFactor - 1.0), (int)(node.y[1] * zoomFactor - 1.0), 3, 3);
                            g.draw(new Line2D.Double(node.x[1] * zoomFactor, node.y[1] * zoomFactor, node.x[0] * zoomFactor, node.y[0] * zoomFactor));
                        }
                        if ((node.mask & 2) != 2) continue;
                        g.setColor(Color.WHITE);
                        g.fillRect((int)(node.x[2] * zoomFactor - 2.0), (int)(node.y[2] * zoomFactor - 2.0), 5, 5);
                        g.setColor(Color.MAGENTA);
                        g.fillRect((int)(node.x[2] * zoomFactor - 1.0), (int)(node.y[2] * zoomFactor - 1.0), 3, 3);
                        g.draw(new Line2D.Double(node.x[2] * zoomFactor, node.y[2] * zoomFactor, node.x[0] * zoomFactor, node.y[0] * zoomFactor));
                    }
                    for (BezierPath.Node node : ex.bezier) {
                        g.setColor(Color.WHITE);
                        g.fillRect((int)(node.x[0] * zoomFactor - 2.0), (int)(node.y[0] * zoomFactor - 2.0), 5, 5);
                    }
                    for (BezierPath.Node node : ex.bezier) {
                        g.setColor(node.keepColinear && node.mask != 0 ? Color.BLUE : Color.RED);
                        g.fillRect((int)(node.x[0] * zoomFactor - 1.0), (int)(node.y[0] * zoomFactor - 1.0), 3, 3);
                    }
                }
            }
            long end = System.currentTimeMillis();
            g.setColor(Color.BLACK);
            g.drawString(end - start + " ms", 5, g.getFontMetrics().getHeight());
        }
    }

    private class MouseHandler
    implements MouseMotionListener,
    MouseListener {
        private Example example;

        private MouseHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            double zoomFactor = BezierDemo.this.getZoomFactor();
            this.example.digitized.lineTo((double)e.getX() / zoomFactor, (double)e.getY() / zoomFactor);
            this.example.invalidate();
            BezierDemo.this.canvas.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.example = new Example();
            BezierDemo.this.examples.add(this.example);
            this.example.error = BezierDemo.this.getError();
            double zoomFactor = BezierDemo.this.getZoomFactor();
            this.example.digitized.moveTo((double)e.getX() / zoomFactor, (double)e.getY() / zoomFactor);
            BezierDemo.this.canvas.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private static class Example {
        double error;
        BezierPath digitized = new BezierPath();
        BezierPath bezier;
        ArrayList<ArrayList<Point2D.Double>> segments;

        private Example() {
        }

        public void invalidate() {
            this.bezier = null;
            this.segments = null;
        }
    }
}

