/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.odg;

import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.DefaultApplicationModel;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractViewAction;
import org.jhotdraw.app.action.CopyAction;
import org.jhotdraw.app.action.CutAction;
import org.jhotdraw.app.action.DuplicateAction;
import org.jhotdraw.app.action.ExportAction;
import org.jhotdraw.app.action.PasteAction;
import org.jhotdraw.app.action.SelectAllAction;
import org.jhotdraw.app.action.ToggleViewPropertyAction;
import org.jhotdraw.app.action.ViewPropertyAction;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.CreationTool;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.action.ApplyAttributesAction;
import org.jhotdraw.draw.action.BringToFrontAction;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.draw.action.GroupAction;
import org.jhotdraw.draw.action.PickAttributesAction;
import org.jhotdraw.draw.action.SelectSameAction;
import org.jhotdraw.draw.action.SendToBackAction;
import org.jhotdraw.draw.action.UngroupAction;
import org.jhotdraw.samples.odg.Gradient;
import org.jhotdraw.samples.odg.ODGAttributeKeys;
import org.jhotdraw.samples.odg.ODGView;
import org.jhotdraw.samples.odg.action.CombineAction;
import org.jhotdraw.samples.odg.action.SplitAction;
import org.jhotdraw.samples.odg.action.TogglePropertiesPanelAction;
import org.jhotdraw.samples.odg.figures.ODGGroupFigure;
import org.jhotdraw.samples.odg.figures.ODGPathFigure;
import org.jhotdraw.samples.odg.figures.ODGRectFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public class ODGApplicationModel
extends DefaultApplicationModel {
    private static final double[] scaleFactors = new double[]{5.0, 4.0, 3.0, 2.0, 1.5, 1.25, 1.0, 0.75, 0.5, 0.25, 0.1};
    private DefaultDrawingEditor sharedEditor;

    public ODGApplicationModel() {
        this.setViewClass(ODGView.class);
    }

    public DefaultDrawingEditor getSharedEditor() {
        if (this.sharedEditor == null) {
            this.sharedEditor = new DefaultDrawingEditor();
        }
        return this.sharedEditor;
    }

    public static Collection<Action> createDrawingActions(DrawingEditor editor) {
        LinkedList<Action> a = new LinkedList<Action>();
        a.add(new CutAction());
        a.add(new CopyAction());
        a.add(new PasteAction());
        a.add(new SelectAllAction());
        a.add(new SelectSameAction(editor));
        return a;
    }

    public static Collection<Action> createSelectionActions(DrawingEditor editor) {
        LinkedList<Action> a = new LinkedList<Action>();
        a.add(new DuplicateAction());
        a.add(null);
        a.add(new GroupAction(editor, new ODGGroupFigure()));
        a.add(new UngroupAction(editor, new ODGGroupFigure()));
        a.add(new CombineAction(editor));
        a.add(new SplitAction(editor));
        a.add(null);
        a.add(new BringToFrontAction(editor));
        a.add(new SendToBackAction(editor));
        return a;
    }

    private void addCreationButtonsTo(JToolBar tb, DrawingEditor editor) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.odg.Labels");
        ResourceBundleUtil drawLabels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        ButtonFactory.addSelectionToolTo(tb, editor, ODGApplicationModel.createDrawingActions(editor), ODGApplicationModel.createSelectionActions(editor));
        tb.addSeparator();
        HashMap<AttributeKey<Object>, Object> attributes = new HashMap<AttributeKey, Object>();
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new ODGRectFigure(), attributes), "edit.createRectangle", drawLabels);
        attributes = new HashMap();
        attributes.put(AttributeKeys.FILL_COLOR, null);
        attributes.put(AttributeKeys.STROKE_COLOR, Color.black);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new ODGPathFigure(), attributes), "edit.createLine", drawLabels);
        attributes = new HashMap();
        attributes.put(AttributeKeys.FILL_COLOR, Color.black);
        attributes.put(AttributeKeys.STROKE_COLOR, null);
        attributes = new HashMap();
        attributes.put(AttributeKeys.FILL_COLOR, null);
        attributes.put(AttributeKeys.STROKE_COLOR, null);
    }

    private void addAttributesButtonsTo(JToolBar bar, DrawingEditor editor) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        JButton b = bar.add(new PickAttributesAction(editor));
        b.setFocusable(false);
        b = bar.add(new ApplyAttributesAction(editor));
        b.setFocusable(false);
        bar.addSeparator();
        this.addColorButtonsTo(bar, editor);
        bar.addSeparator();
        this.addStrokeButtonsTo(bar, editor);
        bar.addSeparator();
        ButtonFactory.addFontButtonsTo(bar, editor);
    }

    private void addColorButtonsTo(JToolBar bar, DrawingEditor editor) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        HashMap<AttributeKey<Object>, Object> defaultAttributes = new HashMap<AttributeKey, Object>();
        ODGAttributeKeys.STROKE_GRADIENT.set(defaultAttributes, (Gradient)null);
        bar.add(ButtonFactory.createEditorColorButton(editor, ODGAttributeKeys.STROKE_COLOR, ButtonFactory.WEBSAVE_COLORS, 19, "attribute.strokeColor", labels, defaultAttributes));
        defaultAttributes = new HashMap();
        ODGAttributeKeys.FILL_GRADIENT.set(defaultAttributes, (Gradient)null);
        bar.add(ButtonFactory.createEditorColorButton(editor, ODGAttributeKeys.FILL_COLOR, ButtonFactory.WEBSAVE_COLORS, 19, "attribute.fillColor", labels, defaultAttributes));
    }

    private void addStrokeButtonsTo(JToolBar bar, DrawingEditor editor) {
        bar.add(ButtonFactory.createStrokeWidthButton(editor));
        bar.add(ButtonFactory.createStrokeDashesButton(editor));
        bar.add(ButtonFactory.createStrokeCapButton(editor));
        bar.add(ButtonFactory.createStrokeJoinButton(editor));
    }

    @Override
    public List<JToolBar> createToolBars(Application a, View pr) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        ODGView p = (ODGView)pr;
        DrawingEditor editor = p == null ? this.getSharedEditor() : p.getEditor();
        LinkedList<JToolBar> list = new LinkedList<JToolBar>();
        JToolBar tb = new JToolBar();
        this.addCreationButtonsTo(tb, editor);
        tb.setName(labels.getString("window.drawToolBar.title"));
        list.add(tb);
        tb = new JToolBar();
        this.addAttributesButtonsTo(tb, editor);
        tb.setName(labels.getString("window.attributesToolBar.title"));
        list.add(tb);
        tb = new JToolBar();
        ButtonFactory.addAlignmentButtonsTo(tb, editor);
        tb.setName(labels.getString("window.alignmentToolBar.title"));
        list.add(tb);
        return list;
    }

    @Override
    public void initView(Application a, View p) {
        if (a.isSharingToolsAmongViews()) {
            ((ODGView)p).setEditor(this.getSharedEditor());
        }
    }

    @Override
    public void initApplication(Application a) {
        ResourceBundleUtil drawLabels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        this.putAction("file.export", new ExportAction(a));
        AbstractViewAction aa = new ToggleViewPropertyAction(a, "gridVisible");
        this.putAction("view.toggleGrid", aa);
        drawLabels.configureAction(aa, "view.toggleGrid");
        for (double sf : scaleFactors) {
            aa = new ViewPropertyAction(a, "scaleFactor", Double.TYPE, new Double(sf));
            this.putAction((int)(sf * 100.0) + "%", aa);
            aa.putValue("Name", (int)(sf * 100.0) + " %");
        }
        this.putAction("togglePropertiesPanel", new TogglePropertiesPanelAction(a));
    }
}

