/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.odg.figures;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.ResizeHandleKit;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.GrowStroke;
import org.jhotdraw.samples.odg.Gradient;
import org.jhotdraw.samples.odg.ODGAttributeKeys;
import org.jhotdraw.samples.odg.figures.ODGAttributedFigure;
import org.jhotdraw.samples.odg.figures.ODGFigure;
import org.jhotdraw.samples.odg.figures.ODGRectRadiusHandle;

public class ODGRectFigure
extends ODGAttributedFigure
implements ODGFigure {
    private RoundRectangle2D.Double roundrect;
    private transient Shape cachedTransformedShape;
    private transient Shape cachedHitShape;

    public ODGRectFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public ODGRectFigure(double x, double y, double width, double height) {
        this(x, y, width, height, 0.0, 0.0);
    }

    public ODGRectFigure(double x, double y, double width, double height, double rx, double ry) {
        this.roundrect = new RoundRectangle2D.Double(x, y, width, height, rx, ry);
        ODGAttributeKeys.setDefaults(this);
    }

    @Override
    protected void drawFill(Graphics2D g) {
        if (this.getArcHeight() == 0.0 && this.getArcWidth() == 0.0) {
            g.fill(this.roundrect.getBounds2D());
        } else {
            g.fill(this.roundrect);
        }
    }

    @Override
    protected void drawStroke(Graphics2D g) {
        if (this.getArcHeight() == 0.0 && this.getArcWidth() == 0.0) {
            g.draw(this.roundrect.getBounds2D());
        } else {
            g.draw(this.roundrect);
        }
    }

    public double getX() {
        return this.roundrect.x;
    }

    public double getY() {
        return this.roundrect.y;
    }

    public double getWidth() {
        return this.roundrect.width;
    }

    public double getHeight() {
        return this.roundrect.height;
    }

    public double getArcWidth() {
        return this.roundrect.arcwidth / 2.0;
    }

    public double getArcHeight() {
        return this.roundrect.archeight / 2.0;
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return (Rectangle2D.Double)this.roundrect.getBounds2D();
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double r;
        Rectangle2D rx = this.getTransformedShape().getBounds2D();
        Rectangle2D.Double double_ = r = rx instanceof Rectangle2D.Double ? (Rectangle2D.Double)rx : new Rectangle2D.Double(rx.getX(), rx.getY(), rx.getWidth(), rx.getHeight());
        if (ODGAttributeKeys.TRANSFORM.get(this) == null) {
            double g = ODGAttributeKeys.getPerpendicularHitGrowth(this) * 2.0;
            Geom.grow(r, g, g);
        } else {
            double strokeTotalWidth = AttributeKeys.getStrokeTotalWidth(this);
            double width = strokeTotalWidth / 2.0;
            if ((Integer)ODGAttributeKeys.STROKE_JOIN.get(this) == 0) {
                width *= ((Double)ODGAttributeKeys.STROKE_MITER_LIMIT.get(this)).doubleValue();
            }
            if ((Integer)ODGAttributeKeys.STROKE_CAP.get(this) != 0) {
                width += strokeTotalWidth * 2.0;
            }
            Geom.grow(r, width += 1.0, width);
        }
        return r;
    }

    @Override
    public boolean contains(Point2D.Double p) {
        return this.getHitShape().contains(p);
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        this.invalidateTransformedShape();
        this.roundrect.x = Math.min(anchor.x, lead.x);
        this.roundrect.y = Math.min(anchor.y, lead.y);
        this.roundrect.width = Math.max(0.1, Math.abs(lead.x - anchor.x));
        this.roundrect.height = Math.max(0.1, Math.abs(lead.y - anchor.y));
    }

    private void invalidateTransformedShape() {
        this.cachedTransformedShape = null;
        this.cachedHitShape = null;
    }

    private Shape getTransformedShape() {
        if (this.cachedTransformedShape == null) {
            this.cachedTransformedShape = this.getArcHeight() == 0.0 || this.getArcWidth() == 0.0 ? this.roundrect.getBounds2D() : (Shape)this.roundrect.clone();
            if (ODGAttributeKeys.TRANSFORM.get(this) != null) {
                this.cachedTransformedShape = ((AffineTransform)ODGAttributeKeys.TRANSFORM.get(this)).createTransformedShape(this.cachedTransformedShape);
            }
        }
        return this.cachedTransformedShape;
    }

    private Shape getHitShape() {
        if (this.cachedHitShape == null) {
            this.cachedHitShape = new GrowStroke((float)ODGAttributeKeys.getStrokeTotalWidth(this) / 2.0f, (float)ODGAttributeKeys.getStrokeTotalMiterLimit(this)).createStrokedShape(this.getTransformedShape());
        }
        return this.cachedHitShape;
    }

    @Override
    public void transform(AffineTransform tx) {
        this.invalidateTransformedShape();
        if (ODGAttributeKeys.TRANSFORM.get(this) != null || (tx.getType() & 1) != tx.getType()) {
            if (ODGAttributeKeys.TRANSFORM.get(this) == null) {
                ODGAttributeKeys.TRANSFORM.basicSet(this, (AffineTransform)tx.clone());
            } else {
                AffineTransform t = (AffineTransform)ODGAttributeKeys.TRANSFORM.getClone(this);
                t.preConcatenate(tx);
                ODGAttributeKeys.TRANSFORM.basicSet(this, t);
            }
        } else {
            Gradient g;
            Point2D.Double anchor = this.getStartPoint();
            Point2D.Double lead = this.getEndPoint();
            this.setBounds((Point2D.Double)tx.transform(anchor, anchor), (Point2D.Double)tx.transform(lead, lead));
            if (ODGAttributeKeys.FILL_GRADIENT.get(this) != null && !ODGAttributeKeys.FILL_GRADIENT.get(this).isRelativeToFigureBounds()) {
                g = ODGAttributeKeys.FILL_GRADIENT.getClone(this);
                g.transform(tx);
                ODGAttributeKeys.FILL_GRADIENT.basicSet(this, g);
            }
            if (ODGAttributeKeys.STROKE_GRADIENT.get(this) != null && !ODGAttributeKeys.STROKE_GRADIENT.get(this).isRelativeToFigureBounds()) {
                g = ODGAttributeKeys.STROKE_GRADIENT.getClone(this);
                g.transform(tx);
                ODGAttributeKeys.STROKE_GRADIENT.basicSet(this, g);
            }
        }
    }

    public void setArc(double w, double h) {
        this.roundrect.arcwidth = Math.max(0.0, Math.min(this.roundrect.width, w * 2.0));
        this.roundrect.archeight = Math.max(0.0, Math.min(this.roundrect.height, h * 2.0));
    }

    public void setArc(Dimension2DDouble arc) {
        this.roundrect.arcwidth = Math.max(0.0, Math.min(this.roundrect.width, arc.width * 2.0));
        this.roundrect.archeight = Math.max(0.0, Math.min(this.roundrect.height, arc.height * 2.0));
    }

    public Dimension2DDouble getArc() {
        return new Dimension2DDouble(this.roundrect.arcwidth / 2.0, this.roundrect.archeight / 2.0);
    }

    @Override
    public void restoreTransformTo(Object geometry) {
        this.invalidateTransformedShape();
        Object[] restoreData = (Object[])geometry;
        this.roundrect = (RoundRectangle2D.Double)((RoundRectangle2D.Double)restoreData[0]).clone();
        ODGAttributeKeys.TRANSFORM.basicSetClone(this, (AffineTransform)restoreData[1]);
        ODGAttributeKeys.FILL_GRADIENT.basicSetClone(this, (Gradient)restoreData[2]);
        ODGAttributeKeys.STROKE_GRADIENT.basicSetClone(this, (Gradient)restoreData[3]);
    }

    @Override
    public Object getTransformRestoreData() {
        return new Object[]{this.roundrect.clone(), ODGAttributeKeys.TRANSFORM.getClone(this), ODGAttributeKeys.FILL_GRADIENT.getClone(this), ODGAttributeKeys.STROKE_GRADIENT.getClone(this)};
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        switch (detailLevel % 2) {
            case 0: {
                ResizeHandleKit.addResizeHandles(this, handles);
                handles.add(new ODGRectRadiusHandle(this));
                break;
            }
            case 1: {
                TransformHandleKit.addTransformHandles(this, handles);
                break;
            }
        }
        return handles;
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public Connector findConnector(Point2D.Double p, ConnectionFigure prototype) {
        return null;
    }

    @Override
    public Connector findCompatibleConnector(Connector c, boolean isStartConnector) {
        return null;
    }

    @Override
    public ODGRectFigure clone() {
        ODGRectFigure that = (ODGRectFigure)super.clone();
        that.roundrect = (RoundRectangle2D.Double)this.roundrect.clone();
        that.cachedTransformedShape = null;
        that.cachedHitShape = null;
        return that;
    }

    @Override
    public boolean isEmpty() {
        Rectangle2D.Double b = this.getBounds();
        return b.width <= 0.0 || b.height <= 0.0;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.invalidateTransformedShape();
    }
}

