/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.GroupFigure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.LinkHandle;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class SVGGroupFigure
extends GroupFigure
implements SVGFigure {
    private HashMap<AttributeKey, Object> attributes = new HashMap();

    public SVGGroupFigure() {
        SVGAttributeKeys.setDefaults(this);
    }

    @Override
    public <T> void setAttribute(AttributeKey<T> key, T value) {
        if (key == SVGAttributeKeys.OPACITY) {
            this.attributes.put(key, value);
        } else if (key == SVGAttributeKeys.LINK || key == SVGAttributeKeys.LINK_TARGET) {
            this.attributes.put(key, value);
        } else {
            super.setAttribute(key, value);
        }
        this.invalidate();
    }

    @Override
    public <T> T getAttribute(AttributeKey<T> key) {
        return key.get(this.attributes);
    }

    @Override
    public Map<AttributeKey, Object> getAttributes() {
        return new HashMap<AttributeKey, Object>(this.attributes);
    }

    public void setAttributes(Map<AttributeKey, Object> map) {
        for (Map.Entry<AttributeKey, Object> entry : map.entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void draw(Graphics2D g) {
        double opacity = SVGAttributeKeys.OPACITY.get(this);
        if ((opacity = Math.min(Math.max(0.0, opacity), 1.0)) != 0.0) {
            if (opacity != 1.0) {
                Rectangle2D.Double drawingArea = this.getDrawingArea();
                Rectangle clipBounds = g.getClipBounds();
                if (clipBounds != null) {
                    Rectangle2D.intersect(drawingArea, clipBounds, drawingArea);
                }
                if (!drawingArea.isEmpty()) {
                    BufferedImage buf = new BufferedImage(Math.max(1, (int)((2.0 + drawingArea.width) * g.getTransform().getScaleX())), Math.max(1, (int)((2.0 + drawingArea.height) * g.getTransform().getScaleY())), 2);
                    Graphics2D gr = buf.createGraphics();
                    gr.scale(g.getTransform().getScaleX(), g.getTransform().getScaleY());
                    gr.translate((int)(-drawingArea.x), (int)(-drawingArea.y));
                    gr.setRenderingHints(g.getRenderingHints());
                    super.draw(gr);
                    gr.dispose();
                    Composite savedComposite = g.getComposite();
                    g.setComposite(AlphaComposite.getInstance(3, (float)opacity));
                    g.drawImage(buf, (int)drawingArea.x, (int)drawingArea.y, 2 + (int)drawingArea.width, 2 + (int)drawingArea.height, null);
                    g.setComposite(savedComposite);
                }
            } else {
                super.draw(g);
            }
        }
    }

    @Override
    public Rectangle2D.Double getBounds() {
        if (this.cachedBounds == null) {
            if (this.getChildCount() == 0) {
                this.cachedBounds = new Rectangle2D.Double();
            } else {
                for (Figure f : this.children) {
                    Rectangle2D.Double bounds = f.getBounds();
                    if (SVGAttributeKeys.TRANSFORM.get(f) != null) {
                        bounds.setRect(((AffineTransform)SVGAttributeKeys.TRANSFORM.get(f)).createTransformedShape(bounds).getBounds2D());
                    }
                    if (this.cachedBounds == null || this.cachedBounds.isEmpty()) {
                        this.cachedBounds = bounds;
                        continue;
                    }
                    this.cachedBounds.add(bounds);
                }
            }
        }
        return (Rectangle2D.Double)this.cachedBounds.clone();
    }

    public LinkedList<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        switch (detailLevel) {
            case -1: {
                TransformHandleKit.addGroupHoverHandles(this, handles);
                break;
            }
            case 0: {
                TransformHandleKit.addGroupTransformHandles(this, handles);
                handles.add(new LinkHandle(this));
            }
        }
        return handles;
    }

    @Override
    public final void write(DOMOutput out) throws IOException {
        throw new UnsupportedOperationException("Use SVGStorableOutput to write this Figure.");
    }

    @Override
    public final void read(DOMInput in) throws IOException {
        throw new UnsupportedOperationException("Use SVGStorableInput to read this Figure.");
    }

    @Override
    public boolean isEmpty() {
        return this.getChildCount() == 0;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
        buf.append('@');
        buf.append(this.hashCode());
        if (this.getChildCount() > 0) {
            buf.append('(');
            Iterator<Figure> i = this.getChildren().iterator();
            while (i.hasNext()) {
                Figure child = i.next();
                buf.append(child);
                if (!i.hasNext()) continue;
                buf.append(',');
            }
            buf.append(')');
        }
        return buf.toString();
    }

    @Override
    public SVGGroupFigure clone() {
        SVGGroupFigure that = (SVGGroupFigure)super.clone();
        that.attributes = new HashMap<AttributeKey, Object>(this.attributes);
        return that;
    }
}

