/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.SliderUI;
import javax.swing.plaf.TextUI;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.gui.DrawingAttributeEditorHandler;
import org.jhotdraw.gui.JAttributeSlider;
import org.jhotdraw.gui.JAttributeTextField;
import org.jhotdraw.gui.JPopupButton;
import org.jhotdraw.gui.plaf.palette.PaletteButtonUI;
import org.jhotdraw.gui.plaf.palette.PaletteFormattedTextFieldUI;
import org.jhotdraw.gui.plaf.palette.PaletteLabelUI;
import org.jhotdraw.gui.plaf.palette.PaletteSliderUI;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.gui.AbstractToolBar;
import org.jhotdraw.samples.svg.gui.DrawingComponentRepainter;
import org.jhotdraw.samples.svg.gui.DrawingOpacityIcon;
import org.jhotdraw.text.ColorFormatter;
import org.jhotdraw.text.JavaNumberFormatter;
import org.jhotdraw.util.ResourceBundleUtil;

public class CanvasToolBar
extends AbstractToolBar {
    public CanvasToolBar() {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        this.setName(labels.getString(this.getID() + ".toolbar"));
        this.setDisclosureStateCount(3);
    }

    @Override
    protected JComponent createDisclosedComponent(int state) {
        JPanel p = null;
        switch (state) {
            case 1: {
                p = new JPanel();
                p.setOpaque(false);
                p.removeAll();
                p.setBorder(new EmptyBorder(5, 5, 5, 8));
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout layout = new GridBagLayout();
                p.setLayout(layout);
                JPopupButton btn = ButtonFactory.createDrawingColorButton(this.editor, SVGAttributeKeys.CANVAS_FILL_COLOR, ButtonFactory.HSV_COLORS, 12, "attribute.canvasFillColor", labels, null, new Rectangle(3, 3, 10, 10));
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                new DrawingComponentRepainter(this.editor, btn);
                btn.setAction(null, null);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridy = 0;
                gbc.gridwidth = 2;
                gbc.anchor = 23;
                p.add((Component)btn, gbc);
                JPopupButton opacityPopupButton = new JPopupButton();
                JAttributeSlider opacitySlider = new JAttributeSlider(1, 0, 100, 100);
                opacitySlider.setUI((SliderUI)PaletteSliderUI.createUI(opacitySlider));
                opacitySlider.setScaleFactor(100.0);
                new DrawingAttributeEditorHandler<Double>(SVGAttributeKeys.CANVAS_FILL_OPACITY, opacitySlider, this.editor);
                opacityPopupButton.add(opacitySlider);
                labels.configureToolBarButton(opacityPopupButton, "attribute.canvasFillOpacity");
                opacityPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(opacityPopupButton));
                opacityPopupButton.setIcon(new DrawingOpacityIcon(this.editor, (AttributeKey<Double>)SVGAttributeKeys.CANVAS_FILL_OPACITY, (AttributeKey<Color>)SVGAttributeKeys.CANVAS_FILL_COLOR, null, this.getClass().getResource(labels.getString("attribute.canvasFillOpacity.icon")), (Shape)new Rectangle(5, 5, 6, 6), (Shape)new Rectangle(4, 4, 7, 7)));
                new DrawingComponentRepainter(this.editor, opacityPopupButton);
                gbc = new GridBagConstraints();
                gbc.gridx = 2;
                gbc.gridy = 0;
                gbc.anchor = 23;
                gbc.insets = new Insets(0, 3, 0, 0);
                p.add((Component)opacityPopupButton, gbc);
                JLabel widthLabel = new JLabel();
                JLabel heightLabel = new JLabel();
                JAttributeTextField widthField = new JAttributeTextField();
                JAttributeTextField heightField = new JAttributeTextField();
                widthLabel.setUI((LabelUI)PaletteLabelUI.createUI(widthLabel));
                widthLabel.setLabelFor(widthField);
                widthLabel.setToolTipText(labels.getString("attribute.canvasWidth.toolTipText"));
                widthLabel.setText(labels.getString("attribute.canvasWidth.text"));
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.anchor = 23;
                gbc.fill = 1;
                gbc.insets = new Insets(3, 0, 0, 0);
                p.add((Component)widthLabel, gbc);
                widthField.setUI((TextUI)PaletteFormattedTextFieldUI.createUI(widthField));
                widthField.setColumns(3);
                widthField.setToolTipText(labels.getString("attribute.canvasWidth.toolTipText"));
                widthField.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(1.0, 4096.0, 1.0, true, false));
                widthField.setHorizontalAlignment(10);
                new DrawingAttributeEditorHandler(SVGAttributeKeys.CANVAS_WIDTH, widthField, this.editor);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 1;
                gbc.gridwidth = 2;
                gbc.anchor = 23;
                gbc.fill = 1;
                gbc.insets = new Insets(3, 3, 0, 0);
                p.add(widthField, gbc);
                heightLabel.setUI((LabelUI)PaletteLabelUI.createUI(heightLabel));
                heightLabel.setLabelFor(widthField);
                heightLabel.setToolTipText(labels.getString("attribute.canvasHeight.toolTipText"));
                heightLabel.setText(labels.getString("attribute.canvasHeight.text"));
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 2;
                gbc.anchor = 23;
                gbc.fill = 1;
                gbc.insets = new Insets(3, 0, 0, 0);
                p.add((Component)heightLabel, gbc);
                heightField.setUI((TextUI)PaletteFormattedTextFieldUI.createUI(widthField));
                heightField.setColumns(3);
                heightField.setToolTipText(labels.getString("attribute.canvasHeight.toolTipText"));
                heightField.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(1.0, 4096.0, 1.0, true, false));
                heightField.setHorizontalAlignment(10);
                new DrawingAttributeEditorHandler(SVGAttributeKeys.CANVAS_HEIGHT, heightField, this.editor);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 2;
                gbc.anchor = 23;
                gbc.fill = 1;
                gbc.insets = new Insets(3, 3, 0, 0);
                gbc.gridwidth = 2;
                p.add(heightField, gbc);
                break;
            }
            case 2: {
                p = new JPanel();
                p.setOpaque(false);
                JPanel p1 = new JPanel(new GridBagLayout());
                JPanel p2 = new JPanel(new GridBagLayout());
                JPanel p3 = new JPanel(new GridBagLayout());
                p1.setOpaque(false);
                p2.setOpaque(false);
                p3.setOpaque(false);
                p.removeAll();
                p.setBorder(new EmptyBorder(5, 5, 5, 8));
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout layout = new GridBagLayout();
                p.setLayout(layout);
                JAttributeTextField colorField = new JAttributeTextField();
                colorField.setColumns(7);
                colorField.setToolTipText(labels.getString("attribute.canvasFillColor.toolTipText"));
                colorField.putClientProperty("Palette.Component.segmentPosition", "first");
                colorField.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(colorField));
                colorField.setFormatterFactory(ColorFormatter.createFormatterFactory());
                colorField.setHorizontalAlignment(2);
                new DrawingAttributeEditorHandler(SVGAttributeKeys.CANVAS_FILL_COLOR, colorField, this.editor);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridwidth = 2;
                gbc.fill = 2;
                gbc.anchor = 23;
                p1.add(colorField, gbc);
                JPopupButton btn = ButtonFactory.createDrawingColorButton(this.editor, SVGAttributeKeys.CANVAS_FILL_COLOR, ButtonFactory.HSV_COLORS, 12, "attribute.canvasFillColor", labels, null, new Rectangle(3, 3, 10, 10));
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                new DrawingComponentRepainter(this.editor, btn);
                btn.setAction(null, null);
                gbc = new GridBagConstraints();
                gbc.anchor = 23;
                p1.add((Component)btn, gbc);
                JAttributeTextField opacityField = new JAttributeTextField();
                opacityField.setColumns(3);
                opacityField.setToolTipText(labels.getString("attribute.figureOpacity.toolTipText"));
                opacityField.setHorizontalAlignment(4);
                opacityField.putClientProperty("Palette.Component.segmentPosition", "first");
                opacityField.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(opacityField));
                opacityField.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(0.0, 100.0, 100.0, true, false));
                opacityField.setHorizontalAlignment(10);
                new DrawingAttributeEditorHandler(SVGAttributeKeys.CANVAS_FILL_OPACITY, opacityField, this.editor);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.insets = new Insets(3, 0, 0, 0);
                gbc.anchor = 23;
                p1.add(opacityField, gbc);
                JPopupButton opacityPopupButton = new JPopupButton();
                JAttributeSlider opacitySlider = new JAttributeSlider(1, 0, 100, 100);
                opacitySlider.setUI((SliderUI)PaletteSliderUI.createUI(opacitySlider));
                opacitySlider.setScaleFactor(100.0);
                new DrawingAttributeEditorHandler<Double>(SVGAttributeKeys.CANVAS_FILL_OPACITY, opacitySlider, this.editor);
                opacityPopupButton.add(opacitySlider);
                labels.configureToolBarButton(opacityPopupButton, "attribute.canvasFillOpacity");
                opacityPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(opacityPopupButton));
                opacityPopupButton.setIcon(new DrawingOpacityIcon(this.editor, (AttributeKey<Double>)SVGAttributeKeys.CANVAS_FILL_OPACITY, (AttributeKey<Color>)SVGAttributeKeys.CANVAS_FILL_COLOR, null, this.getClass().getResource(labels.getString("attribute.canvasFillOpacity.icon")), (Shape)new Rectangle(5, 5, 6, 6), (Shape)new Rectangle(4, 4, 7, 7)));
                new DrawingComponentRepainter(this.editor, opacityPopupButton);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 1;
                gbc.anchor = 23;
                gbc.insets = new Insets(3, 0, 0, 0);
                p1.add((Component)opacityPopupButton, gbc);
                JLabel widthLabel = new JLabel();
                JLabel heightLabel = new JLabel();
                JAttributeTextField widthField = new JAttributeTextField();
                JAttributeTextField heightField = new JAttributeTextField();
                widthLabel.setUI((LabelUI)PaletteLabelUI.createUI(widthLabel));
                widthLabel.setLabelFor(widthField);
                widthLabel.setToolTipText(labels.getString("attribute.canvasWidth.toolTipText"));
                widthLabel.setText(labels.getString("attribute.canvasWidth.text"));
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 2;
                gbc.anchor = 23;
                gbc.fill = 1;
                gbc.insets = new Insets(3, 0, 0, 0);
                p3.add((Component)widthLabel, gbc);
                widthField.setUI((TextUI)PaletteFormattedTextFieldUI.createUI(widthField));
                widthField.setColumns(3);
                widthField.setToolTipText(labels.getString("attribute.canvasWidth.toolTipText"));
                widthField.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(1.0, 4096.0, 1.0, true, false));
                widthField.setHorizontalAlignment(10);
                new DrawingAttributeEditorHandler(SVGAttributeKeys.CANVAS_WIDTH, widthField, this.editor);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 2;
                gbc.gridwidth = 2;
                gbc.anchor = 23;
                gbc.fill = 1;
                gbc.insets = new Insets(3, 3, 0, 0);
                p3.add(widthField, gbc);
                heightLabel.setUI((LabelUI)PaletteLabelUI.createUI(heightLabel));
                heightLabel.setLabelFor(widthField);
                heightLabel.setToolTipText(labels.getString("attribute.canvasHeight.toolTipText"));
                heightLabel.setText(labels.getString("attribute.canvasHeight.text"));
                gbc = new GridBagConstraints();
                gbc.gridx = 3;
                gbc.gridy = 2;
                gbc.anchor = 23;
                gbc.fill = 1;
                gbc.insets = new Insets(3, 3, 0, 0);
                p3.add((Component)heightLabel, gbc);
                heightField.setUI((TextUI)PaletteFormattedTextFieldUI.createUI(widthField));
                heightField.setColumns(3);
                heightField.setToolTipText(labels.getString("attribute.canvasHeight.toolTipText"));
                heightField.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(1.0, 4096.0, 1.0, true, false));
                heightField.setHorizontalAlignment(10);
                new DrawingAttributeEditorHandler(SVGAttributeKeys.CANVAS_HEIGHT, heightField, this.editor);
                gbc = new GridBagConstraints();
                gbc.gridx = 4;
                gbc.gridy = 2;
                gbc.gridwidth = 2;
                gbc.anchor = 23;
                gbc.fill = 1;
                gbc.insets = new Insets(3, 3, 0, 0);
                p3.add(heightField, gbc);
                gbc = new GridBagConstraints();
                gbc.gridy = 0;
                gbc.anchor = 23;
                p.add((Component)p1, gbc);
                gbc = new GridBagConstraints();
                gbc.gridy = 1;
                gbc.anchor = 23;
                p.add((Component)p2, gbc);
                gbc = new GridBagConstraints();
                gbc.gridy = 2;
                gbc.anchor = 23;
                p.add((Component)p3, gbc);
            }
        }
        return p;
    }

    @Override
    protected String getID() {
        return "canvas";
    }

    private void initComponents() {
        this.setOpaque(false);
    }
}

