/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.GridConstrainer;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.gui.JLifeFormattedTextField;
import org.jhotdraw.gui.plaf.palette.PaletteButtonUI;
import org.jhotdraw.gui.plaf.palette.PaletteFormattedTextFieldUI;
import org.jhotdraw.samples.svg.gui.AbstractToolBar;
import org.jhotdraw.text.JavaNumberFormatter;
import org.jhotdraw.util.ResourceBundleUtil;

public class ViewToolBar
extends AbstractToolBar {
    private DrawingView view;

    public ViewToolBar() {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        this.setName(labels.getString(this.getID() + ".toolbar"));
        this.setDisclosureStateCount(3);
    }

    public void setView(DrawingView view) {
        this.view = view;
        this.prefs = Preferences.userNodeForPackage(this.getClass());
        GridConstrainer constrainer = (GridConstrainer)view.getVisibleConstrainer();
        constrainer.setHeight(this.prefs.getDouble("view.gridSize", 8.0));
        constrainer.setWidth(this.prefs.getDouble("view.gridSize", 8.0));
    }

    @Override
    protected JComponent createDisclosedComponent(int state) {
        JPanel p = null;
        switch (state) {
            case 1: {
                AbstractButton btn;
                p = new JPanel();
                p.setOpaque(false);
                p.removeAll();
                p.setBorder(new EmptyBorder(5, 5, 5, 8));
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout layout = new GridBagLayout();
                p.setLayout(layout);
                AbstractButton toggleGridButton = btn = ButtonFactory.createToggleGridButton(this.view);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                labels.configureToolBarButton(btn, "alignGrid");
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 0;
                gbc.anchor = 23;
                gbc.fill = 0;
                gbc.insets = new Insets(0, 0, 0, 0);
                p.add((Component)btn, gbc);
                btn = ButtonFactory.createZoomButton(this.view);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                labels.configureToolBarButton(btn, "view.zoomFactor");
                btn.setText("100 %");
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 1;
                gbc.gridwidth = 0;
                gbc.fill = 2;
                gbc.anchor = 23;
                gbc.insets = new Insets(3, 0, 0, 0);
                gbc.weighty = 1.0;
                gbc.weightx = 1.0;
                btn.setPreferredSize(new Dimension(btn.getPreferredSize().width, toggleGridButton.getPreferredSize().height));
                p.add((Component)btn, gbc);
                break;
            }
            case 2: {
                p = new JPanel();
                p.setOpaque(false);
                p.removeAll();
                p.setBorder(new EmptyBorder(5, 5, 5, 8));
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout layout = new GridBagLayout();
                p.setLayout(layout);
                JLifeFormattedTextField gridSizeField = new JLifeFormattedTextField();
                gridSizeField.setColumns(3);
                gridSizeField.setToolTipText(labels.getString("view.gridSize.toolTipText"));
                gridSizeField.setHorizontalAlignment(4);
                gridSizeField.putClientProperty("Palette.Component.segmentPosition", "first");
                gridSizeField.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(gridSizeField));
                gridSizeField.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(0.0, 1000.0, 1.0, true, false));
                gridSizeField.setHorizontalAlignment(10);
                final GridConstrainer constrainer = (GridConstrainer)this.view.getVisibleConstrainer();
                gridSizeField.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getPropertyName().equals("value") && evt.getNewValue() != null) {
                            constrainer.setWidth((Double)evt.getNewValue());
                            constrainer.setHeight((Double)evt.getNewValue());
                            ViewToolBar.this.prefs = Preferences.userNodeForPackage(this.getClass());
                            ViewToolBar.this.prefs.putDouble("view.gridSize", (Double)evt.getNewValue());
                            ViewToolBar.this.view.getComponent().repaint();
                        }
                    }
                });
                gridSizeField.setValue(constrainer.getHeight());
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.insets = new Insets(0, 0, 0, 0);
                gbc.anchor = 23;
                p.add((Component)gridSizeField, gbc);
                AbstractButton btn = ButtonFactory.createToggleGridButton(this.view);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                labels.configureToolBarButton(btn, "alignGrid");
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 0;
                gbc.anchor = 23;
                gbc.fill = 0;
                gbc.insets = new Insets(0, 0, 0, 0);
                p.add((Component)btn, gbc);
                final JLifeFormattedTextField scaleFactorField = new JLifeFormattedTextField();
                scaleFactorField.setColumns(3);
                scaleFactorField.setToolTipText(labels.getString("view.zoomFactor.toolTipText"));
                scaleFactorField.setHorizontalAlignment(4);
                scaleFactorField.putClientProperty("Palette.Component.segmentPosition", "first");
                scaleFactorField.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(scaleFactorField));
                scaleFactorField.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(0.01, 50.0, 100.0, true, false));
                scaleFactorField.setHorizontalAlignment(10);
                scaleFactorField.setValue(this.view.getScaleFactor());
                scaleFactorField.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getPropertyName().equals("value") && evt.getNewValue() != null) {
                            ViewToolBar.this.view.setScaleFactor((Double)evt.getNewValue());
                        }
                    }
                });
                this.view.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getPropertyName() == "scaleFactor" && evt.getNewValue() != null) {
                            scaleFactorField.setValue((Double)evt.getNewValue());
                        }
                    }
                });
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.insets = new Insets(3, 0, 0, 0);
                gbc.anchor = 23;
                p.add((Component)scaleFactorField, gbc);
                btn = ButtonFactory.createZoomButton(this.view);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                labels.configureToolBarButton(btn, "view.zoomFactor");
                btn.setText("100 %");
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 1;
                gbc.gridwidth = 0;
                gbc.fill = 2;
                gbc.anchor = 23;
                gbc.insets = new Insets(3, 0, 0, 0);
                gbc.weighty = 1.0;
                btn.setPreferredSize(new Dimension(btn.getPreferredSize().width, scaleFactorField.getPreferredSize().height));
                p.add((Component)btn, gbc);
            }
        }
        return p;
    }

    @Override
    protected String getID() {
        return "view";
    }

    private void initComponents() {
        this.setOpaque(false);
    }
}

