/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.analysis;

import java.math.BigDecimal;
import java.math.MathContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.analysis.AbstractOperator;

public class ArithmeticOperator
extends AbstractOperator {
    private Arithmetic arithmetic = Arithmetic.Addition;
    private static final Log log = LogFactory.getLog(ArithmeticOperator.class);

    @Override
    protected Object calculate() {
        Double result = null;
        switch (this.arithmetic) {
            case Addition: {
                result = this.addition();
                break;
            }
            case Subtraction: {
                result = this.subtraction();
                break;
            }
            case Multiplication: {
                result = this.multiplication();
                break;
            }
            case Division: {
                result = this.division();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return result;
    }

    private Double addition() {
        Object object0 = this.inputs[0].getValue();
        Object object1 = this.inputs[1].getValue();
        try {
            BigDecimal d0 = new BigDecimal(object0.toString());
            BigDecimal d1 = new BigDecimal(object1.toString());
            BigDecimal result = d0.add(d1);
            return result.doubleValue();
        }
        catch (NumberFormatException exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
    }

    private Double subtraction() {
        Object object0 = this.inputs[0].getValue();
        Object object1 = this.inputs[1].getValue();
        try {
            BigDecimal d0 = new BigDecimal(object0.toString());
            BigDecimal d1 = new BigDecimal(object1.toString());
            BigDecimal result = d0.subtract(d1);
            return result.doubleValue();
        }
        catch (NumberFormatException exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
    }

    private Double multiplication() {
        Object object0 = this.inputs[0].getValue();
        Object object1 = this.inputs[1].getValue();
        try {
            BigDecimal d0 = new BigDecimal(object0.toString());
            BigDecimal d1 = new BigDecimal(object1.toString());
            BigDecimal result = d0.multiply(d1);
            return result.doubleValue();
        }
        catch (NumberFormatException exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
    }

    private Double division() {
        Object object0 = this.inputs[0].getValue();
        Object object1 = this.inputs[1].getValue();
        try {
            BigDecimal d0 = new BigDecimal(object0.toString());
            BigDecimal d1 = new BigDecimal(object1.toString());
            double d1Value = d1.doubleValue();
            if (d1Value != 0.0) {
                BigDecimal result = d0.divide(d1, MathContext.DECIMAL64);
                return result.doubleValue();
            }
        }
        catch (NumberFormatException exp) {
            log.error(null, (Throwable)exp);
        }
        return null;
    }

    public void setArithmetic(Arithmetic arithmetic) {
        Arithmetic old = this.arithmetic;
        this.arithmetic = arithmetic;
        if (old != this.arithmetic) {
            this.firePropertyChange("attribute", (Object)old, (Object)this.arithmetic);
        }
    }

    public Arithmetic getArithmetic() {
        return this.arithmetic;
    }

    @Override
    public int getNumOfInputConnector() {
        return 2;
    }

    @Override
    public Class getInputClass(int index) {
        return Double.class;
    }

    @Override
    public Class getOutputClass(int index) {
        return Double.class;
    }

    public static enum Arithmetic {
        Addition,
        Subtraction,
        Multiplication,
        Division;

    }
}

