/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.charting;

import com.tictactec.ta.lib.Core;
import com.tictactec.ta.lib.MInteger;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.yccheok.jstock.charting.ChartData;
import org.yccheok.jstock.charting.MACD;
import org.yccheok.jstock.engine.Stock;

public class TechnicalAnalysis {
    public static Double createEMA(List<Double> values, int period) {
        Core core;
        if (period <= 0) {
            throw new IllegalArgumentException("period must be greater than 0");
        }
        int size = values.size();
        int allocationSize = size - (core = new Core()).emaLookback(period);
        if (allocationSize <= 0) {
            return null;
        }
        double[] output = new double[allocationSize];
        MInteger outBegIdx = new MInteger();
        MInteger outNbElement = new MInteger();
        double[] _values = ArrayUtils.toPrimitive((Double[])values.toArray(new Double[0]));
        core.ema(0, values.size() - 1, _values, period, outBegIdx, outNbElement, output);
        return output[outNbElement.value - 1];
    }

    public static Double createMFI(List<Double> highs, List<Double> lows, List<Double> closes, List<Long> volumes, int period) {
        Core core;
        if (period <= 0) {
            throw new IllegalArgumentException("period must be greater than 0");
        }
        if (highs.size() != lows.size() || highs.size() != closes.size() || highs.size() != volumes.size()) {
            throw new IllegalArgumentException("input list must be same size");
        }
        int size = highs.size();
        int allocationSize = size - (core = new Core()).mfiLookback(period);
        if (allocationSize <= 0) {
            return null;
        }
        double[] output = new double[allocationSize];
        MInteger outBegIdx = new MInteger();
        MInteger outNbElement = new MInteger();
        double[] _highs = ArrayUtils.toPrimitive((Double[])highs.toArray(new Double[0]));
        double[] _lows = ArrayUtils.toPrimitive((Double[])lows.toArray(new Double[0]));
        double[] _closes = ArrayUtils.toPrimitive((Double[])closes.toArray(new Double[0]));
        long[] _volumes = ArrayUtils.toPrimitive((Long[])volumes.toArray(new Long[0]));
        double[] dv = new double[_volumes.length];
        for (int i = 0; i < dv.length; ++i) {
            dv[i] = _volumes[i];
        }
        core.mfi(0, _highs.length - 1, _highs, _lows, _closes, dv, period, outBegIdx, outNbElement, output);
        return output[outNbElement.value - 1];
    }

    public static Double createRSI(List<Double> values, int period) {
        Core core;
        if (period <= 0) {
            throw new IllegalArgumentException("period must be greater than 0");
        }
        int size = values.size();
        int allocationSize = size - (core = new Core()).rsiLookback(period);
        if (allocationSize <= 0) {
            return null;
        }
        double[] output = new double[allocationSize];
        MInteger outBegIdx = new MInteger();
        MInteger outNbElement = new MInteger();
        double[] _values = ArrayUtils.toPrimitive((Double[])values.toArray(new Double[0]));
        core.rsi(0, values.size() - 1, _values, period, outBegIdx, outNbElement, output);
        return output[outNbElement.value - 1];
    }

    public static MACD.Result createMACDFix(List<Double> values, int period) {
        Core core;
        if (period <= 0) {
            throw new IllegalArgumentException("period must be greater than 0");
        }
        int size = values.size();
        int allocationSize = size - (core = new Core()).macdFixLookback(period);
        if (allocationSize <= 0) {
            return null;
        }
        double[] outMACD = new double[allocationSize];
        double[] outMACDSignal = new double[allocationSize];
        double[] outMACDHist = new double[allocationSize];
        MInteger outBegIdx = new MInteger();
        MInteger outNbElement = new MInteger();
        double[] _values = ArrayUtils.toPrimitive((Double[])values.toArray(new Double[0]));
        core.macdFix(0, values.size() - 1, _values, period, outBegIdx, outNbElement, outMACD, outMACDSignal, outMACDHist);
        return MACD.Result.newInstance(outMACD[outNbElement.value - 1], outMACDSignal[outNbElement.value - 1], outMACDHist[outNbElement.value - 1]);
    }

    public static TimeSeries createSMA(List<ChartData> chartDatas, String name, int period) {
        Core core;
        if (period <= 0) {
            throw new IllegalArgumentException("period must be greater than 0");
        }
        TimeSeries series = new TimeSeries((Comparable)((Object)name));
        int num = chartDatas.size();
        int allocationSize = num - (core = new Core()).smaLookback(period);
        if (allocationSize <= 0) {
            return series;
        }
        double[] last = new double[num];
        for (int i = 0; i < num; ++i) {
            last[i] = chartDatas.get((int)i).lastPrice;
        }
        double[] output = new double[allocationSize];
        MInteger outBegIdx = new MInteger();
        MInteger outNbElement = new MInteger();
        core.sma(0, last.length - 1, last, period, outBegIdx, outNbElement, output);
        for (int i = 0; i < outNbElement.value; ++i) {
            series.add((RegularTimePeriod)new Day(new Date(chartDatas.get((int)(i + outBegIdx.value)).timestamp)), output[i]);
        }
        return series;
    }

    public static MACD.ChartResult createMACD(List<ChartData> chartDatas, String name, MACD.Period period) {
        Core core;
        int num = chartDatas.size();
        int allocationSize = num - (core = new Core()).macdLookback(period.fastPeriod, period.slowPeriod, period.period);
        if (allocationSize <= 0) {
            return null;
        }
        double[] last = new double[num];
        for (int i = 0; i < num; ++i) {
            last[i] = chartDatas.get((int)i).lastPrice;
        }
        double[] outMACD = new double[allocationSize];
        double[] outMACDSignal = new double[allocationSize];
        double[] outMACDHist = new double[allocationSize];
        MInteger outBegIdx = new MInteger();
        MInteger outNbElement = new MInteger();
        core.macd(0, last.length - 1, last, period.fastPeriod, period.slowPeriod, period.period, outBegIdx, outNbElement, outMACD, outMACDSignal, outMACDHist);
        TimeSeries macdTimeSeries = new TimeSeries((Comparable)((Object)name));
        TimeSeries macdSignalTimeSeries = new TimeSeries((Comparable)((Object)name));
        TimeSeries macdHistTimeSeries = new TimeSeries((Comparable)((Object)name));
        for (int i = 0; i < outNbElement.value; ++i) {
            Day day = new Day(new Date(chartDatas.get((int)(i + outBegIdx.value)).timestamp));
            macdTimeSeries.add((RegularTimePeriod)day, outMACD[i]);
            macdSignalTimeSeries.add((RegularTimePeriod)day, outMACDSignal[i]);
            macdHistTimeSeries.add((RegularTimePeriod)day, outMACDHist[i]);
        }
        return MACD.ChartResult.newInstance((XYDataset)new TimeSeriesCollection(macdTimeSeries), (XYDataset)new TimeSeriesCollection(macdSignalTimeSeries), (XYDataset)new TimeSeriesCollection(macdHistTimeSeries));
    }

    public static TimeSeries createEMA(List<ChartData> chartDatas, String name, int period) {
        Core core;
        if (period <= 0) {
            throw new IllegalArgumentException("period must be greater than 0");
        }
        TimeSeries series = new TimeSeries((Comparable)((Object)name));
        int num = chartDatas.size();
        int allocationSize = num - (core = new Core()).emaLookback(period);
        if (allocationSize <= 0) {
            return series;
        }
        double[] last = new double[num];
        for (int i = 0; i < num; ++i) {
            last[i] = chartDatas.get((int)i).lastPrice;
        }
        double[] output = new double[allocationSize];
        MInteger outBegIdx = new MInteger();
        MInteger outNbElement = new MInteger();
        core.ema(0, last.length - 1, last, period, outBegIdx, outNbElement, output);
        for (int i = 0; i < outNbElement.value; ++i) {
            series.add((RegularTimePeriod)new Day(new Date(chartDatas.get((int)(i + outBegIdx.value)).timestamp)), output[i]);
        }
        return series;
    }

    public static XYDataset createCCI(List<ChartData> chartDatas, String name, int period) {
        Core core;
        if (period <= 0) {
            throw new IllegalArgumentException("period must be greater than 0");
        }
        TimeSeries series = new TimeSeries((Comparable)((Object)name));
        int num = chartDatas.size();
        int allocationSize = num - (core = new Core()).cciLookback(period);
        if (allocationSize <= 0) {
            return new TimeSeriesCollection(series);
        }
        double[] high = new double[num];
        double[] low = new double[num];
        double[] close = new double[num];
        for (int i = 0; i < num; ++i) {
            high[i] = chartDatas.get((int)i).highPrice;
            low[i] = chartDatas.get((int)i).lowPrice;
            close[i] = chartDatas.get((int)i).lastPrice;
        }
        double[] output = new double[allocationSize];
        MInteger outBegIdx = new MInteger();
        MInteger outNbElement = new MInteger();
        core.cci(0, num - 1, high, low, close, period, outBegIdx, outNbElement, output);
        for (int i = 0; i < outNbElement.value; ++i) {
            series.add((RegularTimePeriod)new Day(new Date(chartDatas.get((int)(i + outBegIdx.value)).timestamp)), output[i]);
        }
        return new TimeSeriesCollection(series);
    }

    public static XYDataset createRSI(List<ChartData> chartDatas, String name, int period) {
        Core core;
        if (period <= 0) {
            throw new IllegalArgumentException("period must be greater than 0");
        }
        TimeSeries series = new TimeSeries((Comparable)((Object)name));
        int num = chartDatas.size();
        int allocationSize = num - (core = new Core()).rsiLookback(period);
        if (allocationSize <= 0) {
            return new TimeSeriesCollection(series);
        }
        double[] last = new double[num];
        for (int i = 0; i < num; ++i) {
            last[i] = chartDatas.get((int)i).lastPrice;
        }
        double[] output = new double[allocationSize];
        MInteger outBegIdx = new MInteger();
        MInteger outNbElement = new MInteger();
        core.rsi(0, last.length - 1, last, period, outBegIdx, outNbElement, output);
        for (int i = 0; i < outNbElement.value; ++i) {
            series.add((RegularTimePeriod)new Day(new Date(chartDatas.get((int)(i + outBegIdx.value)).timestamp)), output[i]);
        }
        return new TimeSeriesCollection(series);
    }

    public static XYDataset createMFI(List<ChartData> chartDatas, String name, int period) {
        Core core;
        if (period <= 0) {
            throw new IllegalArgumentException("period must be greater than 0");
        }
        TimeSeries series = new TimeSeries((Comparable)((Object)name));
        int num = chartDatas.size();
        int allocationSize = num - (core = new Core()).mfiLookback(period);
        if (allocationSize <= 0) {
            return new TimeSeriesCollection(series);
        }
        double[] high = new double[num];
        double[] low = new double[num];
        double[] close = new double[num];
        double[] volume = new double[num];
        for (int i = 0; i < num; ++i) {
            high[i] = chartDatas.get((int)i).highPrice;
            low[i] = chartDatas.get((int)i).lowPrice;
            close[i] = chartDatas.get((int)i).lastPrice;
            volume[i] = chartDatas.get((int)i).volume;
        }
        double[] output = new double[allocationSize];
        MInteger outBegIdx = new MInteger();
        MInteger outNbElement = new MInteger();
        core.mfi(0, num - 1, high, low, close, volume, period, outBegIdx, outNbElement, output);
        for (int i = 0; i < outNbElement.value; ++i) {
            series.add((RegularTimePeriod)new Day(new Date(chartDatas.get((int)(i + outBegIdx.value)).timestamp)), output[i]);
        }
        return new TimeSeriesCollection(series);
    }

    public static double getTypicalPrice(Stock stock) {
        return (stock.getHighPrice() + stock.getLowPrice() + stock.getLastPrice()) / 3.0;
    }
}

