/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.ResultSetType;
import org.yccheok.jstock.engine.ResultType;
import org.yccheok.jstock.engine.SearchEngine;
import org.yccheok.jstock.engine.Utils;

public class AjaxYahooSearchEngine
implements SearchEngine<ResultType> {
    private final Gson gson = new Gson();
    private static final Log log = LogFactory.getLog(AjaxYahooSearchEngine.class);

    @Override
    public List<ResultType> searchAll(String prefix) {
        String respond = org.yccheok.jstock.gui.Utils.getResponseBodyAsStringBasedOnProxyAuthOption(this.getURL(prefix));
        String json = Utils.YahooRespondToJSON(respond);
        try {
            Holder value = (Holder)this.gson.fromJson(json, Holder.class);
            if (value != null) {
                return Collections.unmodifiableList(value.ResultSet.Result);
            }
        }
        catch (Exception ex) {
            log.error(null, (Throwable)ex);
        }
        return Collections.emptyList();
    }

    @Override
    public ResultType search(String prefix) {
        List<ResultType> list = this.searchAll(prefix);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private String getURL(String prefix) {
        try {
            String ePrefix = URLEncoder.encode(prefix, "UTF-8");
            String URL2 = "https://mobile-query.finance.yahoo.com/v7/finance/autocomplete?query=" + ePrefix + "&region=US&lang=en-US";
            return URL2;
        }
        catch (UnsupportedEncodingException ex) {
            log.error(null, (Throwable)ex);
            return "";
        }
    }

    private static class Holder {
        public final ResultSetType ResultSet = null;

        private Holder() {
        }
    }
}

