/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BucketList<E> {
    private final int maxBucketSize;
    private final List<E> buckets = new CopyOnWriteArrayList();
    private final Map<E, Integer> bucketsIndexMapping = new HashMap<E, Integer>();
    private final ReadWriteLock bucketsReadWriteLock;
    private final Lock bucketsReaderLock;
    private final Lock bucketsWriterLock;

    public BucketList(int maxBucketSize) {
        if (maxBucketSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.maxBucketSize = maxBucketSize;
        this.bucketsReadWriteLock = new ReentrantReadWriteLock();
        this.bucketsReaderLock = this.bucketsReadWriteLock.readLock();
        this.bucketsWriterLock = this.bucketsReadWriteLock.writeLock();
    }

    public int size() {
        int bucketsSize = this.buckets.size();
        int size = bucketsSize / this.maxBucketSize + (bucketsSize % this.maxBucketSize == 0 ? 0 : 1);
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<E> get(int index) {
        ListIterator<E> listIterator = null;
        this.bucketsReaderLock.lock();
        try {
            int size = this.size();
            if (index >= 0 && index < size) {
                listIterator = this.buckets.listIterator(index * this.maxBucketSize);
            }
        }
        finally {
            this.bucketsReaderLock.unlock();
        }
        if (listIterator != null) {
            ArrayList<E> list = new ArrayList<E>();
            for (int i = 0; listIterator.hasNext() && i < this.maxBucketSize; ++i) {
                list.add(listIterator.next());
            }
            return list;
        }
        return Collections.emptyList();
    }

    public synchronized boolean add(E e) {
        if (this.bucketsIndexMapping.containsKey(e)) {
            return false;
        }
        boolean status = this.buckets.add(e);
        this.bucketsIndexMapping.put(e, this.buckets.size() - 1);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean remove(E e) {
        this.bucketsWriterLock.lock();
        boolean status = false;
        try {
            Integer row = this.bucketsIndexMapping.get(e);
            if (row == null) {
                boolean bl = status;
                return bl;
            }
            status = null != this.buckets.remove(row);
            this.bucketsIndexMapping.remove(e);
            int ei = this.buckets.size();
            for (int i = row.intValue(); i < ei; ++i) {
                this.bucketsIndexMapping.put(this.buckets.get(i), i);
            }
        }
        finally {
            this.bucketsWriterLock.unlock();
        }
        return status;
    }
}

