/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import au.com.bytecode.opencsv.CSVReader;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.EnumMapInstanceCreator;
import org.yccheok.jstock.engine.GoogleCodeSQLiteOpenHelper;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.network.Utils;

public class GoogleCodeDatabaseRunnable
implements Runnable {
    private final Country country;
    private static Map<Country, Long> latestGoogleCodeDatabaseMeta;
    private static final Log log;

    public GoogleCodeDatabaseRunnable(Country country) {
        this.country = country;
    }

    @Override
    public void run() {
        boolean status;
        Long latest;
        Map<Country, Long> latestGoogleCodeDatabaseMeta = GoogleCodeDatabaseRunnable.latestGoogleCodeDatabaseMeta;
        if (latestGoogleCodeDatabaseMeta == null) {
            latestGoogleCodeDatabaseMeta = this.getLatestGoogleCodeDatabaseMeta();
            if (latestGoogleCodeDatabaseMeta == null) {
                return;
            }
            GoogleCodeDatabaseRunnable.latestGoogleCodeDatabaseMeta = latestGoogleCodeDatabaseMeta;
        }
        if ((latest = latestGoogleCodeDatabaseMeta.get((Object)this.country)) == null) {
            return;
        }
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        Long current = jStockOptions.getGoogleCodeDatabaseMetaTimestamp(this.country);
        if (!latest.equals(current) && (status = this.buildGoogleCodeDatabase())) {
            jStockOptions.setGoogleCodeDatabaseMetaTimestamp(this.country, latest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List<Pair<String, String>> getGoogleCodesFromCSVFile(File googleCodeDatabaseFile) {
        InputStreamReader inputStreamReader;
        FileInputStream fileInputStream;
        ArrayList<Pair<String, String>> googleCodes;
        block27: {
            String[] nextLine;
            int google_index;
            int yahoo_index;
            String[] types;
            CSVReader csvreader;
            block25: {
                List<Pair<String, String>> index2222222222;
                block26: {
                    block23: {
                        List<Pair<String, String>> list;
                        block24: {
                            googleCodes = new ArrayList<Pair<String, String>>();
                            fileInputStream = null;
                            inputStreamReader = null;
                            csvreader = null;
                            fileInputStream = new FileInputStream(googleCodeDatabaseFile);
                            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.forName("UTF-8"));
                            csvreader = new CSVReader((Reader)inputStreamReader);
                            types = csvreader.readNext();
                            if (types != null) break block23;
                            list = Collections.emptyList();
                            if (csvreader == null) break block24;
                            try {
                                csvreader.close();
                            }
                            catch (IOException e) {
                                log.error(null, (Throwable)e);
                            }
                        }
                        org.yccheok.jstock.file.Utils.close(inputStreamReader);
                        org.yccheok.jstock.file.Utils.close(fileInputStream);
                        return list;
                    }
                    yahoo_index = -1;
                    google_index = -1;
                    boolean success_index = false;
                    for (int index2222222222 = 0; index2222222222 < types.length; ++index2222222222) {
                        String type = types[index2222222222];
                        if (0 == type.compareToIgnoreCase("yahoo")) {
                            yahoo_index = index2222222222;
                        } else if (0 == type.compareToIgnoreCase("google")) {
                            google_index = index2222222222;
                        }
                        if (yahoo_index != -1 && google_index != -1) break;
                    }
                    boolean bl = success_index = yahoo_index != -1 && google_index != -1;
                    if (success_index) break block25;
                    index2222222222 = Collections.emptyList();
                    if (csvreader == null) break block26;
                    try {
                        csvreader.close();
                    }
                    catch (IOException e) {
                        log.error(null, (Throwable)e);
                    }
                }
                org.yccheok.jstock.file.Utils.close(inputStreamReader);
                org.yccheok.jstock.file.Utils.close(fileInputStream);
                return index2222222222;
            }
            while ((nextLine = csvreader.readNext()) != null) {
                if (nextLine.length != types.length) {
                    log.error((Object)("Incorrect CSV format. There should be exactly " + types.length + " item(s)"));
                    continue;
                }
                String yahoo = nextLine[yahoo_index];
                String google = nextLine[google_index];
                googleCodes.add(Pair.create(yahoo, google));
            }
            if (csvreader == null) break block27;
            try {
                csvreader.close();
                break block27;
            }
            catch (IOException e) {
                log.error(null, (Throwable)e);
            }
            break block27;
            catch (IOException e) {
                List<Pair<String, String>> list;
                block28: {
                    try {
                        log.error(null, (Throwable)e);
                        list = Collections.emptyList();
                        if (csvreader == null) break block28;
                    }
                    catch (Throwable throwable) {
                        if (csvreader != null) {
                            try {
                                csvreader.close();
                            }
                            catch (IOException e2) {
                                log.error(null, (Throwable)e2);
                            }
                        }
                        org.yccheok.jstock.file.Utils.close(inputStreamReader);
                        org.yccheok.jstock.file.Utils.close(fileInputStream);
                        throw throwable;
                    }
                    try {
                        csvreader.close();
                    }
                    catch (IOException e3) {
                        log.error(null, (Throwable)e3);
                    }
                }
                org.yccheok.jstock.file.Utils.close(inputStreamReader);
                org.yccheok.jstock.file.Utils.close(fileInputStream);
                return list;
            }
        }
        org.yccheok.jstock.file.Utils.close(inputStreamReader);
        org.yccheok.jstock.file.Utils.close(fileInputStream);
        return googleCodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean buildGoogleCodeDatabase() {
        String googleCodeDatabaseUrl = Utils.getURL(Utils.Type.GOOGLE_CODE_DATABASE, this.country);
        File googleCodeDatabaseZipFile = org.yccheok.jstock.gui.Utils.downloadAsTempFile(googleCodeDatabaseUrl);
        if (googleCodeDatabaseZipFile == null) {
            return false;
        }
        File tempZipDirectory = null;
        try {
            tempZipDirectory = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
            if (tempZipDirectory == null) {
                boolean bl = false;
                return bl;
            }
            if (!org.yccheok.jstock.gui.Utils.extractZipFile(googleCodeDatabaseZipFile, tempZipDirectory.getAbsolutePath(), true)) {
                boolean bl = false;
                return bl;
            }
            File googleCodeDatabaseFile = new File(tempZipDirectory, "google-code-database.csv");
            List<Pair<String, String>> googleCodes = this.getGoogleCodesFromCSVFile(googleCodeDatabaseFile);
            if (googleCodes.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            boolean result = GoogleCodeSQLiteOpenHelper.INSTANCE.insert(this.country, googleCodes);
            if (result) {
                boolean bl = GoogleCodeSQLiteOpenHelper.INSTANCE.isTableExists(this.country);
                return bl;
            }
        }
        catch (IOException e) {
            log.error(null, (Throwable)e);
        }
        finally {
            if (tempZipDirectory != null) {
                org.yccheok.jstock.gui.Utils.deleteDir(tempZipDirectory);
            }
            googleCodeDatabaseZipFile.delete();
        }
        return false;
    }

    private Map<Country, Long> getLatestGoogleCodeDatabaseMeta() {
        String googleCodeDatabaseMetaUrl = Utils.getURL(Utils.Type.GOOGLE_CODE_DATABASE_META);
        String googleCodeDatabaseMetaJson = org.yccheok.jstock.gui.Utils.getResponseBodyAsStringBasedOnProxyAuthOption(googleCodeDatabaseMetaUrl);
        if (googleCodeDatabaseMetaJson == null) {
            return null;
        }
        Gson gson = this.getGsonForDatabaseMeta();
        EnumMap latestGoogleCodeDatabaseMeta = null;
        try {
            latestGoogleCodeDatabaseMeta = (EnumMap)gson.fromJson(googleCodeDatabaseMetaJson, new TypeToken<EnumMap<Country, Long>>(){}.getType());
        }
        catch (Exception e) {
            log.error(null, (Throwable)e);
        }
        return latestGoogleCodeDatabaseMeta;
    }

    private Gson getGsonForDatabaseMeta() {
        Gson gson = new GsonBuilder().registerTypeAdapter(new TypeToken<EnumMap<Country, Long>>(){}.getType(), new EnumMapInstanceCreator(Country.class)).create();
        return gson;
    }

    public static void clear() {
        latestGoogleCodeDatabaseMeta = null;
    }

    static {
        log = LogFactory.getLog(GoogleCodeDatabaseRunnable.class);
    }
}

