/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Board;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.Duration;
import org.yccheok.jstock.engine.IEXStockServer;
import org.yccheok.jstock.engine.Industry;
import org.yccheok.jstock.engine.Intraday;
import org.yccheok.jstock.engine.Period;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockHistoryNotFoundException;
import org.yccheok.jstock.engine.StockHistoryServer;
import org.yccheok.jstock.engine.StockServer;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.engine.Utils;
import org.yccheok.jstock.engine.iex.chart.DailyChartResponse;
import org.yccheok.jstock.engine.iex.chart.IntradayChartResponse;
import retrofit2.Call;

public class IEXStockHistoryServer
implements StockHistoryServer {
    private static final ThreadLocal<SimpleDateFormat> dateTimeFormatThreadLocal = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.ENGLISH);
            format.setTimeZone(Utils.getTimeZone(Country.UnitedState));
            return format;
        }
    };
    private static final ThreadLocal<SimpleDateFormat> dateFormatThreadLocal = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
            format.setTimeZone(Utils.getTimeZone(Country.UnitedState));
            return format;
        }
    };
    private static final Period DEFAULT_HISTORY_PERIOD = Period.Years10;
    private final Map<Long, Stock> historyDatabase = new HashMap<Long, Stock>();
    private final List<Long> timestamps = new ArrayList<Long>();
    private final Duration duration;
    private final Period period;
    private TimeZone timeZone = null;
    private Intraday intraday = null;
    private static final String TAG = "IEXStockHistoryServer";
    private static final Log log = LogFactory.getLog(IEXStockHistoryServer.class);

    private Period getBestPeriod(Duration duration) {
        Period period = Utils.toBestPeriod(duration, null);
        if (period == Period.Years10) {
            period = Period.Years5;
        }
        return period;
    }

    public IEXStockHistoryServer(Code code) throws StockHistoryNotFoundException {
        this(code, DEFAULT_HISTORY_PERIOD);
    }

    public IEXStockHistoryServer(Code code, Period _period) throws StockHistoryNotFoundException {
        this.period = _period;
        this.duration = null;
        this.timeZone = Utils.getTimeZone(Country.UnitedState);
        String iexCode = Utils.toIEXFormat(code);
        if (this.period == Period.Day1) {
            Call<List<IntradayChartResponse>> call = Utils.getIEXApi().intradayChart(iexCode, Utils.getIEXToken());
            try {
                List results = (List)call.execute().body();
                if (results == null || results.isEmpty()) {
                    throw new StockHistoryNotFoundException(code.toString());
                }
                Stock s = this.getStockServer().getStock(code);
                if (s == null) {
                    throw new StockHistoryNotFoundException(code.toString());
                }
                Symbol symbol = s.symbol;
                String name = s.getName();
                Board board = s.getBoard();
                Industry industry = s.getIndustry();
                String dateStr = null;
                double previousClosePrice = Double.MAX_VALUE;
                int ei = results.size();
                for (int i = 0; i < ei; ++i) {
                    IntradayChartResponse chart = (IntradayChartResponse)results.get(i);
                    double openPrice = chart.getAverage();
                    double closePrice = chart.getAverage();
                    double highPrice = chart.getHigh();
                    double lowPrice = chart.getLow();
                    long volume = chart.getVolume();
                    if (dateStr == null) {
                        Date quoteDate = new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH).parse(chart.getDate());
                        dateStr = dateFormatThreadLocal.get().format(quoteDate);
                    }
                    if (highPrice == 0.0 || lowPrice == 0.0 || volume == 0L || openPrice == 0.0 || openPrice == -1.0) continue;
                    String dateTimeStr = dateStr + " " + chart.getMinute();
                    Date date = dateTimeFormatThreadLocal.get().parse(dateTimeStr);
                    long currentTimeInMilli = date.getTime();
                    double prevPrice = previousClosePrice == Double.MAX_VALUE ? 0.0 : previousClosePrice;
                    double changePrice = previousClosePrice == Double.MAX_VALUE ? 0.0 : closePrice - previousClosePrice;
                    double changePricePercentage = previousClosePrice == Double.MAX_VALUE || previousClosePrice == 0.0 ? 0.0 : changePrice / previousClosePrice * 100.0;
                    Stock stock = new Stock(code, symbol, name, null, board, industry, prevPrice, openPrice, closePrice, highPrice, lowPrice, volume, changePrice, changePricePercentage, 0, 0.0, 0, 0.0, 0, currentTimeInMilli);
                    this.historyDatabase.put(currentTimeInMilli, stock);
                    this.timestamps.add(currentTimeInMilli);
                    previousClosePrice = closePrice;
                }
                String mktOpen = dateStr + " 09:30";
                String mktClose = dateStr + " 16:00";
                this.intraday = new Intraday(dateTimeFormatThreadLocal.get().parse(mktOpen).getTime(), dateTimeFormatThreadLocal.get().parse(mktClose).getTime());
            }
            catch (Exception e) {
                log.error(null, (Throwable)e);
            }
        } else {
            String range = this.period == Period.Days7 ? "1m" : (this.period == Period.Month1 ? "1m" : (this.period == Period.Months3 ? "3m" : (this.period == Period.Months6 ? "6m" : (this.period == Period.Year1 ? "1y" : (this.period == Period.Years5 ? "5y" : "5y")))));
            Call<List<DailyChartResponse>> call = Utils.getIEXApi().dailyChart(iexCode, range, Utils.getIEXToken());
            try {
                List results = (List)call.execute().body();
                if (results == null || results.isEmpty()) {
                    throw new StockHistoryNotFoundException(code.toString());
                }
                Symbol symbol = Symbol.newInstance(code.toString());
                String name = symbol.toString();
                Board board = Board.Unknown;
                Industry industry = Industry.Unknown;
                Stock s = this.getStockServer().getStock(code);
                if (s != null) {
                    symbol = s.symbol;
                    name = s.getName();
                    board = s.getBoard();
                    industry = s.getIndustry();
                }
                double previousClosePrice = Double.MAX_VALUE;
                int ei = results.size();
                if (ei > 0) {
                    DailyChartResponse latestData = (DailyChartResponse)results.get(ei - 1);
                    long latestTs = dateFormatThreadLocal.get().parse(latestData.getDate()).getTime();
                    long startTs = 0L;
                    if (this.period != Period.Day1) {
                        Calendar calendar = Calendar.getInstance(this.timeZone);
                        calendar.setTimeInMillis(latestTs);
                        Utils.resetCalendarTime(calendar);
                        calendar.add(5, -7);
                        startTs = calendar.getTimeInMillis();
                    }
                    for (int i = 0; i < ei; ++i) {
                        DailyChartResponse chart = (DailyChartResponse)results.get(i);
                        double openPrice = chart.getOpen();
                        double closePrice = chart.getClose();
                        double highPrice = chart.getHigh();
                        double lowPrice = chart.getLow();
                        long volume = chart.getVolume();
                        Date date = dateFormatThreadLocal.get().parse(chart.getDate());
                        long currentTimeInMilli = date.getTime();
                        if (this.period == Period.Days7 && currentTimeInMilli < startTs) continue;
                        double prevPrice = previousClosePrice == Double.MAX_VALUE ? 0.0 : previousClosePrice;
                        double changePrice = previousClosePrice == Double.MAX_VALUE ? 0.0 : closePrice - previousClosePrice;
                        double changePricePercentage = previousClosePrice == Double.MAX_VALUE || previousClosePrice == 0.0 ? 0.0 : changePrice / previousClosePrice * 100.0;
                        Stock stock = new Stock(code, symbol, name, null, board, industry, prevPrice, openPrice, closePrice, highPrice, lowPrice, volume, changePrice, changePricePercentage, 0, 0.0, 0, 0.0, 0, currentTimeInMilli);
                        this.historyDatabase.put(currentTimeInMilli, stock);
                        this.timestamps.add(currentTimeInMilli);
                        previousClosePrice = closePrice;
                    }
                }
            }
            catch (Exception e) {
                log.error(null, (Throwable)e);
            }
        }
        if (this.historyDatabase.isEmpty()) {
            throw new StockHistoryNotFoundException(code.toString());
        }
    }

    public IEXStockHistoryServer(Code code, Duration duration) throws StockHistoryNotFoundException {
        long endTimestamp;
        long startTimestamp;
        this.duration = duration;
        this.period = null;
        Period bestPeriod = this.getBestPeriod(duration);
        IEXStockHistoryServer y = new IEXStockHistoryServer(code, bestPeriod);
        this.timeZone = y.timeZone;
        this.intraday = y.intraday;
        if (this.timeZone == null) {
            startTimestamp = duration.getStartDate().getCalendar().getTimeInMillis();
            endTimestamp = duration.getEndDate().getCalendar().getTimeInMillis();
        } else {
            startTimestamp = duration.getStartDate().getCalendar(this.timeZone).getTimeInMillis();
            endTimestamp = duration.getEndDate().getCalendar(this.timeZone).getTimeInMillis();
        }
        int ei = y.timestamps.size();
        for (int i = 0; i < ei; ++i) {
            long timestamp = y.timestamps.get(i);
            if (timestamp < startTimestamp) continue;
            if (timestamp > endTimestamp) break;
            this.timestamps.add(timestamp);
            this.historyDatabase.put(timestamp, y.historyDatabase.get(timestamp));
        }
        if (this.historyDatabase.isEmpty()) {
            throw new StockHistoryNotFoundException(code.toString());
        }
    }

    @Override
    public Stock getStock(long timestamp) {
        return this.historyDatabase.get(timestamp);
    }

    @Override
    public long getTimestamp(int index) {
        return this.timestamps.get(index);
    }

    @Override
    public int size() {
        return this.timestamps.size();
    }

    @Override
    public long getSharesIssued() {
        return 0L;
    }

    @Override
    public long getMarketCapital() {
        return 0L;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public Intraday getIntraday() {
        return this.intraday;
    }

    protected StockServer getStockServer() {
        return new IEXStockServer();
    }
}

