/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.DispType;
import org.yccheok.jstock.engine.Utils;

public class MatchType
implements DispType {
    public final String t;
    public final String n;
    public final String e;
    public final String id;
    private volatile Code code;

    public MatchType(String t, String n, String e, String id) {
        this.t = t;
        this.n = n;
        this.e = e;
        this.id = id;
    }

    public Code getCode() {
        if (this.code != null) {
            return this.code;
        }
        if (this.e == null || this.e.isEmpty()) {
            this.code = Code.newInstance(this.t);
            return this.code;
        }
        String suffix = Utils.toYahooSuffix(this.e);
        if (suffix != null) {
            this.code = Code.newInstance(this.t + "." + suffix);
            return this.code;
        }
        this.code = Code.newInstance(this.t);
        return this.code;
    }

    public MatchType deriveWithT(String t) {
        return new MatchType(t, this.n, this.e, this.id);
    }

    public MatchType deriveWithN(String n) {
        return new MatchType(this.t, n, this.e, this.id);
    }

    public MatchType deriveWithE(String e) {
        return new MatchType(this.t, this.n, e, this.id);
    }

    public String toString() {
        return this.getCode().toString();
    }

    @Override
    public int compareTo(DispType o) {
        return this.getDispCode().compareTo(o.getDispCode());
    }

    @Override
    public String getDispCode() {
        return this.getCode().toString();
    }

    @Override
    public String getDispName() {
        return this.n;
    }

    @Override
    public String getDispExchange() {
        return this.e;
    }
}

