/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yccheok.jstock.engine.SearchEngine;
import org.yccheok.jstock.engine.TSTSearchEngine;
import org.yccheok.jstock.gui.Utils;

public class PinyinTSTSearchEngine<E>
implements SearchEngine<E> {
    private final TSTSearchEngine<String> searchEngine = new TSTSearchEngine();
    private Map<String, List<E>> pinyinMap = new HashMap<String, List<E>>();

    public PinyinTSTSearchEngine(List<E> sources) {
        for (E source : sources) {
            this.put(source);
        }
    }

    public PinyinTSTSearchEngine() {
    }

    @Override
    public List<E> searchAll(String pinyinPrefix) {
        List<String> pinyins = this.searchEngine.searchAll(pinyinPrefix);
        ArrayList<E> list = new ArrayList<E>();
        for (String pinyin : pinyins) {
            List<E> tmps = this.pinyinMap.get(pinyin);
            for (E tmp : tmps) {
                if (list.contains(tmp)) continue;
                list.add(tmp);
            }
        }
        return list;
    }

    @Override
    public E search(String pinyinPrefix) {
        List<String> pinyins = this.searchEngine.searchAll(pinyinPrefix);
        if (!pinyins.isEmpty()) {
            String pinyin = pinyins.get(0);
            List<E> l = this.pinyinMap.get(pinyin);
            return !l.isEmpty() ? (E)l.get(0) : null;
        }
        return null;
    }

    public final void put(E value) {
        List<String> pinyins = Utils.toHanyuPinyin(value.toString());
        for (String pinyin : pinyins) {
            this.searchEngine.put(pinyin);
            List<E> list = this.pinyinMap.get(pinyin);
            if (list == null) {
                list = new ArrayList();
                this.pinyinMap.put(pinyin, list);
            }
            if (list.contains(value)) continue;
            list.add(value);
        }
    }

    public void remove(E value) {
        List<String> pinyins = Utils.toHanyuPinyin(value.toString());
        for (String pinyin : pinyins) {
            this.searchEngine.remove(pinyin);
            List<E> list = this.pinyinMap.get(pinyin);
            list.remove(value);
            if (!list.isEmpty()) continue;
            this.pinyinMap.remove(pinyin);
        }
    }
}

