/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Board;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Duration;
import org.yccheok.jstock.engine.Industry;
import org.yccheok.jstock.engine.Intraday;
import org.yccheok.jstock.engine.Period;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockHistoryNotFoundException;
import org.yccheok.jstock.engine.StockHistoryServer;
import org.yccheok.jstock.engine.StockServer;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.engine.Utils;
import org.yccheok.jstock.engine.YahooStockServer;
import org.yccheok.jstock.engine.yahoo.chart.ChartResponse;
import org.yccheok.jstock.engine.yahoo.chart.Quote;
import org.yccheok.jstock.engine.yahoo.chart.Result;
import org.yccheok.jstock.engine.yahoo.quote.QuoteResponse;
import org.yccheok.jstock.engine.yahoo.quote.QuoteResponse_;
import retrofit2.Call;

public class YahooStockHistoryServer2
implements StockHistoryServer {
    private static final Period DEFAULT_HISTORY_PERIOD = Period.Years10;
    private final Map<Long, Stock> historyDatabase = new HashMap<Long, Stock>();
    private final List<Long> timestamps = new ArrayList<Long>();
    private final Code code;
    private final String query;
    private Stock s;
    private final Duration duration;
    private final Period period;
    private TimeZone timeZone = null;
    private Intraday intraday = null;
    private static final String TAG = "YahooStockHistoryServer";
    private static final Log log = LogFactory.getLog(YahooStockHistoryServer2.class);

    public YahooStockHistoryServer2(Code code) throws StockHistoryNotFoundException {
        this(code, DEFAULT_HISTORY_PERIOD);
    }

    public YahooStockHistoryServer2(Code code, Period _period) throws StockHistoryNotFoundException {
        this.code = code;
        this.period = _period;
        this.duration = null;
        if (this.period != null && this.duration != null || this.period == null && this.duration == null) {
            throw new IllegalArgumentException();
        }
        this.query = this.getYahooCode(code);
        this.initBasedOnPeriodUsingV8(code, this.query);
    }

    public YahooStockHistoryServer2(Code code, Duration duration) throws StockHistoryNotFoundException {
        long endTimestamp;
        long startTimestamp;
        this.code = code;
        this.duration = duration;
        this.period = null;
        if (this.period != null && duration != null || this.period == null && duration == null) {
            throw new IllegalArgumentException();
        }
        this.query = this.getYahooCode(code);
        Period bestPeriod = Utils.toBestPeriod(duration, null);
        YahooStockHistoryServer2 y = new YahooStockHistoryServer2(code, bestPeriod);
        this.s = y.s;
        this.timeZone = y.timeZone;
        this.intraday = y.intraday;
        if (this.timeZone == null) {
            startTimestamp = duration.getStartDate().getCalendar().getTimeInMillis();
            endTimestamp = duration.getEndDate().getCalendar().getTimeInMillis();
        } else {
            startTimestamp = duration.getStartDate().getCalendar(this.timeZone).getTimeInMillis();
            endTimestamp = duration.getEndDate().getCalendar(this.timeZone).getTimeInMillis();
        }
        int ei = y.timestamps.size();
        for (int i = 0; i < ei; ++i) {
            long timestamp = y.timestamps.get(i);
            if (timestamp < startTimestamp) continue;
            if (timestamp > endTimestamp) break;
            this.timestamps.add(timestamp);
            this.historyDatabase.put(timestamp, y.historyDatabase.get(timestamp));
        }
        if (this.historyDatabase.isEmpty()) {
            throw new StockHistoryNotFoundException(code.toString());
        }
    }

    private double toDouble(Double d) {
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    private long toLong(Long l) {
        if (l == null) {
            return 0L;
        }
        return l;
    }

    @Override
    public Stock getStock(long timestamp) {
        return this.historyDatabase.get(timestamp);
    }

    @Override
    public long getTimestamp(int index) {
        return this.timestamps.get(index);
    }

    @Override
    public int size() {
        return this.timestamps.size();
    }

    @Override
    public long getSharesIssued() {
        return 0L;
    }

    @Override
    public long getMarketCapital() {
        return 0L;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public Intraday getIntraday() {
        return this.intraday;
    }

    protected StockServer getStockServer() {
        return new YahooStockServer();
    }

    private String getYahooCode(Code code) {
        String query = Utils.toYahooFormat(code);
        if (Utils.needToResolveUnderlyingCode(code)) {
            Call<QuoteResponse> c = Utils.getYahooFinanceApi().quote(query);
            try {
                QuoteResponse quoteResponse = (QuoteResponse)c.execute().body();
                QuoteResponse_ quoteResponse_ = quoteResponse.getQuoteResponse();
                List<org.yccheok.jstock.engine.yahoo.quote.Result> results = quoteResponse_.getResult();
                String underlyingSymbol = results.get(0).getUnderlyingSymbol();
                if (!org.yccheok.jstock.gui.Utils.isNullOrEmpty(underlyingSymbol)) {
                    query = underlyingSymbol;
                }
            }
            catch (Exception e) {
                log.error(null, (Throwable)e);
            }
        }
        return query;
    }

    private void initBasedOnPeriodUsingV8(Code code, String query) throws StockHistoryNotFoundException {
        Call<ChartResponse> call;
        this.intraday = null;
        this.timeZone = null;
        this.historyDatabase.clear();
        this.timestamps.clear();
        if (this.period == Period.Day1) {
            call = Utils.getYahooFinanceChartApiV8().intradayChart(query);
        } else {
            String range = this.period == Period.Days7 ? "5d" : (this.period == Period.Month1 ? "1mo" : (this.period == Period.Months3 ? "3mo" : (this.period == Period.Months6 ? "6mo" : (this.period == Period.Year1 ? "1y" : (this.period == Period.Years5 ? "5y" : "10y")))));
            call = Utils.getYahooFinanceChartApiV8().dailyChartByRange(query, range);
        }
        this.init(call);
        if (this.historyDatabase.isEmpty()) {
            throw new StockHistoryNotFoundException(code.toString());
        }
    }

    private void init(Call<ChartResponse> call) {
        try {
            ChartResponse chartResponse = (ChartResponse)call.execute().body();
            if (chartResponse == null) {
                return;
            }
            List<Result> results = chartResponse.getChart().getResult();
            if (results.isEmpty()) {
                return;
            }
            Result result = results.get(0);
            List<Long> timestamps = result.getTimestamp();
            int ei = timestamps.size();
            if (ei <= 0) {
                return;
            }
            String timezoneName = result.getMeta().getExchangeTimezoneName();
            this.timeZone = TimeZone.getTimeZone(timezoneName);
            long startTimeInMilli = this.duration == null ? -1L : this.duration.getStartDate().getTime().getTime();
            long endTimeInMilli = this.duration == null ? -1L : this.duration.getEndDate().getTime().getTime();
            this.intraday = this.period == Period.Day1 ? new Intraday(result.getMeta().getTradingPeriods().get(0).get(0).getStart() * 1000L, result.getMeta().getTradingPeriods().get(0).get(0).getEnd() * 1000L) : null;
            Quote quote = result.getIndicators().getQuote().get(0);
            List<Double> closes = quote.getClose();
            List<Double> highs = quote.getHigh();
            List<Double> lows = quote.getLow();
            List<Double> opens = quote.getOpen();
            List<Long> volumes = quote.getVolume();
            double previousClosePrice = Double.MAX_VALUE;
            Symbol symbol = Symbol.newInstance(this.code.toString());
            String name = symbol.toString();
            Board board = Board.Unknown;
            Industry industry = Industry.Unknown;
            this.s = this.getStockServer().getStock(this.code);
            if (this.s != null) {
                symbol = this.s.symbol;
                name = this.s.getName();
                board = this.s.getBoard();
                industry = this.s.getIndustry();
            }
            Calendar calendar = Calendar.getInstance(this.timeZone);
            for (int i = 0; i < ei; ++i) {
                double closePrice;
                long timestamp = timestamps.get(i);
                long currentTimeInMilli = timestamp * 1000L;
                if (this.period != Period.Day1) {
                    calendar.setTimeInMillis(currentTimeInMilli);
                    Utils.resetCalendarTime(calendar);
                    currentTimeInMilli = calendar.getTimeInMillis();
                    if (startTimeInMilli > 0L && currentTimeInMilli < startTimeInMilli) continue;
                    if (endTimeInMilli > 0L && currentTimeInMilli > endTimeInMilli) break;
                }
                if (Utils.essentiallyEqual(closePrice = this.toDouble(closes.get(i)), 0.0)) continue;
                double highPrice = this.toDouble(highs.get(i));
                double lowPrice = this.toDouble(lows.get(i));
                double openPrice = this.toDouble(opens.get(i));
                long volume = this.toLong(volumes.get(i));
                double prevPrice = previousClosePrice == Double.MAX_VALUE ? 0.0 : previousClosePrice;
                double changePrice = previousClosePrice == Double.MAX_VALUE ? 0.0 : closePrice - previousClosePrice;
                double changePricePercentage = previousClosePrice == Double.MAX_VALUE || previousClosePrice == 0.0 ? 0.0 : changePrice / previousClosePrice * 100.0;
                Stock stock = new Stock(this.code, symbol, name, null, board, industry, prevPrice, openPrice, closePrice, highPrice, lowPrice, volume, changePrice, changePricePercentage, 0, 0.0, 0, 0.0, 0, currentTimeInMilli);
                this.historyDatabase.put(currentTimeInMilli, stock);
                this.timestamps.add(currentTimeInMilli);
                previousClosePrice = closePrice;
            }
        }
        catch (Exception e) {
            log.error(null, (Throwable)e);
        }
        if (this.period != Period.Day1) {
            int size = this.timestamps.size();
            if (size <= 1) {
                this.appendHourlyData();
            } else {
                long diff = this.timestamps.get(size - 1) - this.timestamps.get(size - 2);
                if (diff > 2592000000L) {
                    this.appendHourlyData();
                }
            }
        }
    }

    private void appendHourlyData() {
        long endingTimestamp;
        long startingTimestamp;
        String range = null;
        range = this.period == Period.Days7 ? "5d" : (this.period == Period.Month1 ? "1mo" : (this.period == Period.Months3 ? "3mo" : (this.period == Period.Months6 ? "6mo" : "1y")));
        int size = this.timestamps.size();
        if (size <= 1) {
            startingTimestamp = -1L;
            endingTimestamp = size == 0 ? -1L : this.timestamps.get(0);
        } else {
            startingTimestamp = this.timestamps.get(size - 2);
            endingTimestamp = this.timestamps.get(size - 1);
        }
        Call<ChartResponse> call = Utils.getYahooFinanceChartApiV8().hourlyChartByRange(this.query, range);
        HashMap<Long, Stock> h = new HashMap<Long, Stock>();
        ArrayList<Long> t = new ArrayList<Long>();
        try {
            ChartResponse chartResponse = (ChartResponse)call.execute().body();
            if (chartResponse == null) {
                return;
            }
            List<Result> results = chartResponse.getChart().getResult();
            if (results.isEmpty()) {
                return;
            }
            Result result = results.get(0);
            List<Long> timestamps = result.getTimestamp();
            int ei = timestamps.size();
            if (ei <= 0) {
                return;
            }
            Quote quote = result.getIndicators().getQuote().get(0);
            List<Double> closes = quote.getClose();
            List<Double> highs = quote.getHigh();
            List<Double> lows = quote.getLow();
            List<Double> opens = quote.getOpen();
            List<Long> volumes = quote.getVolume();
            double previousClosePrice = Double.MAX_VALUE;
            Symbol symbol = Symbol.newInstance(this.code.toString());
            String name = symbol.toString();
            Board board = Board.Unknown;
            Industry industry = Industry.Unknown;
            if (this.s != null) {
                symbol = this.s.symbol;
                name = this.s.getName();
                board = this.s.getBoard();
                industry = this.s.getIndustry();
            }
            Calendar calendar = Calendar.getInstance(this.timeZone);
            for (int i = 0; i < ei; ++i) {
                long t0 = timestamps.get(i) * 1000L;
                boolean ok = false;
                if (i < ei - 1) {
                    long t1 = timestamps.get(i + 1) * 1000L;
                    ok = t1 - t0 > 43200000L;
                } else if (i == ei - 1) {
                    ok = true;
                }
                if (!ok) continue;
                calendar.setTimeInMillis(t0);
                Utils.resetCalendarTime(calendar);
                t0 = calendar.getTimeInMillis();
                if (startingTimestamp > 0L && t0 <= startingTimestamp) continue;
                if (endingTimestamp <= 0L || t0 < endingTimestamp) {
                    double closePrice = this.toDouble(closes.get(i));
                    if (Utils.essentiallyEqual(closePrice, 0.0)) continue;
                    double highPrice = this.toDouble(highs.get(i));
                    double lowPrice = this.toDouble(lows.get(i));
                    double openPrice = this.toDouble(opens.get(i));
                    long volume = this.toLong(volumes.get(i));
                    double prevPrice = previousClosePrice == Double.MAX_VALUE ? 0.0 : previousClosePrice;
                    double changePrice = previousClosePrice == Double.MAX_VALUE ? 0.0 : closePrice - previousClosePrice;
                    double changePricePercentage = previousClosePrice == Double.MAX_VALUE || previousClosePrice == 0.0 ? 0.0 : changePrice / previousClosePrice * 100.0;
                    Stock stock = new Stock(this.code, symbol, name, null, board, industry, prevPrice, openPrice, closePrice, highPrice, lowPrice, volume, changePrice, changePricePercentage, 0, 0.0, 0, 0.0, 0, t0);
                    h.put(t0, stock);
                    t.add(t0);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.error(null, (Throwable)e);
        }
        int index = Math.max(0, size - 1);
        Iterator iterator = t.iterator();
        while (iterator.hasNext()) {
            long tt = (Long)iterator.next();
            Stock hh = (Stock)h.get(tt);
            this.timestamps.add(index, tt);
            ++index;
            this.historyDatabase.put(tt, hh);
        }
    }
}

