/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yccheok.jstock.analysis.Indicator;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockEx;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.file.CSVHelper;
import org.yccheok.jstock.file.GUIBundleWrapper;
import org.yccheok.jstock.gui.AbstractTableModelWithMemory;
import org.yccheok.jstock.internationalization.GUIBundle;

public class IndicatorTableModel
extends AbstractTableModelWithMemory
implements CSVHelper {
    private List<List<Object>> tableModel = new ArrayList<List<Object>>();
    private List<List<Object>> oldTableModel = new ArrayList<List<Object>>();
    private List<Indicator> indicators = new ArrayList<Indicator>();
    private Map<String, Integer> columnNameMapping = new HashMap<String, Integer>();
    private Map<String, Integer> rowIndicatorMapping = new HashMap<String, Integer>();
    private static final String[] columnNames;
    private static final String[] languageIndependentColumnNames;
    private static final Class[] columnClasses;

    public IndicatorTableModel() {
        for (int i = 0; i < columnNames.length; ++i) {
            this.columnNameMapping.put(columnNames[i], i);
        }
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.tableModel.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        List<Object> indicatorInfo = this.tableModel.get(rowIndex);
        return indicatorInfo.get(columnIndex);
    }

    @Override
    public Object getOldValueAt(int rowIndex, int columnIndex) {
        List<Object> indicatorInfo = this.oldTableModel.get(rowIndex);
        if (null == indicatorInfo) {
            return null;
        }
        return indicatorInfo.get(columnIndex);
    }

    @Override
    public void clearOldValueAt(int rowIndex, int columnIndex) {
        List<Object> indicatorInfo = this.oldTableModel.get(rowIndex);
        if (null == indicatorInfo) {
            return;
        }
        indicatorInfo.set(columnIndex, null);
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    public Class getColumnClass(int c) {
        return columnClasses[c];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        throw new UnsupportedOperationException();
    }

    public void addIndicator(Indicator indicator) {
        Integer row = this.rowIndicatorMapping.get(this.getIndicatorKey(indicator));
        if (row == null) {
            this.tableModel.add(this.indicatorToList(indicator));
            this.oldTableModel.add(null);
            this.indicators.add(indicator);
            int rowIndex = this.tableModel.size() - 1;
            this.rowIndicatorMapping.put(this.getIndicatorKey(indicator), rowIndex);
            this.fireTableRowsInserted(rowIndex, rowIndex);
        } else {
            this.oldTableModel.set(row, this.tableModel.get(row));
            this.tableModel.set(row, this.indicatorToList(indicator));
            this.indicators.set(row, indicator);
            this.fireTableRowsUpdated(row, row);
        }
    }

    public void removeIndicator(Indicator indicator) {
        Integer row = this.rowIndicatorMapping.get(this.getIndicatorKey(indicator));
        if (row != null) {
            int int_row = row;
            this.tableModel.remove(int_row);
            this.oldTableModel.remove(int_row);
            this.indicators.remove(int_row);
            this.rowIndicatorMapping.remove(this.getIndicatorKey(indicator));
            int size = this.indicators.size();
            for (int i = int_row; i < size; ++i) {
                Indicator otherIndicator = this.indicators.get(i);
                this.rowIndicatorMapping.put(this.getIndicatorKey(otherIndicator), i);
            }
            this.fireTableRowsDeleted(int_row, int_row);
        }
    }

    private List<Object> indicatorToList(Indicator indicator) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(indicator.toString());
        Stock stock = indicator.getStock();
        assert (stock != null);
        list.add(stock.code);
        list.add(stock.symbol);
        list.add(stock.getPrevPrice());
        list.add(stock.getOpenPrice());
        list.add(stock.getLastPrice());
        list.add(stock.getHighPrice());
        list.add(stock.getLowPrice());
        list.add(stock.getVolume());
        list.add(stock.getChangePrice());
        list.add(stock.getChangePricePercentage());
        list.add(stock.getLastVolume());
        list.add(stock.getBuyPrice());
        list.add(stock.getBuyQuantity());
        list.add(stock.getSellPrice());
        list.add(stock.getSellQuantity());
        if (stock instanceof StockEx) {
            StockEx stockEx = (StockEx)stock;
            list.add(stockEx.getMarketCapital());
            list.add(stockEx.getSharesIssued());
        } else {
            list.add(0);
            list.add(0);
        }
        return list;
    }

    public Indicator getIndicator(int row) {
        return this.indicators.get(row);
    }

    public void removeAll() {
        int size = this.tableModel.size();
        if (size == 0) {
            return;
        }
        this.tableModel.clear();
        this.oldTableModel.clear();
        this.indicators.clear();
        this.rowIndicatorMapping.clear();
        this.fireTableRowsDeleted(0, size - 1);
    }

    public void removeRow(int row) {
        List<Object> list = this.tableModel.remove(row);
        this.oldTableModel.remove(row);
        this.indicators.remove(row);
        this.rowIndicatorMapping.remove(list.get(0).toString() + list.get(1).toString());
        int size = this.indicators.size();
        for (int i = row; i < size; ++i) {
            Indicator indicator = this.indicators.get(i);
            this.rowIndicatorMapping.put(this.getIndicatorKey(indicator), i);
        }
        this.fireTableRowsDeleted(row, row);
    }

    private String getIndicatorKey(Indicator indicator) {
        assert (indicator.getStock() != null);
        return indicator.toString() + indicator.getStock().code;
    }

    @Override
    public int findColumn(String columnName) {
        Integer integer = this.columnNameMapping.get(columnName);
        if (integer == null) {
            return -1;
        }
        return integer;
    }

    public int findRow(Indicator indicator) {
        Integer row = this.rowIndicatorMapping.get(this.getIndicatorKey(indicator));
        if (row != null) {
            return row;
        }
        return -1;
    }

    @Override
    public String getLanguageIndependentColumnName(int columnIndex) {
        return languageIndependentColumnNames[columnIndex];
    }

    static {
        columnClasses = new Class[]{String.class, Code.class, Symbol.class, Double.class, Double.class, Double.class, Double.class, Double.class, Long.class, Double.class, Double.class, Integer.class, Double.class, Integer.class, Double.class, Integer.class, Long.class, Long.class};
        String[] tmp = new String[]{GUIBundle.getString("IndicatorScannerJPanel_Indicator"), GUIBundle.getString("MainFrame_Code"), GUIBundle.getString("MainFrame_Symbol"), GUIBundle.getString("MainFrame_Prev"), GUIBundle.getString("MainFrame_Open"), GUIBundle.getString("MainFrame_Last"), GUIBundle.getString("MainFrame_High"), GUIBundle.getString("MainFrame_Low"), GUIBundle.getString("MainFrame_Vol"), GUIBundle.getString("MainFrame_Chg"), GUIBundle.getString("MainFrame_ChgPercentage"), GUIBundle.getString("MainFrame_LVol"), GUIBundle.getString("MainFrame_Buy"), GUIBundle.getString("MainFrame_BQty"), GUIBundle.getString("MainFrame_Sell"), GUIBundle.getString("MainFrame_SQty"), GUIBundle.getString("IndicatorScannerJPanel_MCapital"), GUIBundle.getString("IndicatorScannerJPanel_SIssued")};
        GUIBundleWrapper guiBundleWrapper = GUIBundleWrapper.newInstance(GUIBundleWrapper.Language.INDEPENDENT);
        String[] tmp2 = new String[]{guiBundleWrapper.getString("IndicatorScannerJPanel_Indicator"), guiBundleWrapper.getString("MainFrame_Code"), guiBundleWrapper.getString("MainFrame_Symbol"), guiBundleWrapper.getString("MainFrame_Prev"), guiBundleWrapper.getString("MainFrame_Open"), guiBundleWrapper.getString("MainFrame_Last"), guiBundleWrapper.getString("MainFrame_High"), guiBundleWrapper.getString("MainFrame_Low"), guiBundleWrapper.getString("MainFrame_Vol"), guiBundleWrapper.getString("MainFrame_Chg"), guiBundleWrapper.getString("MainFrame_ChgPercentage"), guiBundleWrapper.getString("MainFrame_LVol"), guiBundleWrapper.getString("MainFrame_Buy"), guiBundleWrapper.getString("MainFrame_BQty"), guiBundleWrapper.getString("MainFrame_Sell"), guiBundleWrapper.getString("MainFrame_SQty"), guiBundleWrapper.getString("IndicatorScannerJPanel_MCapital"), guiBundleWrapper.getString("IndicatorScannerJPanel_SIssued")};
        columnNames = tmp;
        languageIndependentColumnNames = tmp2;
    }
}

