/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.PriceSource;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.JStockOptionsObserver;
import org.yccheok.jstock.gui.OptionsJPanel;
import org.yccheok.jstock.portfolio.DecimalPlace;

public class OptionsJDialog
extends JDialog
implements JStockOptionsObserver {
    private OptionsJPanel optionsJPanel;
    private JStockOptions jStockOptions;
    private JButton jButton1;
    private JButton jButton2;
    private JPanel jPanel1;

    public OptionsJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("JStock Options");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                OptionsJDialog.this.formWindowClosed(evt);
            }
        });
        this.optionsJPanel = new OptionsJPanel();
        this.getContentPane().add((Component)this.optionsJPanel, "Center");
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/apply.png")));
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.jButton1.setText(bundle.getString("OptionsJDialog_OK"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsJDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton1);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/button_cancel.png")));
        this.jButton2.setText(bundle.getString("OptionsJDialog_Cancel"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsJDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton2);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.pack();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        Country country = this.jStockOptions.getCountry();
        int oldScanningSpeed = this.jStockOptions.getScanningSpeed();
        boolean oldIsFeeCalculationEnabled = this.jStockOptions.isFeeCalculationEnabled();
        boolean oldIsDynamicChartVisible = this.jStockOptions.isDynamicChartVisible();
        DecimalPlace oldDecimalPlace = this.jStockOptions.getDecimalPlace();
        boolean oldIsCurrencyExchangeEnable = this.jStockOptions.isCurrencyExchangeEnable(country);
        PriceSource oldPriceSource = this.jStockOptions.getPriceSource(country);
        Country oldLocalCurrencyCountry = this.jStockOptions.getLocalCurrencyCountry(country);
        boolean oldPreferLongName = this.jStockOptions.isPreferLongName(country);
        if (!this.apply(this.jStockOptions)) {
            return;
        }
        if (oldPriceSource != this.jStockOptions.getPriceSource(this.jStockOptions.getCountry())) {
            JStock.instance().updatePriceSource(this.jStockOptions.getCountry(), this.jStockOptions.getPriceSource(this.jStockOptions.getCountry()));
        }
        if (oldPreferLongName != this.jStockOptions.isPreferLongName(country) || oldScanningSpeed != this.jStockOptions.getScanningSpeed()) {
            JStock.instance().refreshAllRealTimeStockMonitors();
            JStock.instance().refreshRealTimeIndexMonitor();
        }
        if (oldIsFeeCalculationEnabled != this.jStockOptions.isFeeCalculationEnabled()) {
            JStock.instance().getPortfolioManagementJPanel().refreshGUIAfterFeeCalculationEnabledOptionsChanged();
        }
        if (oldIsDynamicChartVisible != this.jStockOptions.isDynamicChartVisible()) {
            JStock.instance().initDynamicChartVisibility();
        }
        if (oldIsCurrencyExchangeEnable != this.jStockOptions.isCurrencyExchangeEnable(country) || oldLocalCurrencyCountry != this.jStockOptions.getLocalCurrencyCountry(country) || oldDecimalPlace != this.jStockOptions.getDecimalPlace()) {
            JStock.instance().getPortfolioManagementJPanel().refreshGUIAfterOptionsJDialog();
        }
        this.setVisible(false);
        this.dispose();
    }

    private void formWindowClosed(WindowEvent evt) {
        this.optionsJPanel.cancel();
    }

    @Override
    public void set(JStockOptions jStockOptions) {
        this.optionsJPanel.set(jStockOptions);
        this.jStockOptions = jStockOptions;
    }

    @Override
    public boolean apply(JStockOptions jStockOptions) {
        return this.optionsJPanel.apply(jStockOptions);
    }

    public void select(String buttonMapKey) {
        this.optionsJPanel.select(buttonMapKey);
    }
}

